/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.utils;

import com.baijia.orgclass.common.enums.AuditStatus;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassCourseM;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgClassInfoM;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgClassScheduleM;
import com.baijia.orgclass.facade.dto.OrgClassScheduleDto;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class AuditUtils {
    public static final boolean courseAuditCheck(OrgClassCourse now, OrgClassCourse old) {
        Preconditions.checkNotNull((Object)now);
        if (old == null) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((CharSequence)now.getName(), (CharSequence)old.getName());
    }

    public static final boolean courseAuditCheck(OrgClassCourse course, OrgClassCourseM cm) {
        Preconditions.checkNotNull((Object)course);
        if (cm == null && (course.getAuditStatus() == null || course.getAuditStatus().intValue() != AuditStatus.PASS.getValue())) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((CharSequence)cm.getName(), (CharSequence)course.getName());
    }

    public static final boolean classAuditCheck(OrgClassInfo now, OrgClassInfo old) {
        Preconditions.checkNotNull((Object)now);
        if (old == null) {
            return true;
        }
        if (now.getTitle() != null && !StringUtils.equals((CharSequence)now.getTitle(), (CharSequence)old.getTitle())) {
            return true;
        }
        if (now.getStorageId() != null) {
            if (old.getStorageId() == null) {
                return true;
            }
            if (now.getStorageId().intValue() != old.getStorageId().intValue()) {
                return true;
            }
        }
        if (now.getVideoId() != null) {
            if (old.getVideoId() == null) {
                return true;
            }
            if ((long)now.getVideoId().intValue() != old.getVideoId()) {
                return true;
            }
        }
        return !StringUtils.equalsIgnoreCase((CharSequence)now.getInfo(), (CharSequence)old.getInfo());
    }

    public static final boolean classAuditCheck(OrgClassInfo info, OrgClassInfoM im) {
        Preconditions.checkNotNull((Object)info);
        if (im == null && (info.getAuditStatus() == null || info.getAuditStatus().intValue() != AuditStatus.PASS.getValue())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)info.getTitle(), (CharSequence)im.getTitle())) {
            return true;
        }
        if (info.getStorageId().intValue() != im.getStorageId().intValue()) {
            return true;
        }
        if ((long)info.getVideoId().intValue() != im.getVideoId()) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((CharSequence)info.getInfo(), (CharSequence)im.getInfo());
    }

    public static final boolean scheduleAuditCheck(OrgClassSchedule now, OrgClassSchedule old) {
        if (old == null) {
            return true;
        }
        return !StringUtils.equals((CharSequence)now.getName(), (CharSequence)old.getName());
    }

    public static final boolean scheduleAuditCheck(OrgClassSchedule schedule, OrgClassScheduleM schedulem) {
        if (schedulem == null && (schedule.getAuditStatus() == null || schedule.getAuditStatus().intValue() != AuditStatus.PASS.getValue())) {
            return true;
        }
        return !StringUtils.equals((CharSequence)schedule.getName(), (CharSequence)schedulem.getName());
    }

    public static boolean isUpdateLiveRoomInfoCheck(OrgClassScheduleDto now, OrgClassSchedule old) {
        boolean isUpdateRoomInfo = false;
        if (old.getRoomNo() != 0L) {
            if (!now.getName().equals(old.getName())) {
                isUpdateRoomInfo = true;
                return isUpdateRoomInfo;
            }
            if (now.getStartTime() != null && !now.getStartTime().equals(old.getStartTime()) && now.getStartTime().after(new Date())) {
                isUpdateRoomInfo = true;
                return isUpdateRoomInfo;
            }
            if (now.getEndTime() != null && !now.getEndTime().equals(old.getEndTime()) && now.getEndTime().after(new Date())) {
                isUpdateRoomInfo = true;
                return isUpdateRoomInfo;
            }
        }
        return isUpdateRoomInfo;
    }
}

