/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.sub.impl;

import com.baijia.orgclass.common.enums.AuditStatus;
import com.baijia.orgclass.common.enums.ClassStatusEnums;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.enums.ResponseEnums;
import com.baijia.orgclass.common.response.WebResponse;
import com.baijia.orgclass.common.utils.SerialNumberUtil;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassCourseMCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoMCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleMCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassCourseM;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgClassInfoM;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgClassScheduleM;
import com.baijia.orgclass.facade.dto.ClassBatchUpdateResDto;
import com.baijia.orgclass.facade.dto.OrgClassInfoDto;
import com.baijia.orgclass.service.sub.OrgClassInfoService;
import com.baijia.orgclass.service.utils.AuditUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgClassInfoServiceImpl
implements OrgClassInfoService {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassInfoServiceImpl.class);
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassCourseMCompent orgClassCourseMCompent;
    @Autowired
    private OrgClassInfoMCompent orgClassInfoMCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgClassScheduleMCompent orgClassScheduleMCompent;

    @Override
    public long doInsert(OrgClassInfo info) {
        info.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        info.setNumber(null);
        info.setId(null);
        long count = this.orgClassInfoCompent.insert4Id(info);
        if (0L == count) {
            return 0L;
        }
        Long id = info.getId();
        OrgClassCourseEnums enums = OrgClassCourseEnums.parse((Integer)info.getClassType());
        long number = SerialNumberUtil.generateClassInfoNumber((int)id.intValue(), (OrgClassCourseEnums)enums);
        info = new OrgClassInfo();
        info.setId(id);
        info.setNumber(Long.valueOf(number));
        this.orgClassInfoCompent.updateById(info);
        return id;
    }

    @Override
    public WebResponse<ClassBatchUpdateResDto> batchHandle(List<Long> idList, int orgId, ClassStatusEnums enums) {
        List courseList = this.orgClassCourseCompent.selectByInfoIdList(idList, orgId);
        List infoList = this.orgClassInfoCompent.getByIdList(idList, false);
        WebResponse<ClassBatchUpdateResDto> res = new WebResponse<ClassBatchUpdateResDto>();
        HashMap mm = Maps.newHashMap();
        res = this.check(infoList, courseList, idList, orgId, enums, mm);
        if (res.getCode() != 0) {
            return res;
        }
        OrgClassCourse course = new OrgClassCourse();
        course.setStatus(Integer.valueOf(enums.getState()));
        this.orgClassCourseCompent.updateByClassIdList(course, idList, orgId);
        OrgClassCourseM coursem = new OrgClassCourseM();
        coursem.setStatus(Integer.valueOf(enums.getState()));
        this.orgClassCourseMCompent.updateByClassIdList(coursem, idList, orgId);
        this.updateClassStatus(idList, enums.getState(), orgId, AuditStatus.INIT.getValue());
        res.setCode(0);
        if (enums.getState() == ClassStatusEnums.DELETE.getState()) {
            this.orgClassGradeCompent.deleteByClassId(idList);
        }
        return res;
    }

    private WebResponse<ClassBatchUpdateResDto> check(List<OrgClassInfo> infoList, List<OrgClassCourse> courseList, List<Long> idList, Integer orgId, ClassStatusEnums enums, Map<Long, OrgClassCourseM> mm) {
        WebResponse res = new WebResponse();
        res.setCode(1);
        logger.info("check infoList:{},courseList:{}", infoList, courseList);
        if (CollectionUtils.isEmpty(infoList)) {
            res.setCode(ResponseEnums.NO_CLASS.getCode());
            res.setMsg(ResponseEnums.NO_CLASS.getMsg());
            return res;
        }
        if (enums != ClassStatusEnums.DELETE && CollectionUtils.isEmpty(courseList)) {
            res.setCode(ResponseEnums.NO_COURSE.getCode());
            res.setMsg(ResponseEnums.NO_COURSE.getMsg());
            return res;
        }
        HashMap infoIdMap = Maps.newHashMap();
        for (OrgClassCourse course : courseList) {
            long infoId = course.getOrgClassId();
            OrgClassCourseM m = mm.get(infoId);
            if (enums == ClassStatusEnums.ENROLLING && m == null || ClassStatusEnums.AUDIT.getState() != course.getStatus().intValue() || AuditStatus.PENDING.getValue() != course.getAuditStatus().intValue()) continue;
            infoIdMap.put("" + infoId, "");
        }
        HashMap resultMap = Maps.newHashMap();
        for (OrgClassInfo info : infoList) {
            String key = "" + info.getId();
            if (info.getAuditStatus().intValue() == AuditStatus.PENDING.getValue()) {
                resultMap.put(key, info);
            } else if (enums == ClassStatusEnums.OFF_SHELVES) {
                if (ClassStatusEnums.NEW.getState() == info.getStatus().intValue()) {
                    resultMap.put(key, info);
                } else if (info.getAuditStatus().intValue() == AuditStatus.LETV_REJECT.getValue()) {
                    resultMap.put(key, info);
                }
            }
            if (infoIdMap.get(key) == null) continue;
            resultMap.put(key, info);
        }
        if (resultMap.isEmpty()) {
            res.setCode(0);
            return res;
        }
        Iterator it = resultMap.keySet().iterator();
        ArrayList dtoList = Lists.newArrayList();
        idList.clear();
        while (it.hasNext()) {
            OrgClassInfo info = (OrgClassInfo)resultMap.get(it.next());
            idList.add(info.getId());
            OrgClassInfoDto dto = new OrgClassInfoDto();
            dto.setId(info.getId());
            dto.setNumber(info.getNumber());
            dto.setTitle(info.getTitle());
            dtoList.add(dto);
        }
        ClassBatchUpdateResDto data = new ClassBatchUpdateResDto();
        data.setList((List)dtoList);
        res.setData((Object)data);
        return res;
    }

    @Override
    public WebResponse<ClassBatchUpdateResDto> onShelves(List<Long> idList, int orgId) {
        List courseList = this.orgClassCourseCompent.selectByInfoIdList(idList, orgId);
        List infoList = this.orgClassInfoCompent.getByIdList(idList, false);
        WebResponse<ClassBatchUpdateResDto> res = new WebResponse<ClassBatchUpdateResDto>();
        List courseMList = this.orgClassCourseMCompent.selectByInfoIdList(idList, orgId);
        HashMap mm = Maps.newHashMap();
        for (OrgClassCourseM m : courseMList) {
            mm.put(m.getId(), m);
        }
        res = this.check(infoList, courseList, idList, orgId, ClassStatusEnums.ENROLLING, mm);
        if (res.getCode() != 0) {
            return res;
        }
        ArrayList courseOnIdList = Lists.newArrayList();
        ArrayList cauditIdList = Lists.newArrayList();
        this.courseHandle(courseOnIdList, cauditIdList, courseList, courseMList);
        List infoMList = this.orgClassInfoMCompent.getByIdList(idList, false);
        ArrayList classOnIdList = Lists.newArrayList();
        ArrayList clauditIdList = Lists.newArrayList();
        this.classHandle(classOnIdList, clauditIdList, infoList, infoMList);
        ArrayList scheduleOnIdList = Lists.newArrayList();
        ArrayList sauditIdList = Lists.newArrayList();
        List scheduleList = this.orgClassScheduleCompent.getByInfoId(idList, orgId);
        List scheduleMList = this.orgClassScheduleMCompent.getByInfoId(idList, orgId);
        this.scheduleHandle(scheduleOnIdList, sauditIdList, scheduleList, scheduleMList);
        if (CollectionUtils.isNotEmpty((Collection)scheduleOnIdList)) {
            this.updateScheduleOnShelves(scheduleOnIdList, scheduleList);
        }
        if (CollectionUtils.isNotEmpty((Collection)courseOnIdList)) {
            this.updateCourseOnShelves(courseOnIdList, courseList);
        }
        if (CollectionUtils.isNotEmpty((Collection)classOnIdList)) {
            this.updateClassOnShelves(classOnIdList, infoList, orgId);
        }
        if (CollectionUtils.isNotEmpty((Collection)sauditIdList)) {
            this.updateScheduleStatus(sauditIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)cauditIdList)) {
            this.updateCourseStatus(cauditIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)clauditIdList)) {
            this.updateClassStatus(clauditIdList, ClassStatusEnums.AUDIT.getState(), orgId, AuditStatus.PENDING.getValue());
        }
        ClassBatchUpdateResDto data = new ClassBatchUpdateResDto();
        data.setAuditClassIdList((List)clauditIdList);
        data.setAuditCourseIdList((List)cauditIdList);
        data.setAuditScheduleIdList((List)sauditIdList);
        res.setData((Object)data);
        res.setCode(0);
        return res;
    }

    private void updateScheduleOnShelves(List<Long> idList, List<OrgClassSchedule> scheduleList) {
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setAuditStatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        HashMap map = Maps.newHashMap();
        for (Long id : idList) {
            map.put(id, "");
        }
        ArrayList scheduleMList = Lists.newArrayList();
        for (OrgClassSchedule occ : scheduleList) {
            if (map.get(occ.getId()) == null) continue;
            try {
                OrgClassScheduleM schedulem = new OrgClassScheduleM();
                BeanUtils.copyProperties((Object)schedulem, (Object)occ);
                scheduleMList.add(schedulem);
            }
            catch (Exception e) {
                logger.error("updateScheduleOnShelves e - ", (Throwable)e);
            }
        }
        this.orgClassScheduleMCompent.updateList((List)scheduleMList);
        this.orgClassScheduleCompent.updateByIdList(schedule, idList);
    }

    private void updateCourseOnShelves(List<Long> idList, List<OrgClassCourse> courseList) {
        OrgClassCourse course = new OrgClassCourse();
        course.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
        course.setAuditStatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        HashMap map = Maps.newHashMap();
        for (Long id : idList) {
            map.put(id, "");
        }
        ArrayList courseMList = Lists.newArrayList();
        for (OrgClassCourse occ : courseList) {
            if (map.get(occ.getId()) == null) continue;
            try {
                OrgClassCourseM coursem = new OrgClassCourseM();
                BeanUtils.copyProperties((Object)coursem, (Object)occ);
                coursem.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
                courseMList.add(coursem);
            }
            catch (Exception e) {
                logger.error("updateCourse e - ", (Throwable)e);
            }
        }
        this.orgClassCourseMCompent.updateList((List)courseMList);
        this.orgClassCourseCompent.updateByIdList(course, idList);
    }

    private void updateScheduleStatus(List<Long> idList) {
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setAuditStatus(Integer.valueOf(AuditStatus.PENDING.getValue()));
        this.orgClassScheduleCompent.updateByIdList(schedule, idList);
    }

    private void updateCourseStatus(List<Long> idList) {
        OrgClassCourse course = new OrgClassCourse();
        course.setStatus(Integer.valueOf(ClassStatusEnums.AUDIT.getState()));
        course.setAuditStatus(Integer.valueOf(AuditStatus.PENDING.getValue()));
        this.orgClassCourseCompent.updateByIdList(course, idList);
    }

    private void updateClassOnShelves(List<Long> idList, List<OrgClassInfo> infoList, int orgId) {
        OrgClassInfo info = new OrgClassInfo();
        info.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
        info.setAuditStatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        HashMap map = Maps.newHashMap();
        for (Long id : idList) {
            map.put(id, "");
        }
        ArrayList infomList = Lists.newArrayList();
        for (OrgClassInfo calss : infoList) {
            if (map.get(calss.getId()) == null) continue;
            try {
                OrgClassInfoM infom = new OrgClassInfoM();
                BeanUtils.copyProperties((Object)infom, (Object)calss);
                infom.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
                infomList.add(infom);
            }
            catch (Exception e) {
                logger.error("updateClass e - ", (Throwable)e);
            }
        }
        this.orgClassInfoMCompent.updateList((List)infomList);
        this.orgClassInfoCompent.update(info, idList, orgId);
    }

    private void updateClassStatus(List<Long> idList, int state, int orgId, int auditStatus) {
        OrgClassInfo info = new OrgClassInfo();
        info.setStatus(Integer.valueOf(state));
        info.setAuditStatus(Integer.valueOf(auditStatus));
        this.orgClassInfoCompent.update(info, idList, orgId);
        if (ClassStatusEnums.DELETE.getState() == state || ClassStatusEnums.OFF_SHELVES.getState() == state) {
            OrgClassInfoM infom = new OrgClassInfoM();
            infom.setStatus(Integer.valueOf(state));
            this.orgClassInfoMCompent.update(infom, idList, orgId);
        }
    }

    private void classHandle(List<Long> classOnIdList, List<Long> clauditIdList, List<OrgClassInfo> infoList, List<OrgClassInfoM> infoMList) {
        HashMap infoMap = Maps.newHashMap();
        for (OrgClassInfoM im : infoMList) {
            infoMap.put("" + im.getId(), im);
        }
        for (OrgClassInfo info : infoList) {
            long id;
            OrgClassInfoM im;
            if (AuditUtils.classAuditCheck(info, im = (OrgClassInfoM)infoMap.get("" + (id = info.getId().longValue())))) {
                clauditIdList.add(id);
                continue;
            }
            classOnIdList.add(id);
        }
    }

    private void courseHandle(List<Long> courseOnIdList, List<Long> cauditIdList, List<OrgClassCourse> courseList, List<OrgClassCourseM> courseMList) {
        HashMap courseMap = Maps.newHashMap();
        for (OrgClassCourseM cm : courseMList) {
            courseMap.put("" + cm.getId(), cm);
        }
        for (OrgClassCourse course : courseList) {
            long id;
            OrgClassCourseM cm;
            if (AuditUtils.courseAuditCheck(course, cm = (OrgClassCourseM)courseMap.get("" + (id = course.getId().longValue())))) {
                cauditIdList.add(id);
                continue;
            }
            courseOnIdList.add(id);
        }
    }

    private void scheduleHandle(List<Long> scheduleOnIdList, List<Long> sauditIdList, List<OrgClassSchedule> scheduleList, List<OrgClassScheduleM> scheduleMList) {
        HashMap scheduleMap = Maps.newHashMap();
        for (OrgClassScheduleM sm : scheduleMList) {
            scheduleMap.put("" + sm.getId(), sm);
        }
        for (OrgClassSchedule schedule : scheduleList) {
            long id;
            OrgClassScheduleM sm;
            if (AuditUtils.scheduleAuditCheck(schedule, sm = (OrgClassScheduleM)scheduleMap.get("" + (id = schedule.getId().longValue())))) {
                sauditIdList.add(id);
                continue;
            }
            scheduleOnIdList.add(id);
        }
    }
}

