/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.sub.impl;

import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.facade.dto.OrgClassCourseDto;
import com.baijia.orgclass.service.sub.OrgClassGradeService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgClassGradeServiceImpl
implements OrgClassGradeService {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassGradeServiceImpl.class);
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;

    @Override
    public void copyGrade(Long oldCourseId, int classType, Long newCourseId, int orgId, long infoId) {
        logger.info("copyGrade newCourseList:{} ,newCourseId:{}", (Object)oldCourseId, (Object)newCourseId);
        if (OrgClassCourseEnums.CLASS.getCode() == classType) {
            OrgClassGrade grade = new OrgClassGrade();
            grade.setCourseId(oldCourseId);
            grade = this.orgClassGradeCompent.selectOne(grade, orgId);
            if (grade == null) {
                return;
            }
            OrgClassGrade newGrade = new OrgClassGrade();
            newGrade.setCourseId(newCourseId);
            newGrade = this.orgClassGradeCompent.selectOne(newGrade, orgId);
            this.orgClassScheduleCompent.copy(grade.getId().longValue(), orgId, newGrade.getId().longValue(), newCourseId.longValue(), infoId);
        }
    }

    @Override
    public void handleGrade(List<Long> courseIdList, List<OrgClassCourseDto> cdtoList) {
        if (CollectionUtils.isEmpty(courseIdList)) {
            return;
        }
        List gradeList = this.orgClassGradeCompent.getByCourseIdList(courseIdList);
        if (CollectionUtils.isEmpty((Collection)gradeList)) {
            return;
        }
        HashMap gm = Maps.newHashMap();
        for (OrgClassGrade grade : gradeList) {
            String key = "" + grade.getCourseId();
            List gradeNumberList = (List)gm.get(key);
            if (gradeNumberList == null) {
                gradeNumberList = Lists.newArrayList();
                gm.put(key, gradeNumberList);
            }
            gradeNumberList.add(grade.getNumber());
        }
        for (OrgClassCourseDto dto : cdtoList) {
            List gradeNumberList = (List)gm.get("" + dto.getId());
            if (gradeNumberList == null) {
                List tmp = Collections.emptyList();
                dto.setGradeNumberList(tmp);
                continue;
            }
            dto.setGradeNumberList(gradeNumberList);
        }
    }
}

