/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.sub.impl;

import com.baijia.orgclass.common.enums.ClassStatusEnums;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.exception.BussinessException;
import com.baijia.orgclass.common.response.WebResponseCodeEnums;
import com.baijia.orgclass.common.utils.SerialNumberUtil;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.facade.dto.CourseInsertResDto;
import com.baijia.orgclass.service.sub.OrgClassCourseService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgClassCourseApiImpl
implements OrgClassCourseService {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassCourseApiImpl.class);
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;

    @Override
    public CourseInsertResDto doInsert(OrgClassCourse course, OrgClassInfo info) {
        CourseInsertResDto dto = new CourseInsertResDto();
        Date endTime = course.getEndDate();
        String name = course.getName();
        course.setId(null);
        course.setNumber(null);
        course.setStatus(Integer.valueOf(ClassStatusEnums.NEW.getState()));
        long count = this.orgClassCourseCompent.insert4Id(course);
        if (count == 0L) {
            logger.error("doInsert course insert faile:{}", (Object)course);
            return dto;
        }
        Long id = course.getId();
        OrgClassCourseEnums enums = OrgClassCourseEnums.parse((Integer)info.getClassType());
        Long number = SerialNumberUtil.generateNumber((int)id.intValue(), (OrgClassCourseEnums)enums);
        course = new OrgClassCourse();
        course.setId(id);
        course.setNumber(number);
        this.orgClassCourseCompent.updateById(course);
        if (enums.getCode() == OrgClassCourseEnums.CLASS.getCode()) {
            OrgClassGrade grade = new OrgClassGrade();
            grade.setClassInfoId(info.getId());
            grade.setOrgId(info.getOrgId());
            grade.setCourseId(id);
            grade.setEndTime(endTime);
            grade.setGradeName(String.valueOf(name) + "\u73ed\u7ea7");
            count = this.orgClassGradeCompent.insertForId(grade);
            if (0L == count) {
                logger.error("doInsert grade insert faile:{}", (Object)course);
                throw new BussinessException(WebResponseCodeEnums.FAIL);
            }
            Long gradeId = grade.getId();
            long gradeNumber = SerialNumberUtil.generateGradeNumber((int)gradeId.intValue(), (OrgClassCourseEnums)enums);
            OrgClassGrade record = new OrgClassGrade();
            record.setId(gradeId);
            record.setNumber(Long.valueOf(gradeNumber));
            this.orgClassGradeCompent.updateById(record);
            dto.setGradeNumber(gradeNumber);
        }
        dto.setNumber(number.longValue());
        dto.setCourseId(id.longValue());
        return dto;
    }
}

