/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.enums.GradeStuSuspendEnums;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgSuspendRecordCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassSuspendRecord;
import com.baijia.orgclass.facade.dto.OrgSuspendRecordDto;
import com.baijia.orgclass.facade.interfaces.OrgSuspendRecordFacade;
import com.beust.jcommander.internal.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgSuspendFacadeImpl
implements OrgSuspendRecordFacade {
    private static final Logger logger = LoggerFactory.getLogger(OrgSuspendFacadeImpl.class);
    @Autowired
    private OrgSuspendRecordCompent orgSuspendRecordCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;

    public List<OrgSuspendRecordDto> getSuspendByCourseNumber(Integer orgId, Long courseNumber) {
        List records = this.orgSuspendRecordCompent.getSuspendByCourseNumber(orgId, courseNumber, true);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        List dtos = Lists.newArrayList();
        for (OrgClassSuspendRecord record : records) {
            OrgSuspendRecordDto dto = new OrgSuspendRecordDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)record);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.info("getSuspendByCourseNumber has error in copyProperties e:{}", (Throwable)e);
            }
            dtos.add(dto);
        }
        return dtos;
    }

    public int suspendGradeStudent(OrgSuspendRecordDto dto) {
        OrgClassSuspendRecord record = new OrgClassSuspendRecord();
        try {
            BeanUtils.copyProperties((Object)record, (Object)dto);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.info("suspendGradeStudent has error in copyProperties e:{}", (Throwable)e);
            return -1;
        }
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(dto.getOrgId(), dto.getGradeNumber());
        if (grade == null) {
            return -1;
        }
        Long courseId = grade.getCourseId();
        OrgClassCourse course = this.orgClassCourseCompent.selectById(courseId.longValue());
        if (course == null) {
            return -1;
        }
        record.setCourseNumber(course.getNumber());
        record.setEffectiveFlag(Integer.valueOf(GradeStuSuspendEnums.OUT_CLASS.getCode()));
        OrgClassSuspendRecord check = this.orgSuspendRecordCompent.selectOne(record);
        if (check == null) {
            return this.orgSuspendRecordCompent.suspendRecord(record);
        }
        check.setEffectiveFlag(Integer.valueOf(GradeStuSuspendEnums.OUT_CLASS.getCode()));
        return this.orgSuspendRecordCompent.updateById(check);
    }

    public int recoverGradeStudent(OrgSuspendRecordDto dto) {
        OrgClassSuspendRecord record = new OrgClassSuspendRecord();
        try {
            BeanUtils.copyProperties((Object)record, (Object)dto);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.info("suspendGradeStudent has error in copyProperties e:{}", (Throwable)e);
        }
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(dto.getOrgId(), dto.getGradeNumber());
        if (grade == null) {
            return -1;
        }
        Long courseId = grade.getCourseId();
        OrgClassCourse course = this.orgClassCourseCompent.selectById(courseId.longValue());
        if (course == null) {
            return -1;
        }
        record.setCourseNumber(course.getNumber());
        return this.orgSuspendRecordCompent.recoverRecord(record);
    }
}

