/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgGradePurchaseCompent;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgGradePurchase;
import com.baijia.orgclass.facade.dto.OrgGradePurchaseDto;
import com.baijia.orgclass.facade.interfaces.OrgGradePurchaseFacade;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgGradePurchaseFacadeImpl
implements OrgGradePurchaseFacade {
    private static final Logger logger = LoggerFactory.getLogger(OrgGradePurchaseFacadeImpl.class);
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgGradePurchaseCompent orgGradePurchaseCompent;

    public List<OrgGradePurchaseDto> queryByPurchaseIds(List<Long> purchaseIds, int orgId) {
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyList();
        }
        List list = this.orgGradePurchaseCompent.queryByPurchaseIds(Integer.valueOf(orgId), purchaseIds);
        logger.debug("list:{}", (Object)list);
        ArrayList result = Lists.newArrayList();
        for (OrgGradePurchase ogp : list) {
            OrgGradePurchaseDto dto = new OrgGradePurchaseDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)ogp);
                result.add(dto);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public OrgGradePurchaseDto getByGradeId(Long gradeId) {
        OrgGradePurchase orgGradePurchase = this.orgGradePurchaseCompent.getByGradeId(gradeId);
        if (orgGradePurchase == null) {
            return null;
        }
        OrgGradePurchaseDto orgGradePurchaseDto = new OrgGradePurchaseDto();
        try {
            BeanUtils.copyProperties((Object)orgGradePurchaseDto, (Object)orgGradePurchase);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.info("getByGradeId error - ", (Throwable)e);
            return null;
        }
        return orgGradePurchaseDto;
    }

    public OrgGradePurchaseDto getByGradeNumber(Long gradeNumber, int orgId) {
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(Integer.valueOf(orgId), gradeNumber);
        OrgGradePurchase gradePurchase = this.orgGradePurchaseCompent.getByGradeId(grade.getId());
        OrgGradePurchaseDto orgGradePurchaseDto = new OrgGradePurchaseDto();
        try {
            BeanUtils.copyProperties((Object)orgGradePurchaseDto, (Object)gradePurchase);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return orgGradePurchaseDto;
    }
}

