/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.utils.DateUtils;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleNoticeComponent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassScheduleNotice;
import com.baijia.orgclass.core.model.biz.OrgClassScheduleNoticeBiz;
import com.baijia.orgclass.facade.dto.OrgClassScheduleNoticeDto;
import com.baijia.orgclass.facade.interfaces.OrgClassScheduleNoticeFacade;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassScheduleNoticeFacadeImpl
implements OrgClassScheduleNoticeFacade {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassScheduleNoticeFacadeImpl.class);
    @Autowired
    private OrgClassScheduleNoticeComponent orgClassScheduleNoticeComponent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;

    public List<OrgClassScheduleNoticeDto> getByStatus(Collection<Integer> status) {
        List list = this.orgClassScheduleNoticeComponent.getByStatus(status);
        ArrayList result = Lists.newArrayList();
        for (OrgClassScheduleNoticeBiz l : list) {
            try {
                OrgClassScheduleNoticeDto dto = new OrgClassScheduleNoticeDto();
                BeanUtils.copyProperties((Object)dto, (Object)l);
                result.add(dto);
            }
            catch (Exception e) {
                logger.error("getByStatus exception - ", (Throwable)e);
            }
        }
        return result;
    }

    public int update(OrgClassScheduleNoticeDto dto) {
        OrgClassScheduleNotice record = new OrgClassScheduleNotice();
        try {
            BeanUtils.copyProperties((Object)record, (Object)dto);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("update copyProperties exception - ", (Throwable)e);
        }
        logger.info("OrgClassScheduleNoticeDto id:{},status:{}", (Object)dto.getId(), (Object)dto.getStatus());
        logger.info("OrgClassScheduleNotice id:{},status:{}", (Object)record.getId(), (Object)record.getStatus());
        return this.orgClassScheduleNoticeComponent.update(record);
    }

    public int save(OrgClassScheduleNoticeDto dto, int orgId) {
        OrgClassGrade grade = new OrgClassGrade();
        grade.setNumber(dto.getGradeNumber());
        grade = this.orgClassGradeCompent.selectOne(grade, orgId);
        dto.setGradeId(grade.getId());
        OrgClassCourse course = new OrgClassCourse();
        course.setId(grade.getCourseId());
        course.setOrgId(Integer.valueOf(orgId));
        course = this.orgClassCourseCompent.selectOne(course);
        OrgClassScheduleNotice record = new OrgClassScheduleNotice();
        try {
            BeanUtils.copyProperties((Object)record, (Object)dto);
        }
        catch (Exception e) {
            logger.error("save copyProperties exception - ", (Throwable)e);
        }
        record.setCourseNumber(course.getNumber());
        record.setContent("\u60a8\u6240\u62a5\u540d\u7684\u8bfe\u7a0b{name}\u6392\u8bfe\u5566\uff0c\u5feb\u70b9\u767b\u5f55\u8ddf\u8c01\u5b66\u67e5\u770b\uff01".replace("{name}", course.getName()));
        record.setCreateTime(DateUtils.getCurrent());
        record.setUpdateTime(DateUtils.getCurrent());
        return this.orgClassScheduleNoticeComponent.insert(record);
    }
}

