/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.annotation.ReadWriteTransactional;
import com.baijia.orgclass.common.enums.AuditStatus;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.enums.ResponseEnums;
import com.baijia.orgclass.common.enums.ScheduleTypeEnums;
import com.baijia.orgclass.common.exception.BussinessException;
import com.baijia.orgclass.common.response.WebResponse;
import com.baijia.orgclass.common.response.WebResponseCodeEnums;
import com.baijia.orgclass.common.utils.DateUtils;
import com.baijia.orgclass.common.utils.OrgClassUtils;
import com.baijia.orgclass.common.utils.ScheduleUtils;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleMCompent;
import com.baijia.orgclass.core.compent.OrgGradePurchaseCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgClassScheduleM;
import com.baijia.orgclass.core.model.auto.OrgGradePurchase;
import com.baijia.orgclass.facade.dto.OrgClassCourseDto;
import com.baijia.orgclass.facade.dto.OrgClassScheduleDto;
import com.baijia.orgclass.facade.dto.OrgClassSchedulePageDto;
import com.baijia.orgclass.facade.dto.ScheduleUpdateResDto;
import com.baijia.orgclass.facade.interfaces.OrgClassLiveFacade;
import com.baijia.orgclass.facade.interfaces.OrgClassScheduleFacade;
import com.baijia.orgclass.service.utils.AuditUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassScheduleFacadeImpl
implements OrgClassScheduleFacade {
    private static final Logger log = LoggerFactory.getLogger(OrgClassScheduleFacadeImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OrgClassScheduleFacadeImpl.class);
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgGradePurchaseCompent orgGradePurchaseCompent;
    @Autowired
    private OrgClassScheduleMCompent orgClassScheduleMCompent;
    @Autowired
    private OrgClassLiveFacade OrgClassLiveFacade;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;

    public OrgClassSchedulePageDto searchSchedule(long gradeNumber, int pageNum, int pageSize, int orgId) {
        OrgClassGrade grade = new OrgClassGrade();
        grade.setNumber(Long.valueOf(gradeNumber));
        grade = this.orgClassGradeCompent.selectOne(grade, orgId);
        OrgClassSchedulePageDto result = new OrgClassSchedulePageDto();
        if (grade == null) {
            return result;
        }
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setOrgId(Integer.valueOf(orgId));
        schedule.setGradeId(grade.getId());
        int count = this.orgClassScheduleCompent.searchByPageCount(schedule);
        log.info("[Schedule] schedule List:{}, gradeId:{}", (Object)count, (Object)grade.getId());
        if (count <= 0) {
            return result;
        }
        result.setCount(count);
        RowBounds rowBounds = new RowBounds((pageNum - 1) * pageSize, pageSize);
        List list = this.orgClassScheduleCompent.searchByPage(schedule, rowBounds);
        ArrayList dtoList = Lists.newArrayList();
        OrgClassCourse course = this.orgClassCourseCompent.selectById(grade.getCourseId().longValue());
        OrgClassInfo info = this.orgClassInfoCompent.getById(course.getOrgClassId().longValue());
        OrgClassCourseDto orgClassCourseDto = new OrgClassCourseDto();
        try {
            BeanUtils.copyProperties((Object)orgClassCourseDto, (Object)course);
            orgClassCourseDto.setLessonWay(info.getLessonWay().intValue());
        }
        catch (Exception e) {
            logger.error("searchSchedule e:{}", (Throwable)e);
        }
        for (OrgClassSchedule tmp : list) {
            OrgClassScheduleDto dto = new OrgClassScheduleDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)tmp);
                dto.setOrgClassCourseDto(orgClassCourseDto);
                dtoList.add(dto);
            }
            catch (Exception e) {
                logger.error("searchSchedule e:{}", (Throwable)e);
            }
        }
        result.setDtoList((List)dtoList);
        return result;
    }

    public WebResponse<ScheduleUpdateResDto> insert(OrgClassScheduleDto dto, int orgId) {
        OrgClassGrade grade = new OrgClassGrade();
        grade.setNumber(dto.getGradeNumber());
        grade = this.orgClassGradeCompent.selectOne(grade, orgId);
        dto.setGradeId(grade.getId());
        OrgClassCourse course = new OrgClassCourse();
        course.setId(grade.getCourseId());
        course.setOrgId(Integer.valueOf(orgId));
        course = this.orgClassCourseCompent.selectOne(course);
        WebResponse res = this.checkClassCount(dto.getClassCount(), course, orgId, grade, dto.getScheduleType(), null);
        if (res != null) {
            return res;
        }
        Date endTime = DateUtils.addMinute((Date)dto.getStartTime(), (int)(dto.getClassCount() * course.getClassLength()));
        OrgClassSchedule schedule = new OrgClassSchedule();
        ArrayList scheduleList = Lists.newArrayList();
        schedule.setStartTime(dto.getStartTime());
        schedule.setEndTime(endTime);
        scheduleList.add(schedule);
        res = this.conflictTimeCheck(scheduleList, grade.getId(), null);
        if (res != null) {
            return res;
        }
        res = new WebResponse();
        try {
            BeanUtils.copyProperties((Object)schedule, (Object)dto);
        }
        catch (Exception e) {
            logger.error("insert e:{}", (Throwable)e);
            res.setCode(1);
            return res;
        }
        schedule.setEndTime(endTime);
        schedule.setOrgId(Integer.valueOf(orgId));
        schedule.setOrgClassId(course.getOrgClassId());
        schedule.setOrgClassCourseId(course.getId());
        schedule.setId(null);
        this.orgClassScheduleCompent.insert4Id(schedule);
        dto.setId(schedule.getGradeId());
        schedule.getId();
        ScheduleUpdateResDto rdto = new ScheduleUpdateResDto();
        rdto.setSuccessId(schedule.getId().longValue());
        res.setData((Object)rdto);
        return res;
    }

    @ReadWriteTransactional
    public WebResponse<ScheduleUpdateResDto> update(OrgClassScheduleDto dto, int orgId) {
        logger.info("[Schedule] update dto:{}, orgId:{}", (Object)dto, (Object)orgId);
        OrgClassGrade grade = new OrgClassGrade();
        grade.setNumber(dto.getGradeNumber());
        grade = this.orgClassGradeCompent.selectOne(grade, orgId);
        OrgClassCourse course = new OrgClassCourse();
        course.setId(grade.getCourseId());
        course.setOrgId(Integer.valueOf(orgId));
        course = this.orgClassCourseCompent.selectOne(course);
        WebResponse res = this.checkClassCount(dto.getClassCount(), course, orgId, grade, dto.getScheduleType(), dto.getId());
        if (res != null) {
            return res;
        }
        Date endTime = DateUtils.addMinute((Date)dto.getStartTime(), (int)(dto.getClassCount() * course.getClassLength()));
        ArrayList scheduleList = Lists.newArrayList();
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setStartTime(dto.getStartTime());
        schedule.setEndTime(endTime);
        scheduleList.add(schedule);
        res = this.conflictTimeCheck(scheduleList, grade.getId(), dto.getId());
        if (res != null) {
            return res;
        }
        res = new WebResponse();
        OrgClassSchedule old = this.orgClassScheduleCompent.selectById(dto.getId().longValue());
        dto.setEndTime(endTime);
        try {
            BeanUtils.copyProperties((Object)schedule, (Object)dto);
        }
        catch (Exception e) {
            logger.error("update e - ", (Throwable)e);
            res.setCode(1);
            return res;
        }
        List<Long> auditIdList = this.handleSchedulem(schedule, orgId);
        ScheduleUpdateResDto resDto = new ScheduleUpdateResDto();
        resDto.setAuditIdList(auditIdList);
        res.setData((Object)resDto);
        if (AuditUtils.scheduleAuditCheck(schedule, old)) {
            schedule.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        }
        if (1 != this.orgClassScheduleCompent.update(schedule, schedule.getId().longValue(), orgId)) {
            res.setCode(1);
            return res;
        }
        this.handleRoom(old, dto);
        ScheduleUpdateResDto rdto = new ScheduleUpdateResDto();
        rdto.setSuccessId(old.getId().longValue());
        res.setCode(0);
        return res;
    }

    private void handleRoom(OrgClassSchedule old, OrgClassScheduleDto dto) {
        if (AuditUtils.isUpdateLiveRoomInfoCheck(dto, old)) {
            dto.setRoomNo(old.getRoomNo());
            int result = this.OrgClassLiveFacade.updateLiveRoom(dto);
            Gson g = new Gson();
            logger.info("[updateRoom] dto:{}, result:{}", (Object)g.toJson((Object)dto), (Object)result);
            if (result != 0) {
                logger.error("[Schedeule] update orgClassScheduleLiveRoomInfo fail");
                throw new BussinessException(WebResponseCodeEnums.FAIL);
            }
        }
    }

    private List<Long> handleSchedulem(OrgClassSchedule schedule, int orgId) {
        OrgClassScheduleM schedulem = new OrgClassScheduleM();
        schedulem.setId(schedule.getId());
        schedulem = this.orgClassScheduleMCompent.selectOne(schedulem, orgId);
        if (AuditUtils.scheduleAuditCheck(schedule, schedulem)) {
            ArrayList auditIdList = Lists.newArrayList();
            auditIdList.add(schedule.getId());
            return auditIdList;
        }
        try {
            BeanUtils.copyProperties((Object)schedulem, (Object)schedule);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("handleSchedulem e - ", (Throwable)e);
        }
        this.orgClassScheduleMCompent.saveOrUpdate(schedulem);
        return Collections.emptyList();
    }

    private boolean isCanSchedule(int num, OrgClassCourse course, int orgId, OrgClassGrade grade, int scheduleType, Long scheduleId) {
        int already;
        if (ScheduleTypeEnums.GIVE.getCode() == scheduleType) {
            return true;
        }
        int sumCount = course.getClassCount();
        OrgClassCourseEnums enums = OrgClassUtils.getByCourseNumber((Long)course.getNumber());
        if (OrgClassCourseEnums.OVO.getCode() == enums.getCode()) {
            OrgGradePurchase purchase = new OrgGradePurchase();
            purchase.setGradeId(grade.getId());
            purchase = this.orgGradePurchaseCompent.selectOne(purchase, orgId);
            sumCount = purchase.getClassCount();
        }
        return sumCount >= (already = this.orgClassScheduleCompent.getSumCountByGradeId(grade.getId().longValue(), orgId, scheduleId)) + num;
    }

    @ReadWriteTransactional
    public WebResponse<ScheduleUpdateResDto> batchInsert(List<OrgClassScheduleDto> scheduleList, Integer orgId, int sumClassNum, long gradeNumber) {
        OrgClassGrade grade = new OrgClassGrade();
        grade.setNumber(Long.valueOf(gradeNumber));
        grade = this.orgClassGradeCompent.selectOne(grade, orgId.intValue());
        WebResponse<ScheduleUpdateResDto> res = new WebResponse();
        if (grade == null) {
            res.setCode(1);
            return res;
        }
        OrgClassCourse course = new OrgClassCourse();
        course.setId(grade.getCourseId());
        course.setOrgId(orgId);
        course = this.orgClassCourseCompent.selectOne(course);
        res = this.checkClassCount(sumClassNum, course, orgId, grade, ScheduleTypeEnums.NORMAL.getCode(), null);
        if (res != null) {
            return res;
        }
        long gradeId = grade.getId();
        ArrayList itemList = Lists.newArrayList();
        for (OrgClassScheduleDto dto : scheduleList) {
            OrgClassSchedule schedule = new OrgClassSchedule();
            try {
                BeanUtils.copyProperties((Object)schedule, (Object)dto);
            }
            catch (Exception e) {
                logger.error("batchInsert e:{}", (Throwable)e);
                res = new WebResponse();
                res.setCode(1);
                return res;
            }
            Date endTime = DateUtils.addMinute((Date)dto.getStartTime(), (int)(dto.getClassCount() * course.getClassLength()));
            schedule.setEndTime(endTime);
            schedule.setGradeId(Long.valueOf(gradeId));
            schedule.setOrgId(orgId);
            schedule.setOrgClassId(course.getOrgClassId());
            schedule.setOrgClassCourseId(course.getId());
            schedule.setRoomNo(Long.valueOf(dto.getRoomNo() == null ? 0L : dto.getRoomNo()));
            schedule.setId(null);
            itemList.add(schedule);
        }
        res = this.conflictTimeCheck(itemList, grade.getId(), null);
        if (res != null) {
            return res;
        }
        int count = this.orgClassScheduleCompent.batchInsert((List)itemList);
        List list = this.orgClassScheduleCompent.getLastId(gradeId, count);
        List idList = Lists.transform((List)list, (Function)new Function<OrgClassSchedule, Long>(){

            public Long apply(OrgClassSchedule from) {
                return from.getId();
            }
        });
        ScheduleUpdateResDto data = new ScheduleUpdateResDto();
        data.setAuditIdList(idList);
        res = new WebResponse();
        res.setData((Object)data);
        res.setCode(0);
        return res;
    }

    private WebResponse<ScheduleUpdateResDto> conflictTimeCheck(List<OrgClassSchedule> scheduleList, long gradeId, Long extId) {
        if (CollectionUtils.isEmpty(scheduleList)) {
            return null;
        }
        int count = this.orgClassScheduleCompent.countByTime(scheduleList, gradeId, extId);
        if (count != 0) {
            WebResponse res = new WebResponse();
            res.setCode(ResponseEnums.TIME_CONFLICT.getCode());
            res.setMsg(ResponseEnums.TIME_CONFLICT.getMsg());
            return res;
        }
        return null;
    }

    private WebResponse<ScheduleUpdateResDto> checkTimeRange(int lessonWay, Date startTime, Date endTime) {
        if (!ScheduleUtils.checkTimeRange((int)lessonWay, (Date)startTime, (Date)endTime)) {
            WebResponse res = new WebResponse();
            res.setCode(ResponseEnums.TIME_RANGE.getCode());
            res.setMsg(ResponseEnums.TIME_RANGE.getMsg());
            return res;
        }
        return null;
    }

    private WebResponse<ScheduleUpdateResDto> checkClassCount(int classCount, OrgClassCourse course, int orgId, OrgClassGrade grade, int scheduleType, Long scheduleId) {
        if (!this.isCanSchedule(classCount, course, orgId, grade, scheduleType, scheduleId)) {
            WebResponse res = new WebResponse();
            res.setCode(ResponseEnums.TOO_MUCH.getCode());
            res.setMsg(ResponseEnums.TOO_MUCH.getMsg());
            return res;
        }
        return null;
    }

    public OrgClassScheduleDto search(long id, int orgId) {
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setId(Long.valueOf(id));
        schedule = this.orgClassScheduleCompent.selectOne(schedule, orgId);
        OrgClassCourse course = this.orgClassCourseCompent.selectById(schedule.getOrgClassCourseId().longValue());
        OrgClassScheduleDto dto = new OrgClassScheduleDto();
        OrgClassCourseDto orgClassCourseDto = new OrgClassCourseDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)schedule);
            BeanUtils.copyProperties((Object)orgClassCourseDto, (Object)course);
            dto.setOrgClassCourseDto(orgClassCourseDto);
        }
        catch (Exception e) {
            logger.error("search e:{}", (Throwable)e);
        }
        return dto;
    }

    @ReadWriteTransactional
    public int delete(Long id, Integer orgId) {
        int sqlRes;
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setIsDel(Boolean.valueOf(true));
        schedule.setId(null);
        OrgClassScheduleM scheduleM = new OrgClassScheduleM();
        scheduleM.setId(id);
        scheduleM = this.orgClassScheduleMCompent.selectOne(scheduleM, orgId.intValue());
        if (scheduleM != null) {
            scheduleM.setIsDel(Boolean.valueOf(true));
            scheduleM.setId(null);
            sqlRes = this.orgClassScheduleMCompent.update(scheduleM, id.longValue(), orgId.intValue());
            if (sqlRes == 0) {
                logger.error("deleteClassSchedule failed");
                throw new BussinessException(WebResponseCodeEnums.FAIL);
            }
        }
        if ((sqlRes = this.orgClassScheduleCompent.update(schedule, id.longValue(), orgId.intValue())) == 0) {
            logger.error("deleteClassSchedule failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        return sqlRes;
    }

    public List<OrgClassScheduleDto> get4AutoConfirmList(Date startTime, Date endTime) {
        List courseIdList = this.orgClassScheduleCompent.selectCourseId4AutoConfirm(startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)courseIdList)) {
            return Collections.emptyList();
        }
        List courseList = this.orgClassCourseCompent.selectByIdList(courseIdList);
        if (CollectionUtils.isEmpty((Collection)courseList)) {
            return Collections.emptyList();
        }
        List list = this.orgClassScheduleCompent.select4AutoConfirm(startTime, endTime, courseIdList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return this.parse(list, courseList);
    }

    public List<OrgClassScheduleDto> parse(List<OrgClassSchedule> list, List<OrgClassCourse> courseList) {
        HashMap cm = Maps.newHashMap();
        for (OrgClassCourse course : courseList) {
            cm.put(course.getId(), course);
        }
        ArrayList dtoList = Lists.newArrayList();
        for (OrgClassSchedule schedule : list) {
            OrgClassScheduleDto dto = new OrgClassScheduleDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)schedule);
                OrgClassCourse course = (OrgClassCourse)cm.get(dto.getOrgClassCourseId());
                if (course != null) {
                    OrgClassCourseDto orgClassCourseDto = new OrgClassCourseDto();
                    orgClassCourseDto.setNumber(course.getNumber());
                    dto.setOrgClassCourseDto(orgClassCourseDto);
                }
                dtoList.add(dto);
            }
            catch (Exception e) {
                logger.error("parse e -", (Throwable)e);
            }
        }
        return dtoList;
    }
}

