/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.enums.BJCloudCodeEnums;
import com.baijia.orgclass.common.enums.LiveScheduleStatus;
import com.baijia.orgclass.common.exception.BJCloudException;
import com.baijia.orgclass.common.utils.ConfigProperties;
import com.baijia.orgclass.common.utils.DateUtils;
import com.baijia.orgclass.common.utils.RestUtils;
import com.baijia.orgclass.common.utils.RestfulResult;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleMCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgClassScheduleM;
import com.baijia.orgclass.core.model.biz.OrgGradeLiveCountDto;
import com.baijia.orgclass.facade.dto.OrgClassScheduleDto;
import com.baijia.orgclass.facade.dto.OrgClassScheduleLiveDto;
import com.baijia.orgclass.facade.dto.VideoPlayClassCourseDto;
import com.baijia.orgclass.facade.dto.VideoPlayClassInfoDto;
import com.baijia.orgclass.facade.dto.VideoPlayClassScheduleDto;
import com.baijia.orgclass.facade.interfaces.OrgClassLiveFacade;
import com.baijia.orgclass.service.utils.BaijiaYunUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassLiveFacadeImpl
implements OrgClassLiveFacade {
    private static final Logger log = LoggerFactory.getLogger(OrgClassLiveFacadeImpl.class);
    private static final String GENSHEIXUE_BASEURL = ConfigProperties.getProperty((String)"gensheixue.baseUrl");
    private static final String CONTROLLER = "live/playback?classid=";
    private static final String SIGN_SPLI = "/";
    private static final String PARTNER_ID = ConfigProperties.getProperty((String)"baijia.live.partnerId");
    private static final String LIVE_HELPER_BASE_URL = ConfigProperties.getProperty((String)"baijia.live.baseUrl");
    private static final String BASE_URL = ConfigProperties.getProperty((String)"baijia.live.baseUrl");
    private static final String SKIP_PARAM = "&skip_verify=1";
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;
    @Autowired
    private OrgClassScheduleMCompent orgClassScheduleMCompent;

    public Map<Long, Boolean> checkIsEnterLiveRoom(int orgId, List<Long> gradeIds) {
        if (CollectionUtils.isEmpty(gradeIds)) {
            return Collections.emptyMap();
        }
        List dtos = this.orgClassScheduleCompent.getOrgGradeLiveScheduleCountMap(gradeIds, orgId);
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgGradeLiveCountDto dto : dtos) {
            if (dto.getCount() > 0) {
                map.put(dto.getGradeId(), true);
                continue;
            }
            map.put(dto.getGradeId(), false);
        }
        return map;
    }

    public Long getRoomNoByCourseNumber(Long orgCourseNumber, int orgId) {
        log.info("[EnterUrl] getRoomNo:{}", (Object)orgCourseNumber);
        OrgClassCourse orgClassCourse = new OrgClassCourse();
        orgClassCourse.setNumber(orgCourseNumber);
        orgClassCourse.setOrgId(Integer.valueOf(orgId));
        orgClassCourse = this.orgClassCourseCompent.selectOne(orgClassCourse);
        log.info("[EnterUrl] orgClassCourse:{}", (Object)orgClassCourse);
        if (orgClassCourse == null) {
            log.info("[EnterUrl] get enter URL is null orgCourseNumber:{}, orgId:{}", (Object)orgCourseNumber, (Object)orgId);
            return null;
        }
        Long orgClassCourseId = orgClassCourse.getId();
        log.info("[EnterUrl] orgClassCourseId:{}", (Object)orgClassCourseId);
        List orgClassScheduleList = this.orgClassScheduleCompent.getOrgClassScheduleList((List)Lists.newArrayList((Object[])new Long[]{orgClassCourseId}), orgId);
        if (orgClassScheduleList.isEmpty()) {
            log.info("[EnterUrl] get enter URL is null orgCourseNumber:{}, orgId:{}", (Object)orgCourseNumber, (Object)orgId);
            return null;
        }
        Long roomNo = this.getRoomNo(orgClassScheduleList);
        return roomNo;
    }

    private Long getRoomNo(List<OrgClassSchedule> orgClassScheduleList) {
        OrgClassSchedule orgClassSchedule;
        ArrayList scheduleNowList = Lists.newArrayList();
        ArrayList scheduleBeforeList = Lists.newArrayList();
        ArrayList scheduleAfterList = Lists.newArrayList();
        Date now = new Date();
        for (OrgClassSchedule orgClassSchedule2 : orgClassScheduleList) {
            if (orgClassSchedule2.getStartTime().after(now)) {
                scheduleBeforeList.add(orgClassSchedule2);
                continue;
            }
            if (orgClassSchedule2.getEndTime().before(now)) {
                scheduleAfterList.add(orgClassSchedule2);
                continue;
            }
            scheduleNowList.add(orgClassSchedule2);
        }
        Gson g = new Gson();
        log.info("[EnterUrl] scheduleNowList:{}", (Object)g.toJson((Object)scheduleNowList));
        log.info("[EnterUrl] scheduleBeforeList:{}", (Object)g.toJson((Object)scheduleBeforeList));
        log.info("[EnterUrl] scheduleAfterList:{}", (Object)g.toJson((Object)scheduleAfterList));
        if (CollectionUtils.isNotEmpty((Collection)scheduleNowList)) {
            orgClassSchedule = (OrgClassSchedule)scheduleNowList.get(0);
            return orgClassSchedule.getRoomNo();
        }
        if (CollectionUtils.isNotEmpty((Collection)scheduleBeforeList)) {
            Collections.sort(scheduleBeforeList, new Comparator<OrgClassSchedule>(){

                @Override
                public int compare(OrgClassSchedule o1, OrgClassSchedule o2) {
                    return o1.getStartTime().before(o2.getStartTime()) ? -1 : 0;
                }
            });
            orgClassSchedule = (OrgClassSchedule)scheduleBeforeList.get(0);
            return orgClassSchedule.getRoomNo();
        }
        if (CollectionUtils.isNotEmpty((Collection)scheduleAfterList)) {
            Collections.sort(scheduleAfterList, new Comparator<OrgClassSchedule>(){

                @Override
                public int compare(OrgClassSchedule o1, OrgClassSchedule o2) {
                    return o1.getEndTime().before(o2.getEndTime()) ? -1 : 0;
                }
            });
            orgClassSchedule = (OrgClassSchedule)scheduleAfterList.get(0);
            return orgClassSchedule.getRoomNo();
        }
        return null;
    }

    public String createSign(Map<String, String> params) {
        String sign = BaijiaYunUtil.createSign(params);
        return sign;
    }

    public List<VideoPlayClassInfoDto> getVideoClassInfoDtoList(int orgId, List<Long> scheduleIds) {
        log.info("[liveRoom] scheduleIds:{}", scheduleIds);
        List orgClassScheduleList = this.orgClassScheduleCompent.getByIds(scheduleIds, orgId);
        if (CollectionUtils.isEmpty((Collection)orgClassScheduleList)) {
            return Collections.emptyList();
        }
        ArrayList orgClassCourseIds = Lists.newArrayList();
        ArrayList infoIds = Lists.newArrayList();
        HashMap orgClassCourseIdsMap = Maps.newHashMap();
        for (OrgClassSchedule schedule : orgClassScheduleList) {
            Long orgClassCourseId = schedule.getOrgClassCourseId();
            Long orgClassId = schedule.getOrgClassId();
            orgClassCourseIds.add(orgClassCourseId);
            infoIds.add(orgClassId);
            Object classCourseIds = (List)orgClassCourseIdsMap.get(orgClassId);
            if (CollectionUtils.isEmpty((Collection)classCourseIds)) {
                classCourseIds = Lists.newArrayList();
                orgClassCourseIdsMap.put(orgClassId, classCourseIds);
            }
            if (classCourseIds.contains(orgClassCourseId)) continue;
            classCourseIds.add(orgClassCourseId);
        }
        List orgClassInfoList = this.orgClassInfoCompent.getByIdList((List)infoIds, false);
        Map<Long, VideoPlayClassCourseDto> videoPlayClassCourseDtoMap = this.getVideoPlayClassCourseDtoMap(orgClassCourseIds);
        HashMap videoPlayClassScheduleDtoListMap = Maps.newHashMap();
        for (OrgClassSchedule orgClassSchedule : orgClassScheduleList) {
            Long courseId = orgClassSchedule.getOrgClassCourseId();
            VideoPlayClassCourseDto videoPlayClassCourseDto = videoPlayClassCourseDtoMap.get(courseId);
            int validDate = videoPlayClassCourseDto.getValidDays();
            List scheduleDtoList = (List)videoPlayClassScheduleDtoListMap.get(courseId);
            if (CollectionUtils.isEmpty((Collection)scheduleDtoList)) {
                scheduleDtoList = Lists.newArrayList();
                videoPlayClassScheduleDtoListMap.put(courseId, scheduleDtoList);
            }
            scheduleDtoList.add(this.buildVideoPlayClassScheduleDtoInstance(orgClassSchedule, validDate));
        }
        Map<Long, List<VideoPlayClassCourseDto>> videoPlayClassCourseDtoListMap = this.getVideoPlayClassCourseDtoListMap(videoPlayClassCourseDtoMap, orgClassCourseIdsMap, videoPlayClassScheduleDtoListMap);
        log.info("[liveRoom] param:{}", videoPlayClassCourseDtoListMap);
        ArrayList dtos = Lists.newArrayList();
        for (OrgClassInfo orgClassInfo : orgClassInfoList) {
            Long orgClassInfoId = orgClassInfo.getId();
            VideoPlayClassInfoDto dto = this.buildVideoPlayClassInfoDtoInstance(orgClassInfo);
            List<VideoPlayClassCourseDto> courseDtoList = videoPlayClassCourseDtoListMap.get(orgClassInfoId);
            dto.setList(courseDtoList);
            dtos.add(dto);
        }
        return dtos;
    }

    private VideoPlayClassScheduleDto buildVideoPlayClassScheduleDtoInstance(OrgClassSchedule schedule, int validDate) {
        VideoPlayClassScheduleDto dto = new VideoPlayClassScheduleDto();
        dto.setScheduleName(schedule.getName());
        dto.setCourseEndTime(Long.valueOf(schedule.getEndTime().getTime()));
        dto.setScheduleId(schedule.getId());
        Date videoEndTime = DateUtils.addDate((Date)schedule.getEndTime(), (int)validDate);
        dto.setVideoEndTime(Long.valueOf(videoEndTime.getTime()));
        int status = LiveScheduleStatus.ON.getCode();
        if (videoEndTime.after(new Date())) {
            status = LiveScheduleStatus.END.getCode();
        }
        dto.setPreviewUrl(this.getPreviewUrl(schedule.getRoomNo()));
        dto.setStatus(status);
        return dto;
    }

    private String getPreviewUrl(Long roomId) {
        StringBuilder sb = new StringBuilder();
        sb.append(GENSHEIXUE_BASEURL).append(SIGN_SPLI).append(CONTROLLER).append(roomId).append(SKIP_PARAM);
        return sb.toString();
    }

    private VideoPlayClassInfoDto buildVideoPlayClassInfoDtoInstance(OrgClassInfo orgClassInfo) {
        VideoPlayClassInfoDto dto = new VideoPlayClassInfoDto();
        dto.setClassInfoId(orgClassInfo.getId());
        dto.setClassNumber(orgClassInfo.getNumber());
        dto.setClassName(orgClassInfo.getTitle());
        return dto;
    }

    private VideoPlayClassCourseDto buildVideoPlayClassCourseDtoInstance(OrgClassCourse orgClassCourse) {
        VideoPlayClassCourseDto dto = new VideoPlayClassCourseDto();
        dto.setCourseName(orgClassCourse.getName());
        dto.setCourseNumber(orgClassCourse.getNumber());
        dto.setValidDays(orgClassCourse.getVideoValidDays().intValue());
        dto.setCourseId(orgClassCourse.getId());
        return dto;
    }

    private Map<Long, VideoPlayClassCourseDto> getVideoPlayClassCourseDtoMap(List<Long> courseIds) {
        List list = this.orgClassCourseCompent.selectByIdList(courseIds);
        log.info("[liveRoom] courseIds param:{}", courseIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        HashMap videoPlayClassCourseDtoMap = Maps.newHashMap();
        for (OrgClassCourse orgClassCourse : list) {
            VideoPlayClassCourseDto dto = this.buildVideoPlayClassCourseDtoInstance(orgClassCourse);
            videoPlayClassCourseDtoMap.put(orgClassCourse.getId(), dto);
        }
        return videoPlayClassCourseDtoMap;
    }

    private Map<Long, List<VideoPlayClassCourseDto>> getVideoPlayClassCourseDtoListMap(Map<Long, VideoPlayClassCourseDto> videoPlayClassCourseDtoMap, Map<Long, List<Long>> orgClassCourseIdsMap, Map<Long, List<VideoPlayClassScheduleDto>> videoPlayClassScheduleDtoListMap) {
        log.info("[liveRoom] videoPlayClassScheduleDtoListMap param:{}, ======videoPlayClassCourseDtoMap param:{}, =====orgClassCourseIdsMap param:{}", new Object[]{videoPlayClassScheduleDtoListMap, videoPlayClassCourseDtoMap, orgClassCourseIdsMap});
        HashMap map = Maps.newHashMap();
        for (Long orgClassInfoId : orgClassCourseIdsMap.keySet()) {
            List<Long> orgClassCourseIds = orgClassCourseIdsMap.get(orgClassInfoId);
            ArrayList dtos = Lists.newArrayList();
            for (Long orgClassCourseId : orgClassCourseIds) {
                VideoPlayClassCourseDto dto = videoPlayClassCourseDtoMap.get(orgClassCourseId);
                if (dto != null) {
                    List<VideoPlayClassScheduleDto> scheduleList = videoPlayClassScheduleDtoListMap.get(orgClassCourseId);
                    dto.setList(scheduleList);
                }
                dtos.add(dto);
            }
            map.put(orgClassInfoId, dtos);
        }
        return map;
    }

    public int updateLiveRoom(OrgClassScheduleDto orgClassScheduleDto) {
        int result;
        block3: {
            Map<String, String> updateParams = this.getUpdateParams(orgClassScheduleDto);
            String controller = "openapi/room/";
            String action = "update";
            try {
                RestfulResult restResult = RestUtils.rest((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)LIVE_HELPER_BASE_URL, (String)controller, (String)action, null, updateParams, null);
                result = restResult.getCode();
                if (result != 0) break block3;
                return 0;
            }
            catch (Exception e) {
                log.error("[UpdateRoomNo] updateRommNo error:{}", (Throwable)e);
                return 1;
            }
        }
        BJCloudCodeEnums enums = BJCloudCodeEnums.getBJCloudCodeEnums((int)result);
        log.error("[UpdateRoomNo] updateRoomNo error:{}", (Object)enums);
        return result;
    }

    private Map<String, String> getUpdateParams(OrgClassScheduleDto orgClassScheduleDto) {
        HashMap params = Maps.newHashMap();
        params.put("partner_id", PARTNER_ID);
        params.put("room_id", "" + orgClassScheduleDto.getRoomNo());
        params.put("title", orgClassScheduleDto.getName());
        params.put("start_time", String.valueOf(orgClassScheduleDto.getStartTime().getTime() / 1000L));
        params.put("end_time", String.valueOf(orgClassScheduleDto.getEndTime().getTime() / 1000L));
        params.put("timestamp", String.valueOf(new Date().getTime() / 1000L));
        String sign = BaijiaYunUtil.createSign(params);
        params.put("sign", sign);
        return params;
    }

    public OrgClassScheduleLiveDto getLiveOrgClassScheduleDtoByScheduleId(Long scheduleId, int orgId) {
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setId(scheduleId);
        schedule = this.orgClassScheduleCompent.selectOne(schedule, orgId);
        if (schedule == null || schedule.getRoomNo() == 0L) {
            return null;
        }
        OrgClassScheduleLiveDto dto = new OrgClassScheduleLiveDto();
        OrgClassScheduleM scheduleM = new OrgClassScheduleM();
        scheduleM.setId(scheduleId);
        scheduleM = this.orgClassScheduleMCompent.selectOne(scheduleM, orgId);
        if (scheduleM == null) {
            dto.setIsExistInAudit(1);
            return dto;
        }
        dto.setIsExistInAudit(0);
        if (this.isReturnRoomNo(schedule)) {
            dto.setRoomNo(schedule.getRoomNo().longValue());
            dto.setScheduleId(scheduleId.longValue());
            return dto;
        }
        return null;
    }

    private boolean isReturnRoomNo(OrgClassSchedule orgClassSchedule) {
        Date now = new Date();
        return orgClassSchedule.getStartTime().before(DateUtils.getDateByDiffHour((Date)now, (int)4)) && orgClassSchedule.getEndTime().after(DateUtils.getDateByDiffHour((Date)now, (int)-3));
    }

    public RestfulResult<Map<String, String>> getLiveInfo(Long roomNo) {
        HashMap params = Maps.newHashMap();
        params.put("partner_id", PARTNER_ID);
        params.put("room_id", "" + roomNo);
        params.put("timestamp", String.valueOf(new Date().getTime() / 1000L));
        String sign = BaijiaYunUtil.createSign(params);
        params.put("sign", sign);
        String controller = "openapi/room";
        String action = "info";
        try {
            RestfulResult restResult = RestUtils.rest((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)BASE_URL, (String)controller, (String)action, null, (Map)params, null);
            int code = restResult.getCode();
            if (code != 0) {
                BJCloudCodeEnums codeEnums = BJCloudCodeEnums.getBJCloudCodeEnums((int)code);
                throw new BJCloudException(codeEnums);
            }
            return restResult;
        }
        catch (Exception e) {
            log.error("[LiveRoom] get info error:{}", (Throwable)e);
            return null;
        }
    }
}

