/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.enums.ClassStatusEnums;
import com.baijia.orgclass.common.enums.LessonWayEnums;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoMCompent;
import com.baijia.orgclass.core.model.auto.OrgClassInfoM;
import com.baijia.orgclass.core.model.biz.OrgCoursePriceDto;
import com.baijia.orgclass.facade.dto.RecommendClassCourseDto;
import com.baijia.orgclass.facade.dto.RecommendClassCoursePageDto;
import com.baijia.orgclass.facade.interfaces.OrgClassInfoMFacade;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service
public class OrgClassInfoMFacadeImpl
implements OrgClassInfoMFacade {
    @Autowired
    private OrgClassInfoMCompent orgClassInfoMCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;

    public RecommendClassCoursePageDto getRecommendClassCoursePageDto(int orgId, int offset, int size) {
        RecommendClassCoursePageDto recommendClassCoursePageDto = new RecommendClassCoursePageDto();
        int count = this.orgClassInfoMCompent.getOrgClassInfoCount(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()), orgId);
        if (count <= 0) {
            return recommendClassCoursePageDto;
        }
        recommendClassCoursePageDto.setCount(count);
        RowBounds rowBounds = new RowBounds(offset, size);
        List orgClassInfoMList = this.orgClassInfoMCompent.getOrgClassInfoMListPage(rowBounds, Integer.valueOf(ClassStatusEnums.ENROLLING.getState()), orgId);
        if (CollectionUtils.isEmpty((Collection)orgClassInfoMList)) {
            return recommendClassCoursePageDto;
        }
        List<RecommendClassCourseDto> dtos = this.getRecommendClassCourseDtoList(orgClassInfoMList, orgId);
        recommendClassCoursePageDto.setList(dtos);
        return recommendClassCoursePageDto;
    }

    private List<RecommendClassCourseDto> getRecommendClassCourseDtoList(List<OrgClassInfoM> list, int orgId) {
        ArrayList orgClassInfoIds = Lists.newArrayList();
        for (OrgClassInfoM orgClassInfoM : list) {
            orgClassInfoIds.add(orgClassInfoM.getId());
        }
        Map<Long, OrgCoursePriceDto> priceMap = this.getCoursePriceMap(orgClassInfoIds, orgId);
        ArrayList dtos = Lists.newArrayList();
        for (OrgClassInfoM orgClassInfoM : list) {
            RecommendClassCourseDto dto = this.buildRecommendClassCourseDtoInstance(orgClassInfoM);
            OrgCoursePriceDto orgCoursePriceDto = priceMap.get(orgClassInfoM.getId());
            if (orgCoursePriceDto != null) {
                dto.setMinPrice(orgCoursePriceDto.getMinPrice());
                dto.setMaxPrice(orgCoursePriceDto.getMaxPrice());
            }
            dtos.add(dto);
        }
        return dtos;
    }

    private RecommendClassCourseDto buildRecommendClassCourseDtoInstance(OrgClassInfoM orgClassInfoM) {
        RecommendClassCourseDto dto = new RecommendClassCourseDto();
        dto.setTitle(orgClassInfoM.getTitle());
        int classType = orgClassInfoM.getClassType();
        OrgClassCourseEnums orgClassCourseEnums = OrgClassCourseEnums.parse((Integer)classType);
        String classTypeStr = "";
        if (orgClassCourseEnums != null) {
            classTypeStr = orgClassCourseEnums.getName();
        }
        dto.setClassType(classType);
        dto.setClassTypeStr(classTypeStr);
        int lesssonWay = orgClassInfoM.getLessonWay();
        LessonWayEnums lessonWayEnums = LessonWayEnums.parse((int)lesssonWay);
        String lessonWayStr = "";
        if (lessonWayEnums != null) {
            lessonWayStr = lessonWayEnums.getName();
        }
        dto.setLessonWay(lesssonWay);
        dto.setLessonWayStr(lessonWayStr);
        dto.setCreateTime(Long.valueOf(orgClassInfoM.getCreateTime().getTime()));
        dto.setStorageId(orgClassInfoM.getStorageId());
        dto.setStatus(orgClassInfoM.getStatus().intValue());
        dto.setNumber(orgClassInfoM.getNumber());
        return dto;
    }

    private Map<Long, OrgCoursePriceDto> getCoursePriceMap(List<Long> infoIds, int orgId) {
        List orgCoursePriceDtoList = this.orgClassCourseCompent.selectPrice(infoIds, orgId);
        HashMap priceMap = Maps.newHashMap();
        if (orgCoursePriceDtoList != null && orgCoursePriceDtoList.size() > 0) {
            for (OrgCoursePriceDto dto : orgCoursePriceDtoList) {
                priceMap.put(dto.getOrgClassId(), dto);
            }
        }
        return priceMap;
    }

    public List<RecommendClassCourseDto> getRecommendClassCourseDtoByIds(List<Long> ids, int orgId) {
        List orgClassInfoMList = this.orgClassInfoMCompent.getByIdList(ids, true);
        if (CollectionUtils.isEmpty((Collection)orgClassInfoMList)) {
            return Collections.emptyList();
        }
        List<RecommendClassCourseDto> dtos = this.getRecommendClassCourseDtoList(orgClassInfoMList, orgId);
        return dtos;
    }
}

