/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.annotation.ReadWriteTransactional;
import com.baijia.orgclass.common.enums.AuditStatus;
import com.baijia.orgclass.common.enums.ClassStatusEnums;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.enums.OrgClassRetireFlagenums;
import com.baijia.orgclass.common.response.WebResponse;
import com.baijia.orgclass.common.utils.SerialNumberUtil;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassGroupCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgTmpTeacherFacadeCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassGroup;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgTmpTeacher;
import com.baijia.orgclass.core.model.biz.OrgCoursePriceDto;
import com.baijia.orgclass.facade.dto.ClassBatchUpdateResDto;
import com.baijia.orgclass.facade.dto.CourseInsertResDto;
import com.baijia.orgclass.facade.dto.OrgClassBaseInfoDto;
import com.baijia.orgclass.facade.dto.OrgClassCopyResDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseDto;
import com.baijia.orgclass.facade.dto.OrgClassGradeDto;
import com.baijia.orgclass.facade.dto.OrgClassInfoDto;
import com.baijia.orgclass.facade.dto.OrgClassInfoPageDto;
import com.baijia.orgclass.facade.dto.OrgClassInfoSearchDto;
import com.baijia.orgclass.facade.interfaces.OrgClassInfoFacade;
import com.baijia.orgclass.service.sub.OrgClassCourseService;
import com.baijia.orgclass.service.sub.OrgClassGradeService;
import com.baijia.orgclass.service.sub.OrgClassInfoService;
import com.baijia.orgclass.service.utils.AuditUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassInfoFacadeImpl
implements OrgClassInfoFacade {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassInfoFacadeImpl.class);
    @Autowired
    private OrgClassInfoService orgClassInfoService;
    @Autowired
    private OrgClassCourseService orgClassCourseService;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassGradeService orgClassGradeService;
    @Autowired
    private OrgClassGroupCompent orgClassGroupCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgTmpTeacherFacadeCompent orgTmpTeacherFacadeCompent;

    @ReadWriteTransactional
    public WebResponse<OrgClassInfoDto> insert4Id(OrgClassInfoDto dto, Integer tuid) {
        OrgClassInfo info = new OrgClassInfo();
        try {
            BeanUtils.copyProperties((Object)info, (Object)dto);
            info.setId(null);
        }
        catch (Exception e) {
            logger.error("save e:{}", (Throwable)e);
        }
        long count = this.orgClassInfoCompent.insert4Id(info);
        WebResponse res = new WebResponse();
        if (0L == count) {
            res.setCode(1);
            return res;
        }
        long id = info.getId();
        OrgClassCourseEnums enums = OrgClassCourseEnums.parse((Integer)info.getClassType());
        long number = SerialNumberUtil.generateClassInfoNumber((int)info.getId().intValue(), (OrgClassCourseEnums)enums);
        info = new OrgClassInfo();
        info.setNumber(Long.valueOf(number));
        info.setId(Long.valueOf(id));
        this.orgClassInfoCompent.updateById(info);
        if (tuid != null) {
            OrgTmpTeacher ott = new OrgTmpTeacher();
            ott.setOrgId(dto.getOrgId());
            ott.setTuid(tuid);
            this.orgTmpTeacherFacadeCompent.insert(ott);
        }
        OrgClassInfoDto rtdo = new OrgClassInfoDto();
        rtdo.setId(Long.valueOf(id));
        rtdo.setNumber(Long.valueOf(number));
        res.setData((Object)rtdo);
        return res;
    }

    @ReadWriteTransactional
    public WebResponse<OrgClassInfoDto> update(OrgClassInfoDto dto, long id, int orgId) {
        WebResponse res = new WebResponse();
        OrgClassInfo info = new OrgClassInfo();
        try {
            BeanUtils.copyProperties((Object)info, (Object)dto);
            info.setId(null);
        }
        catch (Exception e) {
            logger.error("update e:{}", (Throwable)e);
            res.setCode(1);
            return res;
        }
        OrgClassInfo old = this.orgClassInfoCompent.getById(id);
        if (AuditUtils.classAuditCheck(info, old)) {
            info.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        }
        Integer retireFlag = dto.getRetireFlag();
        if (1 == this.orgClassInfoCompent.update(info, id, orgId) && retireFlag != null && retireFlag.intValue() == OrgClassRetireFlagenums.CAN_NOT.getCode()) {
            OrgClassCourse course = new OrgClassCourse();
            course.setOrgClassId(Long.valueOf(id));
            course.setAutoConfirm(Boolean.valueOf(false));
            course.setMinStudent(Integer.valueOf(0));
            this.orgClassCourseCompent.update(course, orgId);
        }
        OrgClassInfoDto rtdo = new OrgClassInfoDto();
        rtdo.setId(Long.valueOf(id));
        rtdo.setNumber(old.getNumber());
        res.setData((Object)rtdo);
        return res;
    }

    public OrgClassInfoPageDto getOrgClassInfoPageDto(int orgId, int offset, int size) {
        OrgClassInfoPageDto orgClassInfoPageDto = new OrgClassInfoPageDto();
        int count = this.orgClassInfoCompent.getOrgClassInfoCount(orgId);
        if (count <= 0) {
            return orgClassInfoPageDto;
        }
        orgClassInfoPageDto.setCount(count);
        RowBounds rowBounds = new RowBounds(offset, size);
        List orgClassInfoList = this.orgClassInfoCompent.getOrgClassInfoList(Integer.valueOf(orgId), rowBounds);
        logger.info("[ClassInfo] getClassInfo:{}, orgId:{}, offset:{}, size:{}", new Object[]{orgClassInfoList.size(), orgId, offset, size});
        if (CollectionUtils.isNotEmpty((Collection)orgClassInfoList)) {
            ArrayList orgClassInfoIds = Lists.newArrayList();
            for (OrgClassInfo orgClassInfo : orgClassInfoList) {
                orgClassInfoIds.add(orgClassInfo.getId());
            }
            List orgCoursePriceDtoList = this.orgClassCourseCompent.selectPrice((List)orgClassInfoIds, orgId);
            HashMap priceMap = Maps.newHashMap();
            if (orgCoursePriceDtoList != null && orgCoursePriceDtoList.size() > 0) {
                for (OrgCoursePriceDto dto : orgCoursePriceDtoList) {
                    priceMap.put(dto.getOrgClassId(), dto);
                }
            }
            ArrayList dtos = Lists.newArrayList();
            for (OrgClassInfo orgClassInfo : orgClassInfoList) {
                Long orgClassInfoId = orgClassInfo.getId();
                OrgClassBaseInfoDto dto = this.buildOrgClassBaseInfoDtoInstance(orgClassInfo);
                OrgCoursePriceDto priceDto = (OrgCoursePriceDto)priceMap.get(orgClassInfoId);
                if (priceDto != null) {
                    dto.setMaxPrice(priceDto.getMaxPrice());
                    dto.setMinPrice(priceDto.getMinPrice());
                }
                dtos.add(dto);
            }
            orgClassInfoPageDto.setList((List)dtos);
        }
        return orgClassInfoPageDto;
    }

    private OrgClassBaseInfoDto buildOrgClassBaseInfoDtoInstance(OrgClassInfo orgClassInfo) {
        OrgClassBaseInfoDto dto = new OrgClassBaseInfoDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)orgClassInfo);
            dto.setCreateTime(Long.valueOf(orgClassInfo.getCreateTime().getTime()));
        }
        catch (Exception e) {
            logger.error("get classInfo error:{}", (Throwable)e);
        }
        return dto;
    }

    @ReadWriteTransactional
    public OrgClassCopyResDto copy(long id, int orgId) {
        logger.error("copy :{}", (Object)id);
        OrgClassInfo info = new OrgClassInfo();
        info.setId(Long.valueOf(id));
        info.setOrgId(Integer.valueOf(orgId));
        info = this.orgClassInfoCompent.selectOne(info);
        OrgClassCopyResDto dto = new OrgClassCopyResDto();
        if (info == null) {
            return dto;
        }
        OrgClassCourse course = new OrgClassCourse();
        course.setOrgClassId(info.getId());
        course.setOrgId(Integer.valueOf(orgId));
        List courseList = this.orgClassCourseCompent.select(course, orgId);
        logger.error("courseList :{}", (Object)courseList);
        id = this.orgClassInfoService.doInsert(info);
        info = this.orgClassInfoCompent.getById(id);
        if (CollectionUtils.isNotEmpty((Collection)courseList)) {
            this.handleCourse(courseList, info);
        }
        dto.setId(id);
        dto.setCourseList(this.handleCourse(id, orgId, info));
        return dto;
    }

    private List<OrgClassCourseDto> handleCourse(long id, int orgId, OrgClassInfo info) {
        List courseList = this.orgClassCourseCompent.selectByInfoId(id, orgId);
        if (CollectionUtils.isEmpty((Collection)courseList)) {
            return Collections.emptyList();
        }
        OrgClassInfoDto orgClassInfoDto = new OrgClassInfoDto();
        try {
            BeanUtils.copyProperties((Object)orgClassInfoDto, (Object)info);
        }
        catch (Exception e) {
            logger.error("handleCourse e - ", (Throwable)e);
        }
        ArrayList dtoList = Lists.newArrayList();
        for (OrgClassCourse course : courseList) {
            try {
                OrgClassCourseDto dto = new OrgClassCourseDto();
                BeanUtils.copyProperties((Object)dto, (Object)course);
                dto.setOrgClassInfoDto(orgClassInfoDto);
                dtoList.add(dto);
            }
            catch (Exception e) {
                logger.error("handleCourse e - ", (Throwable)e);
            }
        }
        return dtoList;
    }

    private void handleCourse(List<OrgClassCourse> courseList, OrgClassInfo info) {
        ArrayList newCourseList = Lists.newArrayList();
        for (OrgClassCourse tmp : courseList) {
            try {
                OrgClassCourse newCourse = new OrgClassCourse();
                BeanUtils.copyProperties((Object)newCourse, (Object)tmp);
                newCourse.setOrgClassId(info.getId());
                newCourse.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
                newCourseList.add(newCourse);
            }
            catch (Exception e) {
                logger.error("copy e:{}", (Throwable)e);
            }
        }
        logger.error("handleCourse newCourseList:{}", (Object)newCourseList);
        for (OrgClassCourse tmp : newCourseList) {
            long oldCourseId = tmp.getId();
            CourseInsertResDto dto = this.orgClassCourseService.doInsert(tmp, info);
            this.orgClassGradeService.copyGrade(oldCourseId, info.getClassType(), dto.getCourseId(), info.getOrgId(), info.getId());
        }
    }

    public List<OrgClassInfoDto> getClassByNumbers(Integer orgId, List<Long> numbers) {
        List infos = this.orgClassInfoCompent.getClassByNumbers(orgId, numbers);
        if (infos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList dtos = Lists.newArrayList();
        for (OrgClassInfo info : infos) {
            OrgClassInfoDto dto = new OrgClassInfoDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)info);
                dtos.add(dto);
            }
            catch (Exception e) {
                logger.error("getClassByNumbers e:{}", (Throwable)e);
            }
        }
        return dtos;
    }

    public OrgClassInfoDto getClassInfoById(Integer orgId, Long id) {
        OrgClassInfo paramInfo = new OrgClassInfo();
        paramInfo.setOrgId(orgId);
        paramInfo.setId(id);
        OrgClassInfo info = this.orgClassInfoCompent.selectOne(paramInfo);
        OrgClassInfoDto dto = new OrgClassInfoDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)info);
            return dto;
        }
        catch (Exception e) {
            logger.error("getClassInfoById id:{},e - ", (Object)id, (Object)e);
            return null;
        }
    }

    public int update(OrgClassInfoDto dto, List<Long> idList, Integer orgId) {
        OrgClassInfo info = new OrgClassInfo();
        try {
            BeanUtils.copyProperties((Object)info, (Object)dto);
            return this.orgClassInfoCompent.update(info, idList, orgId.intValue());
        }
        catch (Exception e) {
            logger.error("update idList:{} e -", idList, (Object)e);
            return 0;
        }
    }

    @ReadWriteTransactional
    public WebResponse<ClassBatchUpdateResDto> delete(List<Long> idList, Integer orgId) {
        return this.orgClassInfoService.batchHandle(idList, orgId, ClassStatusEnums.DELETE);
    }

    @ReadWriteTransactional
    public WebResponse<ClassBatchUpdateResDto> offShelves(List<Long> idList, int orgId) {
        return this.orgClassInfoService.batchHandle(idList, orgId, ClassStatusEnums.OFF_SHELVES);
    }

    @ReadWriteTransactional
    public WebResponse<ClassBatchUpdateResDto> onShelves(List<Long> idList, int orgId) {
        return this.orgClassInfoService.onShelves(idList, orgId);
    }

    public WebResponse<ClassBatchUpdateResDto> publish(OrgClassInfoDto dto, long id, int orgId) {
        WebResponse<OrgClassInfoDto> rest = this.update(dto, id, orgId);
        if (rest.getCode() != 0) {
            WebResponse res = new WebResponse();
            res.setCode(1);
            return res;
        }
        ArrayList idList = Lists.newArrayList();
        idList.add(id);
        WebResponse<ClassBatchUpdateResDto> res = this.orgClassInfoService.onShelves(idList, orgId);
        ClassBatchUpdateResDto data = (ClassBatchUpdateResDto)res.getData();
        if (data == null) {
            data = new ClassBatchUpdateResDto();
        }
        OrgClassInfo info = this.orgClassInfoCompent.getById(id);
        OrgClassInfoDto orgClassInfoDto = new OrgClassInfoDto();
        try {
            BeanUtils.copyProperties((Object)orgClassInfoDto, (Object)info);
            data.setOrgClassInfoDto(orgClassInfoDto);
        }
        catch (Exception e) {
            logger.error("publish e -", (Throwable)e);
        }
        if (res.getCode() == 0) {
            List gradeList = this.orgClassGradeCompent.getByInfoId(Integer.valueOf(orgId), Long.valueOf(id));
            ArrayList gradeDtoList = Lists.newArrayList();
            for (OrgClassGrade grade : gradeList) {
                if (grade.getGroupId() != null && 0L != grade.getGroupId()) continue;
                OrgClassGradeDto gt = new OrgClassGradeDto();
                gt.setGradeName(grade.getGradeName());
                gt.setGradeNumber(grade.getNumber());
                gradeDtoList.add(gt);
            }
            data.setGradeList((List)gradeDtoList);
        }
        res.setData((Object)data);
        return res;
    }

    public OrgClassInfoSearchDto searchOne(Long number, int orgId) {
        OrgClassInfo info = new OrgClassInfo();
        info.setNumber(number);
        info.setOrgId(Integer.valueOf(orgId));
        info = this.orgClassInfoCompent.selectOne(info);
        OrgClassInfoSearchDto dto = new OrgClassInfoSearchDto();
        if (info == null) {
            return dto;
        }
        try {
            BeanUtils.copyProperties((Object)dto, (Object)info);
        }
        catch (Exception e) {
            logger.error("searchOne e - ", (Throwable)e);
            return dto;
        }
        OrgClassGroup group = this.orgClassGroupCompent.select(dto.getGroupId().intValue(), orgId);
        dto.setGroupName(group.getName());
        List courseList = this.orgClassCourseCompent.selectByInfoId(dto.getId().longValue(), orgId);
        ArrayList cdtoList = Lists.newArrayList();
        ArrayList courseIdList = Lists.newArrayList();
        for (OrgClassCourse course : courseList) {
            OrgClassCourseDto cdto = new OrgClassCourseDto();
            try {
                BeanUtils.copyProperties((Object)cdto, (Object)course);
                cdtoList.add(cdto);
                courseIdList.add(course.getId());
            }
            catch (Exception e) {
                logger.error("searchOne e - ", (Throwable)e);
            }
        }
        this.orgClassGradeService.handleGrade(courseIdList, cdtoList);
        dto.setCourseList((List)cdtoList);
        return dto;
    }

    public List<Integer> getRecentlySubjectId(int orgId, int limit) {
        return this.orgClassInfoCompent.getRecentlySubjectId(orgId, limit);
    }

    public OrgClassInfoDto getClassByGradeNumber(int orgId, Long gradeNumber) {
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(Integer.valueOf(orgId), gradeNumber);
        if (grade == null) {
            return null;
        }
        Long classInfoId = grade.getClassInfoId();
        OrgClassInfo info = new OrgClassInfo();
        info.setId(classInfoId);
        info.setOrgId(Integer.valueOf(orgId));
        info = this.orgClassInfoCompent.selectOne(info);
        if (info.getTitle() == null) {
            return null;
        }
        OrgClassInfoDto dto = new OrgClassInfoDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)info);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("get error:{}", (Throwable)e);
        }
        return dto;
    }

    public OrgClassInfoDto getClassByCourseNumber(int orgId, Long courseNumber) {
        OrgClassCourse course = new OrgClassCourse();
        course.setOrgId(Integer.valueOf(orgId));
        course.setNumber(courseNumber);
        course = this.orgClassCourseCompent.selectOne(course);
        if (course.getOrgClassId() == null) {
            return null;
        }
        Long classId = course.getOrgClassId();
        OrgClassInfo classInfo = this.orgClassInfoCompent.getById(classId.longValue());
        OrgClassInfoDto dto = new OrgClassInfoDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)classInfo);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("get error:{}", (Throwable)e);
        }
        return dto;
    }

    public List<OrgClassInfoDto> getOrgClassInfoDtoListByIds(List<Long> ids, boolean flag) {
        List orgClassInfoList = this.orgClassInfoCompent.getByIdList(ids, flag);
        if (CollectionUtils.isEmpty((Collection)orgClassInfoList)) {
            return Collections.emptyList();
        }
        ArrayList dtos = Lists.newArrayList();
        for (OrgClassInfo orgClassInfo : orgClassInfoList) {
            try {
                OrgClassInfoDto dto = new OrgClassInfoDto();
                BeanUtils.copyProperties((Object)dto, (Object)orgClassInfo);
                dtos.add(dto);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("get error:{}", (Throwable)e);
            }
        }
        return dtos;
    }
}

