/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.annotation.ReadWriteTransactional;
import com.baijia.orgclass.core.compent.OrgClassGroupCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.model.auto.OrgClassGroup;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.facade.dto.OrgClassGroupDto;
import com.baijia.orgclass.facade.interfaces.OrgClassGroupFacade;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassGroupFacadeImpl
implements OrgClassGroupFacade {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassGroupFacadeImpl.class);
    @Autowired
    private OrgClassGroupCompent orgClassGroupCompent;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;

    public List<OrgClassGroupDto> search(int orgId) {
        List list = this.orgClassGroupCompent.search(orgId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            OrgClassGroup group = new OrgClassGroup();
            group.setName("\u9ed8\u8ba4\u5206\u7ec4");
            group.setOrgId(Integer.valueOf(orgId));
            int count = this.orgClassGroupCompent.insert4Id(group);
            if (count == 0) {
                return Collections.emptyList();
            }
            list.add(group);
        }
        return this.parseDto(list);
    }

    private List<OrgClassGroupDto> parseDto(List<OrgClassGroup> list) {
        ArrayList result = Lists.newArrayList();
        for (OrgClassGroup ocg : list) {
            try {
                OrgClassGroupDto dto = new OrgClassGroupDto();
                BeanUtils.copyProperties((Object)dto, (Object)ocg);
                result.add(dto);
            }
            catch (Exception e) {
                logger.error("parseDto e:{}", (Throwable)e);
            }
        }
        return result;
    }

    public int save(OrgClassGroupDto dto, int orgId) {
        OrgClassGroup group = new OrgClassGroup();
        group.setName(dto.getName());
        group.setOrgId(Integer.valueOf(orgId));
        int count = this.orgClassGroupCompent.insert4Id(group);
        if (count == 0) {
            return 0;
        }
        return group.getId();
    }

    public int update(OrgClassGroupDto dto, Integer id, Integer orgId) {
        OrgClassInfo info = new OrgClassInfo();
        info.setGroupId(id);
        if (this.orgClassInfoCompent.selectCount(info, orgId.intValue()) > 0) {
            return -1;
        }
        OrgClassGroup group = new OrgClassGroup();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)group);
            group.setOrgId(orgId);
        }
        catch (Exception e) {
            logger.error("save :{}", (Throwable)e);
        }
        return this.orgClassGroupCompent.update(group, id, orgId.intValue());
    }

    @ReadWriteTransactional
    public int delete(Integer id, Integer orgId) {
        this.handleClass(id, orgId);
        OrgClassGroup group = new OrgClassGroup();
        group.setIsDel(Boolean.valueOf(true));
        return this.orgClassGroupCompent.update(group, id, orgId.intValue());
    }

    private void handleClass(Integer id, Integer orgId) {
        OrgClassInfo info = new OrgClassInfo();
        info.setGroupId(id);
        List classList = this.orgClassInfoCompent.selectList(info, orgId.intValue());
        if (CollectionUtils.isEmpty((Collection)classList)) {
            return;
        }
        OrgClassGroup group = new OrgClassGroup();
        group.setName("\u9ed8\u8ba4\u5206\u7ec4");
        group = this.orgClassGroupCompent.selectOne(group, orgId.intValue());
        info.setGroupId(group.getId());
        List idList = Lists.transform((List)classList, (Function)new Function<OrgClassInfo, Long>(){

            public Long apply(OrgClassInfo from) {
                return from.getId();
            }
        });
        this.orgClassInfoCompent.update(info, idList, orgId.intValue());
    }

    public OrgClassGroupDto searchById(int id, Integer orgId) {
        OrgClassGroup group = this.orgClassGroupCompent.select(id, orgId.intValue());
        OrgClassGroupDto dto = new OrgClassGroupDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)group);
        }
        catch (Exception e) {
            logger.error("searchById e - ", (Throwable)e);
        }
        return dto;
    }
}

