/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.annotation.ReadWriteTransactional;
import com.baijia.orgclass.common.enums.GradeGraStatusEnums;
import com.baijia.orgclass.common.enums.GradePurStatusEnums;
import com.baijia.orgclass.common.enums.GradeStuSuspendEnums;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.exception.BussinessException;
import com.baijia.orgclass.common.response.WebResponseCodeEnums;
import com.baijia.orgclass.common.utils.SerialNumberUtil;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgGradePurchaseCompent;
import com.baijia.orgclass.core.compent.OrgSuspendRecordCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgClassSuspendRecord;
import com.baijia.orgclass.core.model.auto.OrgGradePurchase;
import com.baijia.orgclass.facade.dto.OrgClassGradeDto;
import com.baijia.orgclass.facade.dto.OrgGradeOneVoneDto;
import com.baijia.orgclass.facade.dto.OrgGradeStudentDto;
import com.baijia.orgclass.facade.interfaces.OrgClassGradeFacade;
import com.baijia.orgclass.facade.interfaces.OrgClassLiveFacade;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassGradeFacadeImpl
implements OrgClassGradeFacade {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassGradeFacadeImpl.class);
    @Autowired
    private OrgClassLiveFacade orgClassLiveFacade;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgGradePurchaseCompent orgGradePurchaseCompent;
    @Autowired
    private OrgSuspendRecordCompent orgSuspendRecordCompent;
    public static Integer ONEVONE_STU_NUMBER = 1;

    public List<OrgClassGradeDto> getGradesByCourseNumber(Integer offset, Integer limit, Integer orgId, Long courseNumber) {
        List grades;
        RowBounds rowBounds = new RowBounds(offset.intValue(), limit.intValue());
        Long gradeCourseId = null;
        if (courseNumber != null) {
            OrgClassCourse course = new OrgClassCourse();
            course.setNumber(courseNumber);
            course.setOrgId(orgId);
            OrgClassCourse select = this.orgClassCourseCompent.selectOne(course);
            if (select == null) {
                return Collections.emptyList();
            }
            gradeCourseId = select.getId();
        }
        if (CollectionUtils.isEmpty((Collection)(grades = this.orgClassGradeCompent.getGradeByCourseId(rowBounds, orgId, gradeCourseId)))) {
            return Collections.emptyList();
        }
        List classIds = Lists.newArrayList();
        List courseIds = Lists.newArrayList();
        List gradeIds = Lists.newArrayList();
        for (OrgClassGrade grade : grades) {
            Long class_id = grade.getClassInfoId();
            classIds.add(class_id);
            Long course_id = grade.getCourseId();
            courseIds.add(course_id);
            Long grade_id = grade.getId();
            gradeIds.add(grade_id);
        }
        Map<Long, OrgClassInfo> infoMaps = this.getClassByClassInfoIds(classIds);
        List classCourses = this.orgClassCourseCompent.selectByIdList(courseIds);
        Map courseMaps = Maps.newHashMap();
        for (OrgClassCourse courseDto : classCourses) {
            courseMaps.put(courseDto.getId(), courseDto);
        }
        Map enterStatus = this.orgClassLiveFacade.checkIsEnterLiveRoom(orgId.intValue(), gradeIds);
        Map<Long, Integer> classCounts = this.getFinishedByGradeIds(orgId, gradeIds);
        Map<Long, Integer> classCountMap = this.getOVOClassCount(gradeIds);
        List<OrgClassGradeDto> dtos = this.togetherAllInfos(grades, classCounts, infoMaps, courseMaps, enterStatus, classCountMap);
        return dtos;
    }

    private List<OrgClassGradeDto> togetherAllInfos(List<OrgClassGrade> grades, Map<Long, Integer> classCounts, Map<Long, OrgClassInfo> infoMaps, Map<Long, OrgClassCourse> courseMaps, Map<Long, Boolean> enterStatus, Map<Long, Integer> classCountMap) {
        List dtos = Lists.newArrayList();
        for (OrgClassGrade grade : grades) {
            Integer count;
            OrgClassCourse classCourse;
            Integer finished;
            OrgClassGradeDto dto = new OrgClassGradeDto();
            dto.setGradeName(grade.getGradeName());
            dto.setGradeNumber(grade.getNumber());
            dto.setStuCount(grade.getCount().intValue());
            dto.setStatus(grade.getStatus().intValue());
            if (grade.getEndTime() != null) {
                dto.setEndTime(Long.valueOf(grade.getEndTime().getTime()));
            }
            if ((finished = classCounts.get(grade.getId())) == null) {
                dto.setFinished(0);
            } else {
                dto.setFinished(finished.intValue());
            }
            OrgClassInfo classInfo = infoMaps.get(grade.getClassInfoId());
            if (classInfo != null) {
                dto.setClassName(classInfo.getTitle());
                dto.setClassType(classInfo.getClassType().intValue());
                dto.setLessonWay(classInfo.getLessonWay().intValue());
            }
            if ((classCourse = courseMaps.get(grade.getCourseId())) != null) {
                dto.setCourseName(classCourse.getName());
                dto.setCourseNumber(classCourse.getNumber());
                dto.setTeacherId(classCourse.getTeacherUid());
                dto.setTotal(classCourse.getClassCount().intValue());
                dto.setClassLength(classCourse.getClassLength().intValue());
            }
            if ((count = classCountMap.get(grade.getId())) != null) {
                dto.setTotal(count.intValue());
            }
            if (enterStatus.get(grade.getId()) != null && enterStatus.get(grade.getId()).booleanValue()) {
                dto.setCanEnter(Boolean.valueOf(true));
            }
            dtos.add(dto);
        }
        return dtos;
    }

    private Map<Long, Integer> getOVOClassCount(List<Long> gradeIdList) {
        if (CollectionUtils.isEmpty(gradeIdList)) {
            return Collections.emptyMap();
        }
        List list = this.orgGradePurchaseCompent.getByGradeIdList(gradeIdList);
        Map map = Maps.newHashMap();
        for (OrgGradePurchase gp : list) {
            map.put(gp.getGradeId(), gp.getClassCount());
        }
        return map;
    }

    public Integer getCountByCourseId(Integer orgId, Long courseNumber) {
        Long courseId;
        if (courseNumber == null) {
            courseId = null;
        } else {
            OrgClassCourse course = new OrgClassCourse();
            course.setNumber(courseNumber);
            course.setOrgId(orgId);
            courseId = this.orgClassCourseCompent.selectOne(course).getId();
            if (courseId == null) {
                return null;
            }
        }
        return this.orgClassGradeCompent.getCountByCourseId(orgId, courseId);
    }

    private Map<Long, Integer> getFinishedByGradeIds(Integer orgId, List<Long> gradeIds) {
        List schedules = this.orgClassScheduleCompent.finishClassCount(gradeIds, orgId.intValue());
        Map maps = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)schedules)) {
            for (OrgClassSchedule schedule : schedules) {
                Long gradeId = schedule.getGradeId();
                maps.put(gradeId, schedule.getClassCount());
            }
        }
        return maps;
    }

    private Map<Long, OrgClassInfo> getClassByClassInfoIds(List<Long> ids) {
        List dtos = this.orgClassInfoCompent.getByIdList(ids, false);
        if (dtos == null || dtos.isEmpty()) {
            return Collections.emptyMap();
        }
        Map maps = Maps.newHashMap();
        for (OrgClassInfo dto : dtos) {
            maps.put(dto.getId(), dto);
        }
        return maps;
    }

    public int endGradeByGradeNumber(Integer orgId, Long gradeNumber, boolean flag) {
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(orgId, gradeNumber);
        if (grade == null) {
            return -1;
        }
        if (flag) {
            grade.setStatus(Integer.valueOf(GradeGraStatusEnums.HAS_GRADUATION.getCode()));
            return this.orgClassGradeCompent.graduateById(grade);
        }
        grade.setStatus(Integer.valueOf(GradeGraStatusEnums.NO_GRADUATION.getCode()));
        return this.orgClassGradeCompent.updateById(grade);
    }

    public OrgClassGradeDto getGradeByGradeNumber(Integer orgId, Long gradeNumber) {
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(orgId, gradeNumber);
        if (grade == null) {
            return null;
        }
        OrgClassGradeDto dto = new OrgClassGradeDto();
        dto.setGradeNumber(grade.getNumber());
        dto.setGradeNumber(grade.getNumber());
        if (grade.getEndTime() != null) {
            dto.setEndTime(Long.valueOf(grade.getEndTime().getTime()));
        }
        Long courseId = grade.getCourseId();
        OrgClassCourse course = this.orgClassCourseCompent.selectById(courseId.longValue());
        dto.setTotal(course.getClassCount().intValue());
        dto.setCourseName(course.getName());
        dto.setCourseNumber(course.getNumber());
        dto.setClassLength(course.getClassLength().intValue());
        Long classId = grade.getClassInfoId();
        OrgClassInfo classInfo = this.orgClassInfoCompent.getById(classId.longValue());
        dto.setClassName(classInfo.getTitle());
        dto.setClassType(classInfo.getClassType().intValue());
        dto.setLessonWay(classInfo.getLessonWay().intValue());
        return dto;
    }

    public OrgClassGradeDto getGradeById(Long gradeId) {
        OrgClassGrade grade = this.orgClassGradeCompent.selectById(gradeId);
        OrgClassGradeDto dto = new OrgClassGradeDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)grade);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return dto;
    }

    public Map<Long, Long> getGroupNumberByGradeNumber(Integer orgId, List<Long> gradeNumbers) {
        List grades = this.orgClassGradeCompent.getGradesByNumbers(orgId, gradeNumbers);
        if (grades == null || grades.isEmpty()) {
            return null;
        }
        Map maps = Maps.newHashMap();
        for (OrgClassGrade grade : grades) {
            maps.put(grade.getNumber(), grade.getGroupId());
        }
        return maps;
    }

    @ReadWriteTransactional
    public int createOneVoneGrade(Integer orgId, OrgGradeOneVoneDto dto) {
        OrgClassGrade grade = new OrgClassGrade();
        grade.setOrgId(orgId);
        Long courseNumber = dto.getCourseNumber();
        OrgClassCourse course = new OrgClassCourse();
        course.setOrgId(orgId);
        course.setNumber(courseNumber);
        course = this.orgClassCourseCompent.selectOne(course);
        if (course.getName() == null) {
            logger.error("createOneVoneGrade course not found!!!");
            return -1;
        }
        grade.setGradeName(String.valueOf(course.getName()) + "_" + dto.getStudentName());
        Long courseId = course.getId();
        Long classId = course.getOrgClassId();
        grade.setClassInfoId(classId);
        grade.setCourseId(courseId);
        grade.setCount(ONEVONE_STU_NUMBER);
        long result = this.orgClassGradeCompent.insertForId(grade);
        if (0L == result) {
            logger.error("createOneVoneGrade failed:{}", (Object)grade.getId());
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        Long gradeId = this.orgClassGradeCompent.selectOne(grade, orgId.intValue()).getId();
        Long gradeNumber = SerialNumberUtil.generateGradeNumber((int)gradeId.intValue(), (OrgClassCourseEnums)OrgClassCourseEnums.OVO);
        OrgClassGrade check = this.orgClassGradeCompent.getGradeByNumber(orgId, gradeNumber);
        if (check != null) {
            logger.error("createOneVoneGrade has added:{}", (Object)grade.getId());
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        grade.setNumber(gradeNumber);
        result = this.orgClassGradeCompent.updateById(grade);
        if (0L == result) {
            logger.error("createOneVoneGrade failed:{}", (Object)grade.getId());
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        OrgGradePurchase purchase = new OrgGradePurchase();
        purchase.setOrgId(orgId);
        purchase.setOrgClassId(classId);
        purchase.setOrgCourseId(courseId);
        purchase.setGradeId(gradeId);
        purchase.setPurchaseId(dto.getPurchaseId());
        purchase.setStudentId(dto.getStudentId());
        purchase.setClassCount(Integer.valueOf(dto.getClassCount()));
        result = this.orgGradePurchaseCompent.insert(purchase);
        if (0L == result) {
            logger.error("createOneVoneGrade failed:{}", (Object)grade.getId());
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        logger.info("createOneVoneGrade ok purchaseId:{}", (Object)dto.getPurchaseId());
        return 1;
    }

    public Long getGroupIdByCourseNumber(Integer orgId, Long courseNumber) {
        OrgClassCourse course = new OrgClassCourse();
        course.setOrgId(orgId);
        course.setNumber(courseNumber);
        course = this.orgClassCourseCompent.selectOne(course);
        if (course.getName() == null) {
            return null;
        }
        Long courseId = course.getId();
        List grades = this.orgClassGradeCompent.getGradeByCourseId(orgId.intValue(), courseId);
        if (grades.isEmpty()) {
            return null;
        }
        OrgClassGrade grade = (OrgClassGrade)grades.get(0);
        Long groupId = grade.getGroupId();
        return groupId;
    }

    public int updateGroupId(Long number, Long groupId) {
        return this.orgClassGradeCompent.updateGroupId(number.longValue(), groupId.longValue());
    }

    public OrgGradeStudentDto getOvOStudentByGradeNumber(Integer orgId, Long gradeNumber) {
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(orgId, gradeNumber);
        if (grade == null) {
            return null;
        }
        OrgGradePurchase purchase = new OrgGradePurchase();
        purchase.setOrgId(orgId);
        purchase.setGradeId(grade.getId());
        OrgGradePurchase onePurchase = this.orgGradePurchaseCompent.selectOne(purchase, orgId.intValue());
        if (onePurchase == null) {
            return null;
        }
        OrgClassCourse course = new OrgClassCourse();
        course.setOrgId(orgId);
        course.setId(grade.getCourseId());
        course = this.orgClassCourseCompent.selectOne(course);
        if (course.getName() == null) {
            return null;
        }
        OrgGradeStudentDto dto = new OrgGradeStudentDto();
        dto.setGradeNumber(grade.getNumber());
        dto.setCourseNumber(course.getNumber());
        dto.setStuUserId(Integer.valueOf(onePurchase.getStudentId().intValue()));
        dto.setTotalClassCount(onePurchase.getClassCount());
        dto.setPurchaseId(onePurchase.getPurchaseId());
        OrgClassSuspendRecord suspend = new OrgClassSuspendRecord();
        suspend.setOrgId(orgId);
        suspend.setGradeNumber(grade.getNumber());
        suspend.setUserId(Integer.valueOf(onePurchase.getStudentId().intValue()));
        OrgClassSuspendRecord record = this.orgSuspendRecordCompent.selectOne(suspend);
        if (record == null || GradeStuSuspendEnums.IN_CLASS.getCode() == record.getEffectiveFlag().intValue()) {
            dto.setStatus(Integer.valueOf(GradeStuSuspendEnums.IN_CLASS.getCode()));
        } else {
            dto.setStatus(Integer.valueOf(GradeStuSuspendEnums.OUT_CLASS.getCode()));
        }
        return dto;
    }

    @ReadWriteTransactional
    public int removeFromGrade(Integer orgId, Long courseNumber, Long purchaseId) {
        OrgClassGrade grade;
        logger.info("removeFromGrade orgId:{},courseNumber:{},purchaseId:{}", new Object[]{orgId, courseNumber, purchaseId});
        OrgClassCourse course = new OrgClassCourse();
        course.setNumber(courseNumber);
        course.setOrgId(orgId);
        course = this.orgClassCourseCompent.selectOne(course);
        if (course.getId() == null || 0L == course.getId()) {
            return -1;
        }
        Long courseId = course.getId();
        OrgGradePurchase select = new OrgGradePurchase();
        select.setOrgId(orgId);
        select.setOrgCourseId(courseId);
        select.setPurchaseId(purchaseId);
        OrgGradePurchase purchase = this.orgGradePurchaseCompent.selectOne(select, orgId.intValue());
        int result = 0;
        if (purchase != null) {
            Long gradeId = purchase.getGradeId();
            OrgClassGrade grade2 = this.orgClassGradeCompent.selectById(gradeId);
            grade2.setStatus(Integer.valueOf(GradeGraStatusEnums.PUR_REFOUNDED.getCode()));
            result = this.orgClassGradeCompent.updateById(grade2);
            if (result == 0) {
                logger.error("removeFromGrade failed:{}", (Object)grade2.getId());
                throw new BussinessException(WebResponseCodeEnums.FAIL);
            }
            purchase.setStatus(Integer.valueOf(GradePurStatusEnums.PUR_REFOUNDED.getStatus()));
            this.orgGradePurchaseCompent.updateById(purchase);
            if (result == 0) {
                logger.error("removeFromGrade failed:{}", (Object)grade2.getId());
                throw new BussinessException(WebResponseCodeEnums.FAIL);
            }
            return 1;
        }
        List grades = this.orgClassGradeCompent.getGradeByCourseId(orgId.intValue(), courseId);
        if (CollectionUtils.isNotEmpty((Collection)grades) && (grade = (OrgClassGrade)grades.get(0)) != null) {
            if (grade.getCount() - 1 >= 0) {
                grade.setCount(Integer.valueOf(grade.getCount() - 1));
            } else {
                grade.setCount(Integer.valueOf(0));
            }
            this.orgClassGradeCompent.updateById(grade);
            return 1;
        }
        return 0;
    }

    public Map<Long, Integer> getFinishClassCount(Integer orgId, Long gradeNumber) {
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(orgId, gradeNumber);
        if (grade == null) {
            return Collections.emptyMap();
        }
        Long gradeId = grade.getId();
        List gradeIds = Lists.newArrayList();
        gradeIds.add(gradeId);
        List schedules = this.orgClassScheduleCompent.finishClassCount(gradeIds, orgId.intValue());
        Map maps = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)schedules)) {
            for (OrgClassSchedule schedule : schedules) {
                if (gradeId != schedule.getGradeId()) continue;
                maps.put(gradeNumber, schedule.getClassCount());
            }
        }
        return maps;
    }
}

