/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.annotation.ReadWriteTransactional;
import com.baijia.orgclass.common.enums.AuditStatus;
import com.baijia.orgclass.common.enums.ClassStatusEnums;
import com.baijia.orgclass.common.enums.ImStatusEnums;
import com.baijia.orgclass.common.enums.LessonWayEnums;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.enums.OrgClassRetireFlagenums;
import com.baijia.orgclass.common.enums.PriceTypeEnums;
import com.baijia.orgclass.common.enums.ResponseEnums;
import com.baijia.orgclass.common.enums.VipMaxStudentEnums;
import com.baijia.orgclass.common.exception.BussinessException;
import com.baijia.orgclass.common.response.WebResponse;
import com.baijia.orgclass.common.response.WebResponseCodeEnums;
import com.baijia.orgclass.common.utils.DateUtils;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassCourseMCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgGradePurchaseCompent;
import com.baijia.orgclass.core.compent.OrgMinStartClassCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassCourseM;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgGradePurchase;
import com.baijia.orgclass.core.model.auto.OrgMinStartClass;
import com.baijia.orgclass.core.model.biz.CourseStudentCountDto;
import com.baijia.orgclass.core.model.biz.OrgClassCourseGradeBiz;
import com.baijia.orgclass.core.model.biz.OrgTeacherCourseBiz;
import com.baijia.orgclass.facade.dto.CourseInsertResDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseGradeDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseInfoDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseListDto;
import com.baijia.orgclass.facade.dto.OrgClassCoursePageDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseSaleDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseSearchDto;
import com.baijia.orgclass.facade.dto.OrgClassInfoDto;
import com.baijia.orgclass.facade.dto.OrgTeacherCourseDto;
import com.baijia.orgclass.facade.dto.ScheduleMinTimeDto;
import com.baijia.orgclass.facade.interfaces.OrgClassCourseFacade;
import com.baijia.orgclass.service.sub.OrgClassCourseService;
import com.baijia.orgclass.service.sub.OrgClassGradeService;
import com.baijia.orgclass.service.utils.AuditUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassCourseFacadeImpl
implements OrgClassCourseFacade {
    private static final Logger logger = LoggerFactory.getLogger(OrgClassCourseFacadeImpl.class);
    private static final int PAGE_DEFAULT_SIZE = 500;
    @Autowired
    private OrgClassCourseService orgClassCourseService;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgClassCourseMCompent orgClassCourseMCompent;
    @Autowired
    private OrgClassGradeService orgClassGradeService;
    @Autowired
    private OrgGradePurchaseCompent orgGradePurchaseCompent;
    @Autowired
    private OrgMinStartClassCompent orgMinStartClassCompent;

    @ReadWriteTransactional
    public WebResponse<OrgClassCourseDto> insert4Id(OrgClassCourseDto dto) {
        WebResponse<OrgClassCourseDto> res = null;
        OrgClassInfo info = this.orgClassInfoCompent.getById(dto.getOrgClassId().longValue());
        res = this.checkRetireFlag(info.getRetireFlag(), dto);
        if (res != null) {
            return res;
        }
        boolean isCourseLive = this.getIsCourseLive(info.getLessonWay(), info.getClassType());
        res = this.checkMaxStudent(info.getLessonWay(), isCourseLive, dto, 0, null);
        if (res != null) {
            return res;
        }
        res = this.checkPlanStudent(info.getLessonWay(), isCourseLive, dto, 0, null);
        if (isCourseLive) {
            this.setAutoEnlargeSetting(dto);
        }
        OrgClassCourse course = new OrgClassCourse();
        OrgClassInfoDto orgClassInfoDto = new OrgClassInfoDto();
        try {
            BeanUtils.copyProperties((Object)course, (Object)dto);
            BeanUtils.copyProperties((Object)orgClassInfoDto, (Object)info);
            course.setId(null);
            course.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        }
        catch (Exception e) {
            logger.error("insert4Id e:{}", (Throwable)e);
            res = new WebResponse();
            res.setCode(1);
            return res;
        }
        CourseInsertResDto rdto = this.orgClassCourseService.doInsert(course, info);
        dto.setId(Long.valueOf(rdto.getCourseId()));
        dto.setNumber(Long.valueOf(rdto.getNumber()));
        dto.setOrgClassInfoDto(orgClassInfoDto);
        ArrayList gradeNumberList = Lists.newArrayList();
        gradeNumberList.add(rdto.getGradeNumber());
        dto.setGradeNumberList((List)gradeNumberList);
        dto.setOrgClassInfoDto(orgClassInfoDto);
        res = new WebResponse();
        res.setData((Object)dto);
        return res;
    }

    private void setAutoEnlargeSetting(OrgClassCourseDto dto) {
        int max = this.getAutoEnlargeMaxStudent(dto.getVipLevel(), dto.getPrice());
        if (max < 0) {
            return;
        }
        dto.setAddPercent(Integer.valueOf(10));
        dto.setMaxStudent(Integer.valueOf(max));
    }

    private int getAutoEnlargeMaxStudent(int vipLevel, BigDecimal price) {
        VipMaxStudentEnums vipMaxStudentEnums = VipMaxStudentEnums.parse((int)vipLevel);
        if (vipMaxStudentEnums == null) {
            return -1;
        }
        if (price.compareTo(BigDecimal.ZERO) > 0) {
            return 0;
        }
        return vipMaxStudentEnums.getFreeMaxStudent();
    }

    private boolean getIsCourseLive(int lessonWay, int classType) {
        return lessonWay == LessonWayEnums.ONLINE.getCode() && classType == OrgClassCourseEnums.CLASS.getCode();
    }

    private WebResponse<OrgClassCourseDto> checkMaxStudent(int lessonWay, boolean isCourseLive, OrgClassCourseDto dto, int currentStudent, OrgClassCourse old) {
        logger.info("[update] isCourseLive {}, OrgClassCourseDto:{}", (Object)isCourseLive, (Object)dto.toString());
        Integer studentCount = dto.getMaxStudent();
        if (studentCount == null) {
            return null;
        }
        WebResponse res = new WebResponse();
        if (old != null && old.getPlanStudent() > dto.getMaxStudent() && dto.getMaxStudent() != 0) {
            res.setCode(ResponseEnums.MAX_STUDENT_CAN_NOT_LESS_PLAN.getCode());
            res.setMsg(ResponseEnums.MAX_STUDENT_CAN_NOT_LESS_PLAN.getMsg());
            return res;
        }
        int maxStudent = 0;
        if (isCourseLive) {
            maxStudent = this.getMaxStudentForCourseLive(dto.getPrice(), dto.getVipLevel());
        } else {
            LessonWayEnums enums = LessonWayEnums.parse((int)lessonWay);
            if (enums != null) {
                maxStudent = enums.getMaxStudent();
            }
        }
        if (maxStudent == 0) {
            return null;
        }
        if (maxStudent != 0 && currentStudent > studentCount) {
            res.setCode(ResponseEnums.LESS_ENROLL_STUDENT.getCode());
            res.setMsg(String.valueOf(ResponseEnums.LESS_ENROLL_STUDENT.getMsg()) + maxStudent);
            return res;
        }
        if (maxStudent == 0 || maxStudent >= studentCount) {
            return null;
        }
        res = new WebResponse();
        if (lessonWay == LessonWayEnums.ONLINE.getCode()) {
            res.setCode(ResponseEnums.ONLINE_MAX_STUDENT.getCode());
            res.setMsg(String.valueOf(ResponseEnums.ONLINE_MAX_STUDENT.getMsg()) + maxStudent);
            return res;
        }
        if (lessonWay == LessonWayEnums.OFFLINE.getCode()) {
            res.setCode(ResponseEnums.OFFLINE_MAX_STUDENT.getCode());
            res.setMsg(String.valueOf(ResponseEnums.OFFLINE_MAX_STUDENT.getMsg()) + maxStudent);
            return res;
        }
        return null;
    }

    private int getMaxStudentForCourseLive(BigDecimal price, int vipLevel) {
        logger.info("[update] flag:{}, price:{}", (Object)price.compareTo(BigDecimal.ZERO), (Object)price);
        if (price.compareTo(BigDecimal.ZERO) > 0) {
            return 0;
        }
        VipMaxStudentEnums vipMaxStudentEnums = VipMaxStudentEnums.parse((int)vipLevel);
        if (vipMaxStudentEnums == null) {
            return 0;
        }
        return vipMaxStudentEnums.getFreeMaxStudent();
    }

    private WebResponse<OrgClassCourseDto> checkRetireFlag(int retireFlag, OrgClassCourseDto dto) {
        WebResponse res = null;
        logger.info("checkRetireFlag getAutoConfirm:{}", (Object)dto.getAutoConfirm());
        if (retireFlag == OrgClassRetireFlagenums.CAN_NOT.getCode()) {
            if (dto.getAutoConfirm() != null && dto.getAutoConfirm().booleanValue()) {
                res = new WebResponse();
                res.setCode(ResponseEnums.CAN_NOT_AUTO_CONFIRM.getCode());
                res.setMsg(ResponseEnums.CAN_NOT_AUTO_CONFIRM.getMsg());
                return res;
            }
            if (dto.getMinStudent() != null && dto.getMinStudent() != 0) {
                res = new WebResponse();
                res.setCode(ResponseEnums.CAN_NOT_AUTO_EXP.getCode());
                res.setMsg(ResponseEnums.CAN_NOT_AUTO_EXP.getMsg());
                return res;
            }
        }
        return null;
    }

    public WebResponse<OrgClassCourseDto> update(OrgClassCourseDto dto, long id, int orgId) {
        logger.info("update getAutoConfirm:{}", (Object)dto.getAutoConfirm());
        OrgClassCourse course = new OrgClassCourse();
        WebResponse<OrgClassCourseDto> res = null;
        try {
            BeanUtils.copyProperties((Object)course, (Object)dto);
        }
        catch (Exception e) {
            logger.error("update e:{}", (Throwable)e);
            res = new WebResponse();
            res.setCode(1);
            return res;
        }
        logger.info("update getAutoConfirm:{}", (Object)dto.getAutoConfirm());
        OrgClassCourse old = this.orgClassCourseCompent.selectById(id);
        OrgClassInfo info = this.orgClassInfoCompent.getById(old.getOrgClassId().longValue());
        res = this.checkRetireFlag(info.getRetireFlag(), dto);
        if (res != null) {
            return res;
        }
        int currentStudent = this.getCurrentStudent(old.getId(), old.getOrgId());
        boolean isCourseLive = this.getIsCourseLive(info.getLessonWay(), info.getClassType());
        if (dto.getPrice() == null) {
            dto.setPrice(old.getPrice());
        }
        if ((res = this.checkMaxStudent(info.getLessonWay(), isCourseLive, dto, currentStudent, old)) != null) {
            return res;
        }
        res = this.checkPlanStudent(info.getLessonWay(), isCourseLive, dto, currentStudent, old);
        if (res != null) {
            return res;
        }
        res = new WebResponse();
        if (dto.getPlanStudent() != null) {
            int max;
            if (old.getAddPercent() == 0 && (dto.getAddPercent() == null || dto.getAddPercent() == 0)) {
                course.setMaxStudent(dto.getPlanStudent());
            }
            if (isCourseLive && old.getAddPercent() > 0 && this.isFreeCourse(dto.getPrice()) && ((max = this.getAutoEnlargeMaxStudent(dto.getVipLevel(), BigDecimal.ZERO)) == 0 || old.getMaxStudent() == 0 || currentStudent > old.getMaxStudent() || old.getMaxStudent() >= max)) {
                course.setMaxStudent(Integer.valueOf(max));
            }
        }
        try {
            BeanUtils.copyProperties((Object)dto, (Object)old);
        }
        catch (Exception e) {
            logger.error("update e - ", (Throwable)e);
            res.setCode(1);
            return res;
        }
        if (AuditUtils.courseAuditCheck(course, old)) {
            course.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        }
        if (this.orgClassCourseCompent.update(course, id, orgId) == 0) {
            logger.error("updateClassCourse failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        res.setData((Object)dto);
        return res;
    }

    private int getCurrentStudent(long courseId, int orgId) {
        List gl = this.orgClassGradeCompent.getGradeByCourseId(orgId, Long.valueOf(courseId));
        int gradeCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)gl)) {
            gradeCount = gl.size() == 1 ? ((OrgClassGrade)gl.get(0)).getCount().intValue() : gl.size();
        }
        return gradeCount;
    }

    private boolean isFreeCourse(BigDecimal nowPrice) {
        return nowPrice.compareTo(BigDecimal.ZERO) == 0;
    }

    @ReadWriteTransactional
    public OrgClassCourseDto oneMore(int orgId, long courseId) {
        OrgClassCourseDto courseDto = new OrgClassCourseDto();
        OrgClassCourse course = new OrgClassCourse();
        course.setId(Long.valueOf(courseId));
        course.setOrgId(Integer.valueOf(orgId));
        course = this.orgClassCourseCompent.selectOne(course);
        if (course == null) {
            return courseDto;
        }
        OrgClassCourseDto newCourse = new OrgClassCourseDto();
        try {
            BeanUtils.copyProperties((Object)newCourse, (Object)course);
            newCourse.setId(null);
            newCourse.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
            newCourse.setReason("");
        }
        catch (Exception e) {
            logger.error("oneMore e:{}", (Throwable)e);
            return courseDto;
        }
        WebResponse<OrgClassCourseDto> res = this.insert4Id(newCourse);
        if (res.getCode() == 0) {
            courseDto = (OrgClassCourseDto)res.getData();
        }
        OrgClassInfo info = this.orgClassInfoCompent.getById(course.getOrgClassId().longValue());
        this.orgClassGradeService.copyGrade(courseId, info.getClassType(), courseDto.getId(), orgId, info.getId());
        return courseDto;
    }

    public List<Long> getByNameAndType(String name, Integer classType, int orgId) {
        List list;
        List infoIdList = null;
        if (classType != null) {
            OrgClassInfo info = new OrgClassInfo();
            info.setClassType(classType);
            info.setOrgId(Integer.valueOf(orgId));
            List list2 = this.orgClassInfoCompent.select(info);
            if (CollectionUtils.isEmpty((Collection)list2)) {
                return Collections.emptyList();
            }
            infoIdList = Lists.transform((List)list2, (Function)new Function<OrgClassInfo, Long>(){

                public Long apply(OrgClassInfo from) {
                    return from.getId();
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.orgClassCourseCompent.selectByNameAndInfo(name, infoIdList, orgId)))) {
            return Collections.emptyList();
        }
        ArrayList idList = Lists.newArrayList();
        for (OrgClassCourse course : list) {
            idList.add(course.getNumber());
        }
        return idList;
    }

    public List<OrgClassCourseDto> getByIdList(List<Long> idList, int orgId) {
        List list = this.orgClassCourseCompent.selectByIdList(idList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List infoIdList = Lists.transform((List)list, (Function)new Function<OrgClassCourse, Long>(){

            public Long apply(OrgClassCourse from) {
                return from.getOrgClassId();
            }
        });
        List infoList = this.orgClassInfoCompent.getByIdList(infoIdList, false);
        HashMap map = Maps.newHashMap();
        for (OrgClassInfo info : infoList) {
            map.put("" + info.getId(), info);
        }
        ArrayList result = Lists.newArrayList();
        for (OrgClassCourse course : list) {
            try {
                OrgClassCourseDto dto = new OrgClassCourseDto();
                BeanUtils.copyProperties((Object)dto, (Object)course);
                OrgClassInfo info = (OrgClassInfo)map.get("" + dto.getOrgClassId());
                if (info != null) {
                    OrgClassInfoDto orgClassInfoDto = new OrgClassInfoDto();
                    BeanUtils.copyProperties((Object)orgClassInfoDto, (Object)info);
                    dto.setOrgClassInfoDto(orgClassInfoDto);
                }
                result.add(dto);
            }
            catch (Exception e) {
                logger.error("getByIdList e:{}", (Throwable)e);
            }
        }
        return result;
    }

    public OrgClassCourseGradeDto searchCourseGrades(long gradeNumber, int orgId) {
        OrgClassGrade grade = new OrgClassGrade();
        grade.setNumber(Long.valueOf(gradeNumber));
        grade = this.orgClassGradeCompent.selectOne(grade, orgId);
        OrgClassCourse course = new OrgClassCourse();
        course.setId(grade.getCourseId());
        course.setOrgId(Integer.valueOf(orgId));
        course = this.orgClassCourseCompent.selectOne(course);
        OrgClassCourseGradeDto dto = new OrgClassCourseGradeDto();
        if (course == null) {
            return dto;
        }
        dto.setClassCount(course.getClassCount().intValue());
        if (PriceTypeEnums.UNIT_TIME_PRICE.getCode() == course.getPriceType().intValue()) {
            OrgGradePurchase purchase = new OrgGradePurchase();
            purchase.setGradeId(grade.getId());
            purchase = this.orgGradePurchaseCompent.selectOne(purchase, orgId);
            int classCount = 0;
            if (purchase != null) {
                classCount = purchase.getClassCount();
            }
            dto.setClassCount(classCount);
        }
        dto.setClassLength(course.getClassLength().intValue());
        dto.setCourseName(course.getName());
        if (course.getLastTime() != null) {
            dto.setLastTimeStamp(Long.valueOf(course.getLastTime().getTime()));
        }
        if (grade != null) {
            dto.setGradeStuNum(grade.getCount().intValue());
            dto.setGradeName(grade.getGradeName());
            dto.setGradeNumber(grade.getNumber().longValue());
            dto.setGradeGroupId(grade.getGroupId());
            int alreadyCount = this.orgClassScheduleCompent.getClassCount(grade.getId().longValue(), orgId);
            dto.setAlreadyCount(alreadyCount);
        }
        dto.setCourseNumber(course.getNumber().longValue());
        return dto;
    }

    public OrgClassCourseDto getByNumber(Integer orgId, Long courseNum) {
        OrgClassCourse courseParam = new OrgClassCourse();
        courseParam.setOrgId(orgId);
        courseParam.setNumber(courseNum);
        OrgClassCourse course = this.orgClassCourseCompent.selectOne(courseParam);
        OrgClassCourseDto dto = new OrgClassCourseDto();
        if (course == null) {
            return dto;
        }
        try {
            BeanUtils.copyProperties((Object)dto, (Object)course);
            return dto;
        }
        catch (Exception e) {
            logger.error("getByNumber error - ", (Throwable)e);
            return dto;
        }
    }

    public OrgClassCoursePageDto search(OrgClassCourseSearchDto dto) {
        int status = dto.getQueryStatus();
        Integer classType = dto.getClassType();
        OrgClassCourseEnums enums = OrgClassCourseEnums.parse((Integer)classType);
        if (enums == null) {
            classType = null;
        }
        Integer groupId = dto.getGroupId();
        String content = dto.getContent();
        Long number = null;
        if (StringUtils.isNumeric((CharSequence)content)) {
            number = Long.parseLong(content);
        }
        int orgId = dto.getOrgId();
        OrgClassCoursePageDto result = new OrgClassCoursePageDto();
        logger.info("search status:{},content:{},number:{}", new Object[]{status, content, number});
        int count = this.orgClassCourseCompent.selectCount(Integer.valueOf(status), content, number, Integer.valueOf(orgId), groupId, classType);
        logger.info("search count:{}", (Object)count);
        int currentCount = (dto.getPageNum() - 1) * dto.getPageSize();
        result.setCount(count);
        if (count <= 0 || currentCount >= count) {
            return result;
        }
        RowBounds rowBounds = new RowBounds(currentCount, dto.getPageSize());
        List ccgList = this.orgClassCourseCompent.selectPage(Integer.valueOf(status), content, number, orgId, groupId, classType, rowBounds);
        logger.info("search ccgList:{}", (Object)ccgList.size());
        List<OrgClassCourseListDto> dtoList = this.parse(ccgList);
        result.setDtoList(dtoList);
        return result;
    }

    private List<OrgClassCourseListDto> parse(List<OrgClassCourseGradeBiz> ccgList) {
        ArrayList dtoList = Lists.newArrayList();
        for (OrgClassCourseGradeBiz biz : ccgList) {
            OrgClassCourseListDto dto = new OrgClassCourseListDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)biz);
                dtoList.add(dto);
            }
            catch (Exception e) {
                logger.error("parse e:{}", (Throwable)e);
            }
        }
        return dtoList;
    }

    public OrgClassCourseDto searchOne(OrgClassCourseDto dto, int orgId) {
        OrgClassCourse course;
        block3: {
            course = new OrgClassCourse();
            BeanUtils.copyProperties((Object)course, (Object)dto);
            course.setOrgId(Integer.valueOf(orgId));
            course = this.orgClassCourseCompent.selectOne(course);
            if (course != null) break block3;
            return null;
        }
        try {
            BeanUtils.copyProperties((Object)dto, (Object)course);
        }
        catch (Exception e) {
            logger.error("searchOne e:{}", (Throwable)e);
        }
        ArrayList courseIdList = Lists.newArrayList();
        courseIdList.add(dto.getId());
        ArrayList dtoList = Lists.newArrayList();
        dtoList.add(dto);
        this.orgClassGradeService.handleGrade(courseIdList, dtoList);
        return dto;
    }

    public List<OrgClassCourseDto> getAll(Integer orgId) {
        List list = this.orgClassCourseCompent.select(null, orgId.intValue());
        ArrayList result = Lists.newArrayList();
        for (OrgClassCourse course : list) {
            OrgClassCourseDto dto = new OrgClassCourseDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)course);
                result.add(dto);
            }
            catch (Exception e) {
                logger.error("getAll e:{}", (Throwable)e);
            }
        }
        return result;
    }

    public boolean updateByNumber(OrgClassCourseDto dto, long number, int orgId) {
        OrgClassCourse course = new OrgClassCourse();
        try {
            BeanUtils.copyProperties((Object)course, (Object)dto);
            course.setNumber(Long.valueOf(number));
            return 1 == this.orgClassCourseCompent.update(course, orgId);
        }
        catch (Exception e) {
            logger.error("update e:{}", (Throwable)e);
            return false;
        }
    }

    public List<Long> searchByName(String value, int orgId) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        List ccgList = this.orgClassCourseCompent.selectPage(null, value, null, orgId, null, null, new RowBounds());
        if (CollectionUtils.isEmpty((Collection)ccgList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (OrgClassCourseGradeBiz biz : ccgList) {
            result.add(biz.getCourseNumber());
        }
        return result;
    }

    @ReadWriteTransactional
    public WebResponse<OrgClassCourseDto> editPlanStudent(int orgId, OrgClassCourseDto dto) {
        int max;
        WebResponse res = new WebResponse();
        OrgClassCourse course = new OrgClassCourse();
        try {
            BeanUtils.copyProperties((Object)course, (Object)dto);
        }
        catch (Exception e) {
            logger.error("editPlanStudent  courseNumber:{},e - ", (Object)dto.getNumber(), (Object)e);
            res = new WebResponse();
            res.setCode(1);
            return res;
        }
        course = this.orgClassCourseCompent.selectOne(course);
        if (course == null) {
            logger.error("editPlanStudent not exist courseNumber:{}", (Object)dto.getNumber());
            res.setCode(ResponseEnums.NO_COURSE.getCode());
            res.setMsg(ResponseEnums.NO_COURSE.getMsg());
            return res;
        }
        if (ClassStatusEnums.AUDIT.getState() == course.getStatus().intValue() && AuditStatus.REJECT.getValue() != course.getAuditStatus().intValue()) {
            res.setCode(ResponseEnums.AUDIT_CANNOT_EDIT.getCode());
            res.setMsg(ResponseEnums.AUDIT_CANNOT_EDIT.getMsg());
            return res;
        }
        OrgClassInfo orgClassInfo = new OrgClassInfo();
        orgClassInfo.setId(course.getOrgClassId());
        orgClassInfo = this.orgClassInfoCompent.selectOne(orgClassInfo);
        if (orgClassInfo == null) {
            logger.error("editPlanStudent classInfo not exist, courseNumber:{}", (Object)dto.getNumber());
            res.setCode(ResponseEnums.NO_CLASS.getCode());
            res.setMsg(ResponseEnums.NO_CLASS.getMsg());
            return res;
        }
        int currentStudent = this.getCurrentStudent(course.getId(), orgId);
        dto.setPrice(course.getPrice());
        boolean isCourseLive = this.getIsCourseLive(orgClassInfo.getLessonWay(), orgClassInfo.getClassType());
        res = this.checkPlanStudent(orgClassInfo.getLessonWay(), isCourseLive, dto, currentStudent, course);
        if (res != null) {
            return res;
        }
        if (course.getAddPercent() == 0) {
            course.setMaxStudent(dto.getPlanStudent());
        }
        course.setPlanStudent(dto.getPlanStudent());
        Long courseId = course.getId();
        OrgClassCourseM courseM = this.orgClassCourseMCompent.getById(courseId);
        if (course.getAddPercent() == 0) {
            course.setMaxStudent(dto.getPlanStudent());
            if (courseM != null) {
                courseM.setMaxStudent(dto.getPlanStudent());
            }
        }
        if (isCourseLive && course.getAddPercent() > 0 && this.isFreeCourse(dto.getPrice()) && ((max = this.getAutoEnlargeMaxStudent(dto.getVipLevel(), BigDecimal.ZERO)) == 0 || course.getMaxStudent() == 0 || currentStudent > course.getMaxStudent() || course.getMaxStudent() >= max)) {
            course.setMaxStudent(Integer.valueOf(max));
            if (courseM != null) {
                courseM.setMaxStudent(Integer.valueOf(max));
            }
        }
        int sqlRes = 0;
        if (courseM != null) {
            courseM.setPlanStudent(dto.getPlanStudent());
            sqlRes = this.orgClassCourseMCompent.updateById(courseM);
            if (sqlRes == 0) {
                logger.error("suspendErolled failed");
                throw new BussinessException(WebResponseCodeEnums.FAIL);
            }
        }
        if ((sqlRes = this.orgClassCourseCompent.update(course, orgId)) == 0) {
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        res = new WebResponse();
        res.setData((Object)dto);
        return res;
    }

    private WebResponse<OrgClassCourseDto> checkPlanStudent(int lessonWay, boolean isCourseLive, OrgClassCourseDto dto, int currentStudent, OrgClassCourse old) {
        logger.info("[updatePlanStudent] isCourseLive:{}, OrgClassCourseDto:{}", (Object)isCourseLive, (Object)dto.toString());
        Integer newPlanStudent = dto.getPlanStudent();
        if (newPlanStudent == null) {
            return null;
        }
        WebResponse res = new WebResponse();
        if (old != null && old.getAddPercent() > 0 && old.getMaxStudent() != 0 && newPlanStudent > old.getMaxStudent()) {
            res.setCode(ResponseEnums.MAX_STUDENT_CAN_NOT_LESS_PLAN.getCode());
            res.setMsg(ResponseEnums.MAX_STUDENT_CAN_NOT_LESS_PLAN.getMsg());
            return res;
        }
        int maxStudent = 0;
        if (isCourseLive) {
            maxStudent = this.getMaxStudentForCourseLive(dto.getPrice(), dto.getVipLevel());
        } else {
            LessonWayEnums lessonWayEnums = LessonWayEnums.parse((int)lessonWay);
            if (lessonWayEnums != null) {
                maxStudent = lessonWayEnums.getMaxStudent();
            }
        }
        logger.info("[update] maxStudent:{}", (Object)maxStudent);
        res = new WebResponse();
        if (maxStudent != 0 && currentStudent < newPlanStudent) {
            res.setCode(ResponseEnums.LESS_ENROLL_STUDENT.getCode());
            res.setMsg(String.valueOf(ResponseEnums.LESS_ENROLL_STUDENT.getMsg()) + currentStudent);
        }
        if (maxStudent == 0 || maxStudent >= newPlanStudent) {
            return null;
        }
        if (lessonWay == LessonWayEnums.ONLINE.getCode()) {
            res.setCode(ResponseEnums.ONLINE_MAX_STUDENT.getCode());
            res.setMsg(String.valueOf(ResponseEnums.ONLINE_MAX_STUDENT.getMsg()) + maxStudent);
        } else {
            res.setCode(ResponseEnums.OFFLINE_MAX_STUDENT.getCode());
            res.setMsg(String.valueOf(ResponseEnums.OFFLINE_MAX_STUDENT.getMsg()) + maxStudent);
        }
        return res;
    }

    @ReadWriteTransactional
    public WebResponse<Object> suspendErolled(int orgId, List<Long> numbers) {
        OrgClassCourse course2;
        WebResponse res = new WebResponse();
        res.setCode(1);
        List courses = this.orgClassCourseCompent.selectByNumbers(Integer.valueOf(orgId), numbers);
        if (courses == null || courses.isEmpty()) {
            logger.error("suspendEnrolled courses not exist");
            return res;
        }
        for (OrgClassCourse course2 : courses) {
            if (ClassStatusEnums.ENROLLING.getState() == course2.getStatus().intValue()) continue;
            res.setMsg("\u67d0\u4e9b\u8bfe\u578b\u4e0d\u5728\u62db\u751f\u72b6\u6001\uff0c\u4e0d\u80fd\u6267\u884c\u6682\u505c\u62db\u751f\u64cd\u4f5c\uff01");
            return res;
        }
        course2 = new OrgClassCourse();
        course2.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLED.getState()));
        OrgClassCourseM courseM = new OrgClassCourseM();
        courseM.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLED.getState()));
        List<Long> updateClassCourseMNumbers = this.getUpdateOrgClassCourseMNumberList(numbers, orgId);
        int sqlRes = 0;
        if (CollectionUtils.isNotEmpty(updateClassCourseMNumbers) && (sqlRes = this.orgClassCourseMCompent.updateByNumbers(Integer.valueOf(orgId), courseM, updateClassCourseMNumbers)) == 0) {
            logger.error("suspendErolled failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        sqlRes = this.orgClassCourseCompent.updateByNumbers(Integer.valueOf(orgId), course2, numbers);
        if (sqlRes == 0) {
            logger.error("suspendErolled failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        res.setCode(0);
        return res;
    }

    @ReadWriteTransactional
    public WebResponse<Object> suspendEnrolling(int orgId, List<Long> numbers) {
        OrgClassCourse course2;
        WebResponse res = new WebResponse();
        res.setCode(1);
        List courses = this.orgClassCourseCompent.selectByNumbers(Integer.valueOf(orgId), numbers);
        if (courses == null || courses.isEmpty()) {
            logger.error("suspendEnrolled courses not exist");
            return res;
        }
        logger.info("[batchDelet] course:{}, orgId:{}, numbers:{}", new Object[]{courses.size(), orgId, numbers});
        for (OrgClassCourse course2 : courses) {
            if (ClassStatusEnums.ENROLLED.getState() != course2.getStatus().intValue()) {
                res.setMsg("\u67d0\u4e9b\u8bfe\u578b\u4e0d\u5728\u6682\u505c\u62db\u751f\u72b6\u6001\uff0c\u4e0d\u80fd\u6267\u884c\u6062\u590d\u62db\u751f\u64cd\u4f5c\uff01");
                return res;
            }
            if (course2.getLastTime() == null || !course2.getLastTime().after(new Date())) continue;
            res.setMsg("\u67d0\u4e9b\u8bfe\u578b\u4fdd\u5e95\u65f6\u95f4\u8fd8\u672a\u8fc7\u65f6\uff0c\u4e0d\u80fd\u6267\u884c\u6062\u590d\u62db\u751f\u64cd\u4f5c\uff01");
            return res;
        }
        course2 = new OrgClassCourse();
        course2.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
        course2.setMinStudent(Integer.valueOf(0));
        OrgClassCourseM courseM = new OrgClassCourseM();
        courseM.setMinStudent(Integer.valueOf(0));
        courseM.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
        List<Long> updateOrgClassCourseMNumberList = this.getUpdateOrgClassCourseMNumberList(numbers, orgId);
        int sqlRes = 0;
        if (CollectionUtils.isNotEmpty(updateOrgClassCourseMNumberList) && (sqlRes = this.orgClassCourseMCompent.updateByNumbers(Integer.valueOf(orgId), courseM, numbers)) == 0) {
            logger.error("suspendEnrolling failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        sqlRes = this.orgClassCourseCompent.updateByNumbers(Integer.valueOf(orgId), course2, numbers);
        if (sqlRes == 0) {
            logger.error("suspendEnrolling failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        res.setCode(0);
        return res;
    }

    @ReadWriteTransactional
    public WebResponse<Object> deleteClassCourse(int orgId, List<Long> numbers) {
        WebResponse res = new WebResponse();
        res.setCode(1);
        int result = 0;
        List courses = this.orgClassCourseCompent.selectByNumbers(Integer.valueOf(orgId), numbers);
        if (courses == null || courses.isEmpty()) {
            logger.error("delete courses not exist");
            res.setMsg("\u5220\u9664\u7684\u8bfe\u578b\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664\uff01");
            return res;
        }
        ArrayList classIds = Lists.newArrayList();
        ArrayList courseIdList = Lists.newArrayList();
        logger.info("[batchDelet] course:{}", (Object)courses.size());
        for (OrgClassCourse course : courses) {
            if (ClassStatusEnums.AUDIT.getState() == course.getStatus().intValue() && course.getAuditStatus().intValue() != AuditStatus.REJECT.getValue()) {
                result = -1;
                res.setMsg("\u5ba1\u6838\u4e2d\u8bfe\u578b\u4e0d\u53ef\u5220\u9664\uff01");
                break;
            }
            classIds.add(course.getOrgClassId());
            courseIdList.add(course.getId());
        }
        List dels = this.orgClassCourseCompent.selectByClassIdsNoNumbers(orgId, (List)classIds, numbers);
        logger.info("[batchDelet] dels:{}", (Object)dels.size());
        HashMap delMaps = Maps.newHashMap();
        for (OrgClassCourse del : dels) {
            if (delMaps.get(del.getOrgClassId()) != null) continue;
            delMaps.put(del.getOrgClassId(), del);
        }
        for (Long classId : classIds) {
            if (delMaps.get(classId) != null) continue;
            if (-1 == result) {
                res.setMsg("\u5ba1\u6838\u4e2d\u8bfe\u7a0b\u4e0b\u6700\u6709\u4e00\u4e2a\u8bfe\u578b\u4e0d\u53ef\u5220\u9664\uff01");
                break;
            }
            result = -1;
            res.setMsg("\u8bfe\u7a0b\u4e0b\u6700\u540e\u4e00\u4e2a\u8bfe\u578b\u4e0d\u53ef\u5220\u9664\uff01");
            break;
        }
        if (result < 0) {
            return res;
        }
        OrgClassCourse course = new OrgClassCourse();
        course.setStatus(Integer.valueOf(ClassStatusEnums.DELETE.getState()));
        OrgClassCourseM courseM = new OrgClassCourseM();
        courseM.setStatus(Integer.valueOf(ClassStatusEnums.DELETE.getState()));
        List<Long> updateOrgClassCourseMNumberList = this.getUpdateOrgClassCourseMNumberList(numbers, orgId);
        int sqlRes = 0;
        if (CollectionUtils.isNotEmpty(updateOrgClassCourseMNumberList) && (sqlRes = this.orgClassCourseMCompent.updateByNumbers(Integer.valueOf(orgId), courseM, numbers)) == 0) {
            logger.error("deleteClassCourse failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        logger.info("[batchDelet] orgId:{}, numbers:{}", (Object)orgId, numbers);
        sqlRes = this.orgClassCourseCompent.updateByNumbers(Integer.valueOf(orgId), course, numbers);
        this.orgClassGradeCompent.deleteByCourseId((List)courseIdList);
        if (sqlRes == 0) {
            logger.error("deleteClassCourse failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        res.setCode(0);
        return res;
    }

    private List<Long> getUpdateOrgClassCourseMNumberList(List<Long> numbers, Integer orgId) {
        return this.orgClassCourseMCompent.getOrgClassCourseMupdateNumbers(numbers, orgId);
    }

    @ReadWriteTransactional
    public WebResponse<Object> courseOffSale(int orgId, List<Long> numbers) {
        OrgClassCourse course2;
        WebResponse res = new WebResponse();
        res.setCode(1);
        List courses = this.orgClassCourseCompent.selectByNumbers(Integer.valueOf(orgId), numbers);
        if (courses == null || courses.isEmpty()) {
            logger.error("suspendEnrolled courses not exist");
            return res;
        }
        logger.info("[batchDelet] course:{}", (Object)courses.size());
        for (OrgClassCourse course2 : courses) {
            if (ClassStatusEnums.getOffableStatusList().contains(course2.getStatus())) continue;
            res.setMsg("\u5b58\u5728\u4e0d\u53ef\u6267\u884c\u4e0b\u67b6\u64cd\u4f5c\u7684\u8bfe\u578b\uff0c\u8bf7\u68c0\u67e5\uff01");
            return res;
        }
        course2 = new OrgClassCourse();
        course2.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLED.getState()));
        OrgClassCourseM courseM = new OrgClassCourseM();
        courseM.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLED.getState()));
        this.orgClassCourseMCompent.updateByNumbers(Integer.valueOf(orgId), courseM, numbers);
        this.orgClassCourseCompent.updateByNumbers(Integer.valueOf(orgId), course2, numbers);
        res.setCode(0);
        return res;
    }

    @ReadWriteTransactional
    public WebResponse<Object> courseOnSale(int orgId, List<Long> numbers) {
        OrgClassCourse course2;
        WebResponse res = new WebResponse();
        res.setCode(1);
        List courses = this.orgClassCourseCompent.selectByNumbers(Integer.valueOf(orgId), numbers);
        if (courses == null || courses.isEmpty()) {
            logger.error("suspendEnrolled courses not exist");
            return res;
        }
        logger.info("[batchDelet] course:{}", (Object)courses.size());
        for (OrgClassCourse course2 : courses) {
            if (ClassStatusEnums.OFF_SHELVES.getState() == course2.getStatus().intValue()) continue;
            res.setMsg("\u5b58\u5728\u4e0d\u662f\u4e0b\u67b6\u72b6\u6001\u7684\u8bfe\u578b\uff0c\u4e0d\u80fd\u6267\u884c\u4e0a\u67b6\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\uff01");
            return res;
        }
        course2 = new OrgClassCourse();
        course2.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
        OrgClassCourseM courseM = new OrgClassCourseM();
        courseM.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
        this.orgClassCourseMCompent.updateByNumbers(Integer.valueOf(orgId), courseM, numbers);
        this.orgClassCourseCompent.updateByNumbers(Integer.valueOf(orgId), course2, numbers);
        res.setCode(0);
        return res;
    }

    public OrgClassCourseInfoDto getOrgClassCourseInfoDto(Long orgCourseNumber, int orgId) {
        OrgClassCourseDto dto = new OrgClassCourseDto();
        dto.setNumber(orgCourseNumber);
        dto.setOrgId(Integer.valueOf(orgId));
        dto = this.searchOne(dto, orgId);
        if (dto == null) {
            return null;
        }
        OrgClassCourseInfoDto orgClassCourseInfoDto = this.buildOrgClassCourseInfoDto(dto);
        return orgClassCourseInfoDto;
    }

    private OrgClassCourseInfoDto buildOrgClassCourseInfoDto(OrgClassCourseDto dto) {
        OrgClassCourseInfoDto orgClassCourseInfoDto = new OrgClassCourseInfoDto();
        orgClassCourseInfoDto.setClassCourseId(dto.getId());
        orgClassCourseInfoDto.setAddress(dto.getAddress() == null ? "" : dto.getAddress());
        orgClassCourseInfoDto.setCourseName(dto.getName());
        orgClassCourseInfoDto.setStartTimeStamp(Long.valueOf(dto.getStartDate().getTime()));
        orgClassCourseInfoDto.setEndTimeStamp(Long.valueOf(dto.getEndDate().getTime()));
        orgClassCourseInfoDto.setPlanStudentTotal(dto.getPlanStudent().intValue());
        return orgClassCourseInfoDto;
    }

    public OrgClassCourseListDto search(Long number, int orgId) {
        OrgClassCourseGradeBiz biz = this.orgClassCourseCompent.selectByNumber(number, orgId);
        if (biz == null) {
            return null;
        }
        OrgClassCourseListDto dto = new OrgClassCourseListDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)biz);
        }
        catch (Exception e) {
            logger.error("parse e:{}", (Throwable)e);
        }
        return dto;
    }

    public OrgClassCourseDto getByGradeNumber(Integer orgId, Long gradeNumber) {
        OrgClassGrade grade = this.orgClassGradeCompent.getGradeByNumber(orgId, gradeNumber);
        if (grade == null) {
            return null;
        }
        Long courseId = grade.getCourseId();
        OrgClassCourse select = new OrgClassCourse();
        select.setOrgId(orgId);
        select.setId(courseId);
        OrgClassCourse course = this.orgClassCourseCompent.selectOne(select);
        OrgClassCourseDto dto = new OrgClassCourseDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)course);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("getByGradeNumber e:{}", (Throwable)e);
        }
        OrgClassInfo classInfo = this.orgClassInfoCompent.getById(grade.getClassInfoId().longValue());
        OrgClassInfoDto classInfoDto = new OrgClassInfoDto();
        try {
            BeanUtils.copyProperties((Object)classInfoDto, (Object)classInfo);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("getByGradeNumber e:{}", (Throwable)e);
        }
        dto.setOrgClassInfoDto(classInfoDto);
        return dto;
    }

    public boolean isStart(long number) {
        OrgClassCourse course = new OrgClassCourse();
        course.setNumber(Long.valueOf(number));
        course = this.orgClassCourseCompent.selectOne(course);
        if (course == null) {
            return false;
        }
        return this.orgClassScheduleCompent.selectCount(course.getId().longValue(), DateUtils.getCurrent()) > 0;
    }

    public List<OrgClassCourseDto> getMinimumFailCourseDtos() {
        ArrayList courseNumberDtos = Lists.newArrayList();
        int courseTotal = this.orgClassCourseCompent.getMinimumCourseCount();
        if (courseTotal <= 0) {
            return Collections.emptyList();
        }
        int index = 0;
        while (index <= courseTotal / 500) {
            int curpage = index * 500;
            RowBounds rowBounds = new RowBounds(curpage, 500);
            List orgClassCourseList = this.orgClassCourseCompent.getMinimumOrgClassCourseList(rowBounds);
            ArrayList courseIds = Lists.newArrayList();
            for (OrgClassCourse orgClassCourse : orgClassCourseList) {
                courseIds.add(orgClassCourse.getId());
            }
            Map<Long, Integer> studentTotalMap = this.getCourseStudentTotalMap(courseIds);
            for (OrgClassCourse orgClassCourse : orgClassCourseList) {
                Long courseId = orgClassCourse.getId();
                int studentTotal = studentTotalMap.get(courseId);
                if (studentTotal >= orgClassCourse.getMinStudent()) continue;
                OrgClassCourseDto dto = new OrgClassCourseDto();
                try {
                    BeanUtils.copyProperties((Object)dto, (Object)orgClassCourse);
                    courseNumberDtos.add(dto);
                }
                catch (Exception e) {
                    logger.error("[Refund] copy error:{}", (Throwable)e);
                }
            }
            ++index;
        }
        return courseNumberDtos;
    }

    public Map<Long, Integer> getCourseStudentTotalMap(List<Long> courseIds) {
        List dtos = this.orgClassGradeCompent.getCourseStudentCountDto(courseIds);
        HashMap map = Maps.newHashMap();
        for (CourseStudentCountDto dto : dtos) {
            map.put(dto.getCourseId(), dto.getStudentTotal());
        }
        return map;
    }

    public ScheduleMinTimeDto searchMinStartTime(OrgClassCourseDto dto, Integer orgId) {
        OrgClassCourse select = new OrgClassCourse();
        select.setOrgId(orgId);
        select.setNumber(dto.getNumber());
        select = this.orgClassCourseCompent.selectOne(select);
        if (select == null) {
            return null;
        }
        ScheduleMinTimeDto result = new ScheduleMinTimeDto();
        result.setStatus(select.getStatus().intValue());
        Date time = this.orgClassScheduleCompent.searchMinStartTime(select.getId());
        result.setMinTime(time);
        return result;
    }

    @ReadWriteTransactional
    public int updateMinimumCourseSuspendErolled(List<Long> numbsers) {
        int result = 1;
        Gson g = new Gson();
        logger.info("updateMinimumCourse hasStudentCourseNumbers:{}", (Object)g.toJson(numbsers));
        result = this.updateMinimumCourseSuspendErolledByCourseNumbers(numbsers);
        return result;
    }

    private int updateMinimumCourseSuspendErolledByCourseNumbers(List<Long> courseNumbers) {
        int result = 1;
        List courses = this.orgClassCourseCompent.getNoEnrolledOrgClassCourseList(courseNumbers);
        if (courses == null || courses.isEmpty()) {
            return 0;
        }
        logger.info("courses:{}" + courses.size());
        OrgClassCourse course = new OrgClassCourse();
        course.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLED.getState()));
        course.setUpdateTime(new Date());
        int sqlRes = this.orgClassCourseCompent.updateByNumbers(course, courseNumbers);
        if (sqlRes == 0) {
            logger.error("suspendEnrolled failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        OrgClassCourseM courseM = new OrgClassCourseM();
        courseM.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLED.getState()));
        courseM.setUpdateTime(new Date());
        List<Long> updateOrgClassCourseMNumberList = this.getUpdateOrgClassCourseMNumberList(courseNumbers, null);
        if (CollectionUtils.isNotEmpty(updateOrgClassCourseMNumberList) && (sqlRes = this.orgClassCourseMCompent.updateByNumbers(courseM, updateOrgClassCourseMNumberList)) == 0) {
            logger.error("suspendEnrolled failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        result = this.batchInsertOrgMinStartClass(courses);
        return result;
    }

    private int batchInsertOrgMinStartClass(List<OrgClassCourse> courses) {
        int result = 1;
        ArrayList courseNumbers = Lists.newArrayList();
        for (OrgClassCourse orgClassCourse : courses) {
            courseNumbers.add(orgClassCourse.getNumber());
        }
        List<Long> existMinCourseNumbers = this.getExistMinCourseNumbers(courseNumbers);
        ArrayList insertList = Lists.newArrayList();
        for (OrgClassCourse orgClassCourse : courses) {
            if (existMinCourseNumbers.contains(orgClassCourse.getNumber())) continue;
            OrgMinStartClass orgMinStartClass = new OrgMinStartClass();
            orgMinStartClass.setCourseNumber(orgClassCourse.getNumber());
            orgMinStartClass.setOrgId(orgClassCourse.getOrgId());
            orgMinStartClass.setImStatus(Integer.valueOf(ImStatusEnums.NOT_SEND.getCode()));
            insertList.add(orgMinStartClass);
        }
        if (insertList.isEmpty()) {
            return 0;
        }
        int sqlRes = this.orgMinStartClassCompent.insertBatch((List)insertList);
        if (sqlRes == 0) {
            logger.error("suspendEnrolled failed");
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        result = 0;
        return result;
    }

    private List<Long> getExistMinCourseNumbers(List<Long> courseNumbers) {
        List orgMinStartClassList = this.orgMinStartClassCompent.searchList(courseNumbers, null);
        if (CollectionUtils.isEmpty((Collection)orgMinStartClassList)) {
            return Collections.emptyList();
        }
        ArrayList existMinCourseNumbers = Lists.newArrayList();
        for (OrgMinStartClass orgMinStartClass : orgMinStartClassList) {
            existMinCourseNumbers.add(orgMinStartClass.getCourseNumber());
        }
        return existMinCourseNumbers;
    }

    public List<OrgClassCourseDto> getOrgClassCourseDtoList(List<Long> numbers, int orgId) {
        List orgClassCourseList = this.orgClassCourseCompent.selectByNumbers(Integer.valueOf(orgId), numbers);
        if (CollectionUtils.isEmpty((Collection)orgClassCourseList)) {
            return Collections.emptyList();
        }
        List infoIdList = Lists.transform((List)orgClassCourseList, (Function)new Function<OrgClassCourse, Long>(){

            public Long apply(OrgClassCourse from) {
                return from.getOrgClassId();
            }
        });
        List infoList = this.orgClassInfoCompent.getByIdList(infoIdList, false);
        HashMap map = Maps.newHashMap();
        for (OrgClassInfo info : infoList) {
            map.put("" + info.getId(), info);
        }
        ArrayList orgClassCourseDtoList = Lists.newArrayList();
        ArrayList classInfoIds = Lists.newArrayList();
        for (OrgClassCourse orgClassCourse : orgClassCourseList) {
            OrgClassCourseDto dto = new OrgClassCourseDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)orgClassCourse);
                classInfoIds.add(dto.getOrgClassId());
                OrgClassInfo info = (OrgClassInfo)map.get("" + dto.getOrgClassId());
                if (info != null) {
                    OrgClassInfoDto orgClassInfoDto = new OrgClassInfoDto();
                    BeanUtils.copyProperties((Object)orgClassInfoDto, (Object)info);
                    dto.setOrgClassInfoDto(orgClassInfoDto);
                }
            }
            catch (Exception e) {
                logger.error("[Refund] copy error:{}", (Throwable)e);
            }
            orgClassCourseDtoList.add(dto);
        }
        return orgClassCourseDtoList;
    }

    @ReadWriteTransactional
    public int updateVideoValidDays(int validDays, long id, int orgId) {
        OrgClassCourse orgClassCourse = this.orgClassCourseCompent.selectById(id);
        int result = 1;
        if (orgClassCourse == null) {
            logger.warn("updateValidDays failed cause the course is not exist, courseId:{}", (Object)id);
            return 1;
        }
        orgClassCourse.setVideoValidDays(Integer.valueOf(validDays));
        orgClassCourse.setUpdateTime(new Date());
        int sqlRes = this.orgClassCourseCompent.update(orgClassCourse, orgId);
        if (sqlRes == 0) {
            logger.error("updateValidDays failed courseId:{}", (Object)id);
            throw new BussinessException(WebResponseCodeEnums.FAIL);
        }
        OrgClassCourseM orgClassCourseM = this.orgClassCourseMCompent.getById(Long.valueOf(id));
        if (orgClassCourseM != null) {
            orgClassCourseM.setVideoValidDays(Integer.valueOf(validDays));
            orgClassCourseM.setUpdateTime(new Date());
            sqlRes = this.orgClassCourseMCompent.updateById(orgClassCourseM);
            if (sqlRes == 0) {
                logger.error("updateValidDays failed courseId:{}", (Object)id);
                throw new BussinessException(WebResponseCodeEnums.FAIL);
            }
        }
        result = 0;
        return result;
    }

    public List<OrgClassCourseDto> getMinimumFailCourseDtos(Date startDate, Date endDate) {
        List orgClassCourseList = this.orgClassCourseCompent.getMinimumOrgClassCourseList(startDate, endDate);
        if (CollectionUtils.isEmpty((Collection)orgClassCourseList)) {
            return Collections.emptyList();
        }
        ArrayList courseIds = Lists.newArrayList();
        for (OrgClassCourse orgClassCourse : orgClassCourseList) {
            courseIds.add(orgClassCourse.getId());
        }
        ArrayList courseDtos = Lists.newArrayList();
        Map<Long, Integer> studentTotalMap = this.getCourseStudentTotalMap(courseIds);
        for (OrgClassCourse orgClassCourse : orgClassCourseList) {
            Long courseId = orgClassCourse.getId();
            int studentTotal = studentTotalMap.get(courseId);
            if (studentTotal >= orgClassCourse.getMinStudent()) continue;
            OrgClassCourseDto dto = new OrgClassCourseDto();
            dto.setId(orgClassCourse.getId());
            dto.setNumber(orgClassCourse.getNumber());
            dto.setLastTime(orgClassCourse.getLastTime());
            dto.setName(orgClassCourse.getName());
            dto.setOrgId(orgClassCourse.getOrgId());
            courseDtos.add(dto);
        }
        return courseDtos;
    }

    public List<OrgTeacherCourseDto> selectByTeacherUid(int orgId, int teacherUid, int size) {
        List courseBizs = this.orgClassCourseCompent.selectByTeacherUid(orgId, teacherUid, size);
        if (CollectionUtils.isEmpty((Collection)courseBizs)) {
            return Collections.emptyList();
        }
        ArrayList dtos = Lists.newArrayList();
        for (OrgTeacherCourseBiz biz : courseBizs) {
            OrgTeacherCourseDto dto = new OrgTeacherCourseDto();
            try {
                BeanUtils.copyProperties((Object)dto, (Object)biz);
                dtos.add(dto);
            }
            catch (Exception e) {
                logger.error("parse e:{}", (Throwable)e);
            }
        }
        return dtos;
    }

    public List<OrgClassCourseSaleDto> getOrgClassCourseSaleDtoList(List<Long> courseNumbers) {
        List list = this.orgClassCourseCompent.selectByNumberList(courseNumbers);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList courseIds = Lists.newArrayList();
        for (OrgClassCourse orgClassCourse : list) {
            courseIds.add(orgClassCourse.getId());
        }
        Map<Long, Integer> studentCountMap = this.getCourseStudentTotalMap(courseIds);
        ArrayList dtos = Lists.newArrayList();
        for (OrgClassCourse orgClassCourse : list) {
            OrgClassCourseSaleDto dto = new OrgClassCourseSaleDto();
            dto.setOrgId(orgClassCourse.getOrgId());
            dto.setCourseNumber(orgClassCourse.getNumber());
            dto.setName(orgClassCourse.getName());
            Integer studentCount = studentCountMap.get(orgClassCourse.getId());
            dto.setStudentCount(studentCount == null ? 0 : studentCount);
            dtos.add(dto);
        }
        return dtos;
    }
}

