/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.annotation.ReadWriteTransactional;
import com.baijia.orgclass.common.enums.AuditStatus;
import com.baijia.orgclass.common.enums.ClassStatusEnums;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassCourseMCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgClassInfoMCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleMCompent;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassCourseM;
import com.baijia.orgclass.core.model.auto.OrgClassInfo;
import com.baijia.orgclass.core.model.auto.OrgClassInfoM;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgClassScheduleM;
import com.baijia.orgclass.facade.interfaces.OrgClassCourseAuditFacade;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassCourseAuditFacadeImpl
implements OrgClassCourseAuditFacade {
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgClassCourseMCompent orgClassCourseMCompent;
    @Autowired
    private OrgClassInfoMCompent orgClassInfoMCompent;
    @Autowired
    private OrgClassScheduleMCompent orgClassScheduleMCompent;

    @ReadWriteTransactional
    public void dealWithClassCourseAudit(int courseId, int auditStatus, String refuseReason) {
        OrgClassCourse orgClassCourse = this.orgClassCourseCompent.selectById((long)courseId);
        if (orgClassCourse != null) {
            orgClassCourse.setAuditStatus(Integer.valueOf(auditStatus));
            orgClassCourse.setReason(refuseReason);
            if (auditStatus == AuditStatus.PASS.getValue()) {
                orgClassCourse.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
            } else if (auditStatus == AuditStatus.REJECT.getValue()) {
                orgClassCourse.setStatus(Integer.valueOf(ClassStatusEnums.AUDIT.getState()));
            }
            this.orgClassCourseCompent.updateById(orgClassCourse);
            if (auditStatus == AuditStatus.PASS.getValue()) {
                OrgClassCourseM orgClassCourseM = new OrgClassCourseM();
                BeanUtils.copyProperties((Object)orgClassCourse, (Object)orgClassCourseM);
                this.orgClassCourseMCompent.saveOrUpdate(orgClassCourseM);
            }
        }
    }

    @ReadWriteTransactional
    public void dealWithClassInfoAudit(int infoId, int auditStatus, String refuseReason) {
        OrgClassInfo orgClassInfo = this.orgClassInfoCompent.getById((long)infoId);
        if (orgClassInfo != null) {
            orgClassInfo.setAuditStatus(Integer.valueOf(auditStatus));
            orgClassInfo.setReason(refuseReason);
            if (auditStatus == AuditStatus.PASS.getValue()) {
                orgClassInfo.setStatus(Integer.valueOf(ClassStatusEnums.ENROLLING.getState()));
            } else if (auditStatus == AuditStatus.REJECT.getValue()) {
                orgClassInfo.setStatus(Integer.valueOf(ClassStatusEnums.AUDIT.getState()));
            }
            this.orgClassInfoCompent.updateById(orgClassInfo);
            if (auditStatus == AuditStatus.PASS.getValue()) {
                OrgClassInfoM orgClassInfoM = new OrgClassInfoM();
                BeanUtils.copyProperties((Object)orgClassInfo, (Object)orgClassInfoM);
                this.orgClassInfoMCompent.saveOrUpdate(orgClassInfoM);
            }
        }
    }

    @ReadWriteTransactional
    public void dealWithScheduleAudit(int scheduleId, int auditStatus, String refuseReason) {
        OrgClassSchedule orgClassSchedule = this.orgClassScheduleCompent.selectById((long)scheduleId);
        if (orgClassSchedule != null) {
            orgClassSchedule.setAuditStatus(Integer.valueOf(auditStatus));
            orgClassSchedule.setReason(refuseReason);
            this.orgClassScheduleCompent.updateById(orgClassSchedule);
            if (auditStatus == AuditStatus.PASS.getValue()) {
                OrgClassScheduleM orgClassScheduleM = new OrgClassScheduleM();
                BeanUtils.copyProperties((Object)orgClassSchedule, (Object)orgClassScheduleM);
                this.orgClassScheduleMCompent.saveOrUpdate(orgClassScheduleM);
            }
        }
    }
}

