/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.facade.impl;

import com.alibaba.dubbo.config.annotation.Service;
import com.baijia.orgclass.common.enums.ConfirmStatus;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.utils.ConfigProperties;
import com.baijia.orgclass.common.utils.RestUtils;
import com.baijia.orgclass.common.utils.RestfulResult;
import com.baijia.orgclass.core.compent.OrgClassConfirmCompent;
import com.baijia.orgclass.core.compent.OrgClassCourseCompent;
import com.baijia.orgclass.core.compent.OrgClassGradeCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgGradePurchaseCompent;
import com.baijia.orgclass.core.model.auto.OrgClassConfirmRecord;
import com.baijia.orgclass.core.model.auto.OrgClassCourse;
import com.baijia.orgclass.core.model.auto.OrgClassGrade;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgGradePurchase;
import com.baijia.orgclass.facade.dto.OrgClassConfirmDto;
import com.baijia.orgclass.facade.dto.OrgClassConfirmPageDto;
import com.baijia.orgclass.facade.dto.OrgClassConfirmReq;
import com.baijia.orgclass.facade.dto.OrgClassConfirmScheduleDto;
import com.baijia.orgclass.facade.dto.OrgClassConfirmSchedulePageDto;
import com.baijia.orgclass.facade.dto.OrgClassCourseDto;
import com.baijia.orgclass.facade.dto.OrgClassInfoDto;
import com.baijia.orgclass.facade.interfaces.OrgClassConfirmFacade;
import com.baijia.orgclass.facade.interfaces.OrgClassCourseFacade;
import com.baijia.orgclass.facade.interfaces.OrgClassInfoFacade;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(version="0.0.1")
public class OrgClassConfirmFacadeImpl
implements OrgClassConfirmFacade {
    private static final Logger log = LoggerFactory.getLogger(OrgClassConfirmFacadeImpl.class);
    @Autowired
    private OrgClassConfirmCompent component;
    @Autowired
    private OrgClassInfoFacade orgClassInfoFacade;
    @Autowired
    private OrgClassCourseFacade orgClassCourseFacade;
    @Autowired
    private OrgClassGradeCompent orgClassGradeCompent;
    @Autowired
    private OrgClassCourseCompent orgClassCourseCompent;
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgGradePurchaseCompent orgGradePurchaseCompent;

    public OrgClassConfirmPageDto queryConfirmPageList(OrgClassConfirmReq req, int pageNum, int pageSize) {
        OrgClassCourse course = this.getCourse(req.getCourseNumber());
        RowBounds rowBounds = new RowBounds((pageNum - 1) * pageSize, pageSize);
        List list = this.component.query(req.getCourseNumber(), req.getPurchaseId(), req.getUserIds(), req.getConfirmStatusList(), rowBounds);
        int count = this.component.queryCount(req.getCourseNumber(), req.getPurchaseId(), req.getUserIds(), req.getConfirmStatusList());
        OrgClassConfirmPageDto result = new OrgClassConfirmPageDto();
        ArrayList dtoList = Lists.newArrayList();
        for (OrgClassConfirmRecord record : list) {
            dtoList.add(this.buildDto(course, record));
        }
        result.setList((List)dtoList);
        result.setCount(count);
        return result;
    }

    public List<OrgClassConfirmDto> queryConfirmList(OrgClassConfirmReq req) {
        OrgClassCourse course = this.getCourse(req.getCourseNumber());
        List list = this.component.query(req.getCourseNumber(), req.getPurchaseId(), req.getUserIds(), req.getConfirmStatusList(), null);
        ArrayList result = Lists.newArrayList();
        for (OrgClassConfirmRecord record : list) {
            result.add(this.buildDto(course, record));
        }
        return result;
    }

    private OrgClassConfirmDto buildDto(OrgClassCourse course, OrgClassConfirmRecord record) {
        OrgClassConfirmDto dto = new OrgClassConfirmDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)record);
            this.setProperties(dto, course, record);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return dto;
    }

    private void setProperties(OrgClassConfirmDto dto, OrgClassCourse course, OrgClassConfirmRecord record) {
        dto.setCourseName(course.getName());
        dto.setConfirmStatusStr(ConfirmStatus.getDesc((Integer)((Object)record.getConfirmStatus())));
    }

    public OrgClassConfirmSchedulePageDto queryConfirmScheduleList(Integer orgId, OrgClassConfirmReq req, int pageNum, int pageSize) {
        OrgClassCourse course = this.getCourse(req.getCourseNumber());
        OrgClassInfoDto classInfo = this.getClassInfo(orgId, course.getOrgClassId());
        RowBounds rowBounds = new RowBounds((pageNum - 1) * pageSize, pageSize);
        Integer classType = 0;
        int count = 0;
        Set<Object> gradeIds = Sets.newHashSet();
        List<Object> scheduleList = Lists.newArrayList();
        if (classInfo.getClassType().intValue() == OrgClassCourseEnums.CLASS.getCode()) {
            classType = OrgClassCourseEnums.CLASS.getCode();
            scheduleList = this.queryScheduleList(orgId, course.getId(), rowBounds);
            count = this.queryScheduleListCount(orgId, course.getId());
            gradeIds = this.getGradeIdsBySchedules((List<OrgClassSchedule>)scheduleList);
        } else if (classInfo.getClassType().intValue() == OrgClassCourseEnums.OVO.getCode()) {
            classType = OrgClassCourseEnums.OVO.getCode();
            gradeIds = this.getGradeIdsByPurchaseIds(orgId, req.getPurchaseIds());
            scheduleList = this.queryScheduleList(orgId, gradeIds, rowBounds);
            count = this.queryScheduleListCount(orgId, gradeIds);
        } else {
            throw new RuntimeException("invalid class type: " + classInfo.getClassType());
        }
        Map<Long, OrgClassGrade> gradeMap = this.getGradeMap(orgId, gradeIds);
        ArrayList dtoList = Lists.newArrayList();
        for (OrgClassSchedule orgClassSchedule : scheduleList) {
            OrgClassGrade grade = gradeMap.get(orgClassSchedule.getGradeId());
            dtoList.add(this.buildDto(course, grade, orgClassSchedule, classType));
        }
        OrgClassConfirmSchedulePageDto orgClassConfirmSchedulePageDto = new OrgClassConfirmSchedulePageDto();
        orgClassConfirmSchedulePageDto.setList((List)dtoList);
        orgClassConfirmSchedulePageDto.setCount(count);
        return orgClassConfirmSchedulePageDto;
    }

    private List<OrgClassSchedule> queryScheduleList(Integer orgId, Set<Long> gradeIds, RowBounds rowBounds) {
        return this.orgClassScheduleCompent.searchByPage(orgId.intValue(), (List)Lists.newArrayList(gradeIds), rowBounds);
    }

    private int queryScheduleListCount(Integer orgId, Set<Long> gradeIds) {
        return this.orgClassScheduleCompent.searchByPageCount(orgId.intValue(), (List)Lists.newArrayList(gradeIds));
    }

    private Set<Long> getGradeIdsBySchedules(List<OrgClassSchedule> shceduleList) {
        HashSet result = Sets.newHashSet();
        for (OrgClassSchedule schedule : shceduleList) {
            result.add(schedule.getGradeId());
        }
        return result;
    }

    private Set<Long> getGradeIdsByPurchaseIds(Integer orgId, List<Long> purchaseIds) {
        HashSet result = Sets.newHashSet();
        List list = this.orgGradePurchaseCompent.queryByPurchaseIds(orgId, purchaseIds);
        for (OrgGradePurchase gradePurchase : list) {
            result.add(gradePurchase.getGradeId());
        }
        return result;
    }

    private List<OrgClassSchedule> queryScheduleList(Integer orgId, Long courseId, RowBounds rowBounds) {
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setOrgId(orgId);
        schedule.setOrgClassCourseId(courseId);
        return this.orgClassScheduleCompent.searchByPage(schedule, rowBounds);
    }

    private int queryScheduleListCount(Integer orgId, Long courseId) {
        OrgClassSchedule schedule = new OrgClassSchedule();
        schedule.setOrgId(orgId);
        schedule.setOrgClassCourseId(courseId);
        return this.orgClassScheduleCompent.searchByPageCount(schedule);
    }

    private Map<Long, OrgClassGrade> getGradeMap(Integer orgId, Collection<Long> gradeIds) {
        List list = this.orgClassGradeCompent.getGradesByIds(orgId, (List)Lists.newArrayList(gradeIds));
        HashMap result = Maps.newHashMap();
        for (OrgClassGrade grade : list) {
            result.put(grade.getId(), grade);
        }
        return result;
    }

    private OrgClassCourse getCourse(Long courseNumber) {
        OrgClassCourse course = new OrgClassCourse();
        course.setNumber(courseNumber);
        return this.orgClassCourseCompent.selectOne(course);
    }

    private OrgClassInfoDto getClassInfo(Integer orgId, Long classId) {
        return this.orgClassInfoFacade.getClassInfoById(orgId, classId);
    }

    private OrgClassConfirmScheduleDto buildDto(OrgClassCourse course, OrgClassGrade grade, OrgClassSchedule schedule, Integer classType) {
        OrgClassConfirmScheduleDto dto = new OrgClassConfirmScheduleDto();
        dto.setClassType(classType);
        dto.setCourseNumber(course.getNumber());
        dto.setCourseName(course.getName());
        dto.setCourseDate(course.getStartDate());
        dto.setGradeNumber(grade.getNumber());
        dto.setGradeName(grade.getGradeName());
        dto.setScheduleId(schedule.getId());
        dto.setScheduleName(schedule.getName());
        dto.setClassCount(schedule.getClassCount());
        dto.setStartTime(schedule.getStartTime());
        dto.setEndTime(schedule.getEndTime());
        dto.setStudentCnt(grade.getCount());
        return dto;
    }

    public Map<Long, Integer> queryClassCount(OrgClassConfirmReq req) {
        HashMap result = Maps.newHashMap();
        for (Long purchaseId : req.getPurchaseIds()) {
            Integer classCount = this.component.getSumClassCount(purchaseId, req.getConfirmStatusList());
            if (classCount == null) {
                classCount = 0;
            }
            result.put(purchaseId, classCount);
        }
        return result;
    }

    public void startConfirm(Integer orgId, OrgClassInfoDto classInfo, OrgClassCourseDto course, List<OrgClassConfirmReq> reqs) {
        this.batchSaveOrderLesson(classInfo, course, reqs);
        List<String> serialNumbers = this.getSerialNumbers(reqs);
        Map<String, BigDecimal> confirmMoneyMap = this.batchQueryConfirmMoney(serialNumbers);
        this.batchSaveConfirmRecord(reqs, confirmMoneyMap);
    }

    private List<String> getSerialNumbers(List<OrgClassConfirmReq> reqs) {
        ArrayList result = Lists.newArrayList();
        for (OrgClassConfirmReq req : reqs) {
            result.add(req.getSerialNumber());
        }
        return result;
    }

    public void startConfirm(Integer orgId, OrgClassConfirmReq req) {
        OrgClassCourseDto course = this.orgClassCourseFacade.getByNumber(orgId, req.getCourseNumber());
        OrgClassInfoDto classInfo = this.orgClassInfoFacade.getClassInfoById(orgId, course.getOrgClassId());
        this.saveOrderLesson(classInfo, course, req);
        BigDecimal confirmMoney = this.getConfirmMoney(req.getSerialNumber());
        if (confirmMoney != null) {
            req.setConfirmMoney(confirmMoney);
            this.saveConfirmRecord(req);
        }
    }

    private void saveOrderLesson(OrgClassInfoDto classInfo, OrgClassCourseDto course, OrgClassConfirmReq req) {
        try {
            String appId = ConfigProperties.getProperty((String)"rest.appId");
            String appKey = ConfigProperties.getProperty((String)"rest.appKey");
            String restUrl = ConfigProperties.getProperty((String)"rest.auth.url");
            String token = RestUtils.getAuthToken((String)restUrl, (String)appId, (String)appKey, (String)"auth", (String)"login");
            String controller = "org_course";
            String action = "createClassFire";
            HashMap params = Maps.newHashMap();
            params.put("app_id", appId);
            params.put("auth_token", token);
            params.put("serial_number", String.valueOf(req.getSerialNumber()));
            params.put("course_number", String.valueOf(course.getNumber()));
            params.put("course_type", String.valueOf(classInfo.getClassType()));
            params.put("student_user_id", String.valueOf(req.getStudentId()));
            params.put("purchase_id", String.valueOf(req.getPurchaseId()));
            params.put("length", String.valueOf(course.getClassLength() * req.getClassCount()));
            params.put("timestamp", String.valueOf(System.currentTimeMillis()));
            RestfulResult response = RestUtils.restWithAuth((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)restUrl, (String)appKey, (String)controller, (String)action, null, (Map)params, null);
            this.checkOrderLessonRes(controller, action, params, (RestfulResult<Boolean>)response);
            log.info("saveOrderLesson - purchaseId:{}, serialNumber:{}", (Object)req.getPurchaseId(), (Object)req.getSerialNumber());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void batchSaveOrderLesson(OrgClassInfoDto classInfo, OrgClassCourseDto course, List<OrgClassConfirmReq> reqs) {
        try {
            String appId = ConfigProperties.getProperty((String)"rest.appId");
            String appKey = ConfigProperties.getProperty((String)"rest.appKey");
            String restUrl = ConfigProperties.getProperty((String)"rest.auth.url");
            String token = RestUtils.getAuthToken((String)restUrl, (String)appId, (String)appKey, (String)"auth", (String)"login");
            String controller = "org_course";
            String action = "createClassFireBatch";
            HashMap params = Maps.newHashMap();
            params.put("app_id", appId);
            params.put("auth_token", token);
            params.put("timestamp", String.valueOf(System.currentTimeMillis()));
            ArrayList dataList = Lists.newArrayList();
            for (OrgClassConfirmReq req : reqs) {
                HashMap data = Maps.newHashMap();
                data.put("serial_number", String.valueOf(req.getSerialNumber()));
                data.put("course_number", String.valueOf(course.getNumber()));
                data.put("course_type", String.valueOf(classInfo.getClassType()));
                data.put("student_user_id", String.valueOf(req.getStudentId()));
                data.put("purchase_id", String.valueOf(req.getPurchaseId()));
                data.put("length", String.valueOf(course.getClassLength() * req.getClassCount()));
                dataList.add(data);
            }
            params.put("batch_data", new Gson().toJson((Object)dataList));
            log.info("batchSaveOrderLesson url:{},appKey:{},controller:{},action:{}", new Object[]{restUrl, appKey, controller, action});
            RestfulResult response = RestUtils.restWithAuth((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)restUrl, (String)appKey, (String)controller, (String)action, null, (Map)params, null);
            log.info("batchSaveOrderLesson response:{}", (Object)response);
            this.checkOrderLessonRes(controller, action, params, (RestfulResult<Boolean>)response);
            log.info("batchSaveOrderLesson - reqs.size:{}", (Object)reqs.size());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void checkOrderLessonRes(String controller, String action, Map<String, String> params, RestfulResult<Boolean> response) {
        if (response == null) {
            throw new RuntimeException("response is null, controller:" + controller + ", action:" + action + ", params:" + params);
        }
        if (response.getCode() != 0) {
            throw new RuntimeException("request failed, controller:" + controller + ", action:" + action + ", params:" + params + ", msg:" + response.getMsg());
        }
        Boolean data = (Boolean)response.getData();
        if (data == null) {
            throw new RuntimeException("data is null, controller:" + controller + ", action:" + action + ", params:" + params);
        }
    }

    private BigDecimal getConfirmMoney(String serialNumber) {
        BigDecimal confirmMoney;
        try {
            String restUrl = ConfigProperties.getProperty((String)"rest.appServiceUrl");
            String controller = "purchase";
            String action = "getSubmitMoney";
            HashMap params = Maps.newHashMap();
            params.put("order_lesson_number", serialNumber);
            RestfulResult response = RestUtils.rest((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)restUrl, (String)controller, (String)action, null, (Map)params, null);
            this.checkRes(controller, action, params, (RestfulResult<Object>)response);
            confirmMoney = BigDecimal.ZERO;
            if (!(response.getData() instanceof Map)) {
                log.error("getConfirmMoney error");
                return null;
            }
            Map data = (Map)response.getData();
            confirmMoney = new BigDecimal((String)data.get("submitMoney"));
            log.info("getConfirmMoney - serialNumber:{}, confirmMoney:{}", (Object)serialNumber, (Object)confirmMoney);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return confirmMoney;
    }

    private Map<String, BigDecimal> batchQueryConfirmMoney(List<String> serialNumbers) {
        HashMap result = Maps.newHashMap();
        int BATCH_SIZE = 100;
        HashSet batchSns = Sets.newHashSet();
        for (String sn : serialNumbers) {
            batchSns.add(sn);
            if (batchSns.size() < 100) continue;
            Map<String, BigDecimal> map = this.queryConfirmMoney(batchSns);
            result.putAll(map);
            log.info("batchIds.size:{}, batchSns.size:{}, result.size:{}", new Object[]{batchSns.size(), map.size(), result.size()});
            batchSns.clear();
        }
        if (batchSns.size() > 0) {
            Map<String, BigDecimal> map = this.queryConfirmMoney(batchSns);
            result.putAll(map);
            log.info("batchIds.size:{}, batchSns.size:{}, result.size:{}", new Object[]{batchSns.size(), map.size(), result.size()});
        }
        log.info("batchQueryConfirmMoney - confirmMoneyMap:{}", (Object)result);
        return result;
    }

    private Map<String, BigDecimal> queryConfirmMoney(Collection<String> serialNumbers) {
        try {
            String restUrl = ConfigProperties.getProperty((String)"rest.appServiceUrl");
            String controller = "purchase";
            String action = "getSubmitMoney";
            HashMap params = Maps.newHashMap();
            params.put("order_lesson_number", StringUtils.join(serialNumbers, (String)","));
            RestfulResult response = RestUtils.rest((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)restUrl, (String)controller, (String)action, null, (Map)params, null);
            this.checkRes(controller, action, params, (RestfulResult<Object>)response);
            HashMap result = Maps.newHashMap();
            if (response.getData() instanceof Map) {
                Map data = (Map)response.getData();
                for (Map.Entry entry : data.entrySet()) {
                    String serialNumber = (String)entry.getKey();
                    BigDecimal confirmMoney = new BigDecimal(entry.getValue().toString());
                    result.put(serialNumber, confirmMoney);
                }
            } else {
                log.error("queryConfirmMoney error, post the url fail restUrl:{}", (Object)restUrl);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void checkRes(String controller, String action, Map<String, String> params, RestfulResult<Object> response) {
        if (response == null) {
            throw new RuntimeException("response is null, controller:" + controller + ", action:" + action + ", params:" + params);
        }
        if (response.getCode() != 0) {
            throw new RuntimeException("request failed, controller:" + controller + ", action:" + action + ", params:" + params + ", msg:" + response.getMsg());
        }
        Object data = response.getData();
        if (data == null) {
            throw new RuntimeException("data is null, controller:" + controller + ", action:" + action + ", params:" + params);
        }
    }

    private void batchSaveConfirmRecord(List<OrgClassConfirmReq> reqs, Map<String, BigDecimal> confirmMoneyMap) {
        for (OrgClassConfirmReq req : reqs) {
            BigDecimal confirmMoney = confirmMoneyMap.get(req.getSerialNumber());
            if (confirmMoney == null) {
                confirmMoney = new BigDecimal(0);
            }
            req.setConfirmMoney(confirmMoney);
            this.saveConfirmRecord(req);
        }
    }

    public void saveConfirmRecord(OrgClassConfirmReq req) {
        OrgClassConfirmRecord record = this.buildConfirmRecord(req);
        this.component.insert(record);
        log.info("saveConfirmRecord - record:{}", (Object)record);
    }

    private OrgClassConfirmRecord buildConfirmRecord(OrgClassConfirmReq req) {
        OrgClassConfirmRecord record = new OrgClassConfirmRecord();
        record.setSerialNumber(req.getSerialNumber());
        record.setCourseNumber(req.getCourseNumber());
        record.setClassCount(req.getClassCount());
        record.setConfirmMoney(req.getConfirmMoney());
        record.setPurchaseId(req.getPurchaseId());
        record.setUserId(req.getStudentId());
        record.setOperType(req.getOperType());
        record.setConfirmStatus(Byte.valueOf(ConfirmStatus.PENDING.getValue().byteValue()));
        return record;
    }

    public int updateConfirmRecord(OrgClassConfirmReq req) {
        OrgClassConfirmRecord record = new OrgClassConfirmRecord();
        record.setConfirmMoney(req.getConfirmMoney());
        int ret = this.component.update(record, req.getSerialNumber());
        log.info("updateConfirmRecord - record:{}, ret:{}", (Object)record, (Object)ret);
        return ret;
    }

    public int confirm(OrgClassConfirmReq req) {
        OrgClassConfirmRecord record = new OrgClassConfirmRecord();
        record.setConfirmStatus(req.getConfirmStatus());
        String serialNumer = req.getSerialNumber();
        int ret = this.component.update(record, serialNumer);
        log.info("confirm - request:{}, result:{}", (Object)req, (Object)ret);
        return ret;
    }

    public int queryCount(Long courseNumber, Long purchaseId, List<Integer> userIds, List<Byte> confirmStatus) {
        return this.component.queryCount(courseNumber, purchaseId, userIds, confirmStatus);
    }
}

