/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.api.impl;

import com.baijia.orgclass.common.annotation.ReadWriteTransactional;
import com.baijia.orgclass.common.enums.LessonWayEnums;
import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import com.baijia.orgclass.common.exception.BJCloudException;
import com.baijia.orgclass.common.utils.ConfigProperties;
import com.baijia.orgclass.core.compent.OrgClassInfoCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleCompent;
import com.baijia.orgclass.core.compent.OrgClassScheduleMCompent;
import com.baijia.orgclass.core.model.auto.OrgClassSchedule;
import com.baijia.orgclass.core.model.auto.OrgClassScheduleM;
import com.baijia.orgclass.core.model.biz.RoomParamDto;
import com.baijia.orgclass.service.api.OrgClassLiveServeice;
import com.baijia.orgclass.service.utils.BaijiaYunUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgClassLiveServiceImpl
implements OrgClassLiveServeice {
    private static final Logger log = LoggerFactory.getLogger(OrgClassLiveServiceImpl.class);
    private static final String PARTNER_ID = "baijia.live.partnerId";
    private static final int DEFAULT_PAGE_SIZE = 100;
    @Autowired
    private OrgClassInfoCompent orgClassInfoCompent;
    @Autowired
    private OrgClassScheduleCompent orgClassScheduleCompent;
    @Autowired
    private OrgClassScheduleMCompent orgClassScheduleMCompent;

    @Override
    @ReadWriteTransactional
    public void syncRoomIds() {
        this.batchUpdateRoomIds(OrgClassCourseEnums.OVO.getCode());
        this.batchUpdateRoomIds(OrgClassCourseEnums.CLASS.getCode());
    }

    private void batchUpdateRoomIds(int classType) {
        List<Long> orgClassInfoIds = this.getClassInfoIds(classType);
        if (CollectionUtils.isEmpty(orgClassInfoIds)) {
            log.info("[UpdateRoomId] the class of On_line is null");
            return;
        }
        Gson g = new Gson();
        log.info("[UpdateRoomId] the class of on_line is:{}, classType:{}", (Object)orgClassInfoIds.size(), (Object)classType);
        int orgClassScheduleTotal = this.orgClassScheduleCompent.getOrgClassScheduleTotalByClassInfoIds(orgClassInfoIds);
        log.info("[UpdateRoomId] the orgClassScheduleTotal is:{}", (Object)orgClassScheduleTotal);
        if (orgClassScheduleTotal <= 0) {
            return;
        }
        int totalSchedulePageCount = orgClassScheduleTotal / 100;
        int index = 0;
        while (index <= totalSchedulePageCount) {
            RowBounds rowBounds = new RowBounds(index * 100, 100);
            List orgClassSchedulePageList = this.orgClassScheduleCompent.getOrgScheduleListWithoutRoomNo(orgClassInfoIds, rowBounds);
            if (!CollectionUtils.isEmpty((Collection)orgClassSchedulePageList)) {
                ArrayList orgClassScheduleList = Lists.newArrayList();
                ArrayList roomParamDtoList = Lists.newArrayList();
                ArrayList scheduleIds = Lists.newArrayList();
                for (OrgClassSchedule orgClassSchedule : orgClassSchedulePageList) {
                    scheduleIds.add(orgClassSchedule.getId());
                    orgClassScheduleList.add(orgClassSchedule);
                    RoomParamDto dto = RoomParamDto.buildRoomParamDtoInstance((OrgClassSchedule)orgClassSchedule, (int)classType);
                    roomParamDtoList.add(dto);
                }
                if (!CollectionUtils.isEmpty((Collection)roomParamDtoList)) {
                    List<String> batchRoomIds = null;
                    try {
                        batchRoomIds = this.batchUpdateRoomIds(roomParamDtoList, classType);
                        log.info("[UpdateRoomId] batchRommIds param:{}, orgClassScheduleList:{}", (Object)g.toJson(batchRoomIds), (Object)g.toJson((Object)orgClassScheduleList));
                    }
                    catch (BJCloudException e) {
                        log.error("[UpdateRoomId] batchRoomIds get error:{}", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.error("[UpdateRoomId] batchRoomIds get error:{}", (Throwable)e);
                    }
                    Map<Long, OrgClassScheduleM> orgClassScheduleMMap = this.getOrgClassScheduleMMap(scheduleIds);
                    ArrayList orgClassScheduleMUpdateList = Lists.newArrayList();
                    int i = 0;
                    while (i < orgClassScheduleList.size()) {
                        Long roomId = Long.parseLong(batchRoomIds.get(i));
                        OrgClassSchedule orgClassSchedule = (OrgClassSchedule)orgClassScheduleList.get(i);
                        orgClassSchedule.setRoomNo(roomId);
                        orgClassSchedule.setUpdateTime(new Date());
                        OrgClassScheduleM orgClassScheduleM = orgClassScheduleMMap.get(orgClassSchedule.getId());
                        if (orgClassScheduleM != null) {
                            orgClassScheduleM.setRoomNo(roomId);
                            orgClassScheduleM.setUpdateTime(new Date());
                            orgClassScheduleMUpdateList.add(orgClassScheduleM);
                        }
                        ++i;
                    }
                    this.orgClassScheduleCompent.batchUpdateRoomNo((List)orgClassScheduleList);
                    if (CollectionUtils.isNotEmpty((Collection)orgClassScheduleMUpdateList)) {
                        this.orgClassScheduleMCompent.batchUpdateOrgClassScheduleMList((List)orgClassScheduleMUpdateList);
                    }
                }
            }
            ++index;
        }
    }

    private Map<Long, OrgClassScheduleM> getOrgClassScheduleMMap(List<Long> scheduleIds) {
        List orgClassScheduleMList = this.orgClassScheduleMCompent.getOrgClassScheduleMList(scheduleIds);
        if (CollectionUtils.isEmpty((Collection)orgClassScheduleMList)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgClassScheduleM orgClassScheduleM : orgClassScheduleMList) {
            map.put(orgClassScheduleM.getId(), orgClassScheduleM);
        }
        return map;
    }

    private List<Long> getClassInfoIds(int classType) {
        int orgClassLiveTotal = this.orgClassInfoCompent.getOrgClassInfoTotal(Integer.valueOf(LessonWayEnums.ONLINE.getCode()), classType);
        if (orgClassLiveTotal <= 0) {
            log.info("[UpdateRoomId] the class of On_line is null");
            return Collections.emptyList();
        }
        int totalClassPageCount = orgClassLiveTotal / 100;
        ArrayList orgClassInfoIds = Lists.newArrayList();
        int index = 0;
        while (index <= totalClassPageCount) {
            List orgClassInfoPageIds = this.orgClassInfoCompent.getOrgClassInfoIds(Integer.valueOf(LessonWayEnums.ONLINE.getCode()), Integer.valueOf(classType), index * 100, 100);
            if (!CollectionUtils.isEmpty((Collection)orgClassInfoPageIds)) {
                orgClassInfoIds.addAll(orgClassInfoPageIds);
            }
            ++index;
        }
        return orgClassInfoIds;
    }

    public Long createRoomId(OrgClassSchedule orgClassSchedule, int classType) {
        OrgClassCourseEnums classTypeEnum = OrgClassCourseEnums.parse((Integer)classType);
        Long roomId = null;
        String title = orgClassSchedule.getName();
        Date startTime = orgClassSchedule.getStartTime();
        Date endTime = orgClassSchedule.getEndTime();
        int type = classTypeEnum.getRoomType();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", title);
        params.put("start_time", String.valueOf(startTime.getTime() / 1000L));
        params.put("end_time", String.valueOf(endTime.getTime() / 1000L));
        params.put("type", String.valueOf(type));
        params.put("timestamp", String.valueOf(new Date().getTime()));
        params.put("partner_id", ConfigProperties.getProperty((String)PARTNER_ID));
        String sign = BaijiaYunUtil.createSign(params);
        params.put("sign", sign);
        try {
            roomId = BaijiaYunUtil.createRoom(params);
        }
        catch (Exception e) {
            log.error("[BaijiaYun] get roomId orgClassScheduleId:{}, error param:{}", (Object)orgClassSchedule.getId(), (Object)e);
        }
        return roomId;
    }

    private List<String> batchUpdateRoomIds(List<RoomParamDto> roomParamDtoList, int classType) throws BJCloudException, Exception {
        List<Object> roomIds = Lists.newArrayList();
        HashMap params = Maps.newHashMap();
        params.put("timestamp", String.valueOf(new Date().getTime()));
        params.put("partner_id", ConfigProperties.getProperty((String)PARTNER_ID));
        Gson gson = new Gson();
        params.put("rooms", gson.toJson(roomParamDtoList));
        String sign = BaijiaYunUtil.createSign(params);
        params.put("sign", sign);
        roomIds = BaijiaYunUtil.batchGetRoomIds(params);
        return roomIds;
    }
}

