/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.msgcenter.rpc.zookeeper.discovery;

import com.baijia.msgcenter.rpc.zookeeper.discovery.HostAndZone;
import com.baijia.msgcenter.rpc.zookeeper.discovery.ZookeeperService;
import com.baijia.msgcenter.rpc.zookeeper.discovery.ZookeeperZoneAwareNameResolver;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;
import java.util.Comparator;
import javax.annotation.Nullable;

public class ZookeeperZoneAwareNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "zk";
    private final String zookeeperAddress;
    private final Comparator<HostAndZone> hostComparator;

    private ZookeeperZoneAwareNameResolverProvider(String zookeeperAddress, Comparator<HostAndZone> hostComparator) {
        this.zookeeperAddress = zookeeperAddress;
        this.hostComparator = hostComparator;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        return new ZookeeperZoneAwareNameResolver(targetUri, new ZookeeperService(this.zookeeperAddress), this.hostComparator);
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @VisibleForTesting
    static Comparator<HostAndZone> getZoneComparator(String zoneToPrefer) {
        return (o1, o2) -> {
            if (zoneToPrefer.equals(o1.getZone()) && zoneToPrefer.equals(o2.getZone())) {
                return o1.getHostURI().compareTo(o2.getHostURI());
            }
            if (zoneToPrefer.equals(o1.getZone()) && !zoneToPrefer.equals(o2.getZone())) {
                return -1;
            }
            if (!zoneToPrefer.equals(o1.getZone()) && zoneToPrefer.equals(o2.getZone())) {
                return 1;
            }
            return o1.getHostURI().compareTo(o2.getHostURI());
        };
    }

    public static class Builder {
        private String zookeeperAddress;
        private String zoneToPrefer;

        public Builder setZookeeperAddress(String zookeeperAddress) {
            this.zookeeperAddress = zookeeperAddress;
            return this;
        }

        public Builder setPreferredZone(String zoneToPrefer) {
            this.zoneToPrefer = zoneToPrefer;
            return this;
        }

        public NameResolverProvider build() {
            Comparator<HostAndZone> comparator = this.zoneToPrefer != null ? ZookeeperZoneAwareNameResolverProvider.getZoneComparator(this.zoneToPrefer) : Comparator.comparing(hostAndZone -> hostAndZone.getHostURI().getHost(), Comparator.naturalOrder());
            return new ZookeeperZoneAwareNameResolverProvider(this.zookeeperAddress, comparator);
        }
    }
}

