/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.msgcenter.rpc.zookeeper.discovery;

import com.baijia.msgcenter.rpc.zookeeper.discovery.HostAndZone;
import com.baijia.msgcenter.rpc.zookeeper.discovery.ZookeeperRuntimeException;
import com.baijia.msgcenter.rpc.zookeeper.discovery.ZookeeperService;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ZookeeperZoneAwareNameResolver
extends NameResolver {
    public final String ZONE_KEY = "ZONE";
    private final URI targetUri;
    private final ZookeeperService zookeeperService;
    private final Comparator<HostAndZone> zoneComparator;

    public ZookeeperZoneAwareNameResolver(URI targetUri, ZookeeperService zookeeperService, Comparator<HostAndZone> zoneComparator) {
        this.targetUri = targetUri;
        this.zookeeperService = zookeeperService;
        this.zoneComparator = zoneComparator;
    }

    public String getServiceAuthority() {
        return this.targetUri.getAuthority();
    }

    public void start(NameResolver.Listener listener) {
        String serviceName = this.targetUri.getAuthority();
        try {
            List<HostAndZone> initialDiscovery = this.zookeeperService.discover(serviceName);
            List<EquivalentAddressGroup> initialServers = this.toServers(initialDiscovery);
            listener.onAddresses(initialServers, Attributes.EMPTY);
        }
        catch (Exception e) {
            throw new ZookeeperRuntimeException(e);
        }
        try {
            this.zookeeperService.watchForUpdates(serviceName, updatedList -> {
                List<EquivalentAddressGroup> resolvedServers = this.toServers(updatedList);
                listener.onAddresses(resolvedServers, Attributes.EMPTY);
            });
        }
        catch (Exception e) {
            throw new ZookeeperRuntimeException(e);
        }
    }

    private List<EquivalentAddressGroup> toServers(List<HostAndZone> newList) {
        return newList.stream().sorted(this.zoneComparator).map(hostAndZone -> {
            try {
                URI hostURI = hostAndZone.getHostURI();
                InetAddress[] allByName = InetAddress.getAllByName(hostURI.getHost());
                List addresses = Arrays.stream(allByName).map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, hostURI.getPort())).collect(Collectors.toList());
                Attributes attrs = Attributes.newBuilder().set(Attributes.Key.of((String)"ZONE"), (Object)hostAndZone.getZone()).build();
                return new EquivalentAddressGroup(addresses, attrs);
            }
            catch (UnknownHostException e) {
                throw new ZookeeperRuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public void shutdown() {
        try {
            this.zookeeperService.close();
        }
        catch (IOException e) {
            throw new ZookeeperRuntimeException(e);
        }
    }
}

