/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.msgcenter.rpc.zookeeper.discovery;

import com.baijia.msgcenter.rpc.zookeeper.discovery.HostAndZone;
import com.baijia.msgcenter.rpc.zookeeper.discovery.ZookeeperRuntimeException;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperService
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperService.class);
    private static final String ZK_ROOT = "/services";
    private static final String ZK_DELIMETER = "/";
    private static final String ZONE_DELIMITER_REGEX = "\\|\\*\\*\\|";
    private static final String ZONE_DELIMITER = "|**|";
    private final CuratorFramework curatorFramework;
    private static final String UNKNOWN_ZONE = "UNKN";

    @ConstructorProperties(value={"address"})
    public ZookeeperService(String address) {
        this.curatorFramework = CuratorFrameworkFactory.newClient((String)address, (RetryPolicy)new ExponentialBackoffRetry(1000, 5));
        this.curatorFramework.start();
    }

    public void registerService(String serviceId, URI endpointURI, String zone) throws Exception {
        String znode = this.ensureNodeForServiceExists(serviceId);
        String s = (String)((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(znode + ZK_DELIMETER, (endpointURI.toASCIIString() + ZONE_DELIMITER + zone).getBytes());
        logger.info("register service ret -> {}", (Object)s);
    }

    public void registerService(String serviceId, URI endpointURI) throws Exception {
        this.registerService(serviceId, endpointURI, UNKNOWN_ZONE);
    }

    private String ensureNodeForServiceExists(String serviceId) throws Exception {
        String znode = "/services/" + serviceId;
        return this.ensureNodeExists(znode);
    }

    private String ensureNodeExists(String znode) throws Exception {
        if (this.curatorFramework.checkExists().creatingParentContainersIfNeeded().forPath(znode) == null) {
            try {
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(znode);
            }
            catch (KeeperException.NodeExistsException e) {
                logger.error("Error ensureNodeEsists:" + znode, (Throwable)e);
            }
        }
        return znode;
    }

    public List<HostAndZone> discover(String serviceId) throws Exception {
        String znode = this.ensureNodeForServiceExists(serviceId);
        return this.getUrisForServiceNode(znode);
    }

    public List<URI> discoverUnzoned(String serviceId) throws Exception {
        String znode = this.ensureNodeForServiceExists(serviceId);
        return this.getUrisForServiceNode(znode).stream().map(HostAndZone::getHostURI).collect(Collectors.toList());
    }

    private List<HostAndZone> getUrisForServiceNode(String znode) throws Exception {
        return this.getServicesForNode(znode).stream().map(storedString -> {
            logger.info("get uri -> {}", storedString);
            String[] split = storedString.split(ZONE_DELIMITER_REGEX);
            return new HostAndZone(URI.create(split[0]), split[1]);
        }).collect(Collectors.toList());
    }

    private List<String> getServicesForNode(String znode) throws Exception {
        this.ensureNodeExists(znode);
        List children = (List)this.curatorFramework.getChildren().forPath(znode);
        return children.stream().map(child -> {
            try {
                return (byte[])this.curatorFramework.getData().forPath(znode + ZK_DELIMETER + child);
            }
            catch (Exception e) {
                throw new ZookeeperRuntimeException(e);
            }
        }).map(String::new).collect(Collectors.toList());
    }

    public boolean deregister(String serviceId, URI uriToDeregister, String zone) throws Exception {
        String znode = this.ensureNodeForServiceExists(serviceId);
        List children = (List)this.curatorFramework.getChildren().forPath(znode);
        children.forEach(child -> {
            try {
                String storedUri = new String((byte[])this.curatorFramework.getData().forPath(znode + ZK_DELIMETER + child));
                if (storedUri.equals(uriToDeregister.toASCIIString() + ZONE_DELIMITER + zone)) {
                    this.curatorFramework.delete().forPath(znode + ZK_DELIMETER + child);
                }
            }
            catch (Exception e) {
                throw new ZookeeperRuntimeException(e);
            }
        });
        return true;
    }

    public boolean deregister(String serviceId, URI uriToDeregister) throws Exception {
        return this.deregister(serviceId, uriToDeregister, UNKNOWN_ZONE);
    }

    public boolean watchForUpdates(String serviceId, ServiceStateListener listener) throws Exception {
        String znode = this.ensureNodeForServiceExists(serviceId);
        return this.watchNodeForUpdates(znode, listener);
    }

    private boolean watchNodeForUpdates(String node, ServiceStateListener listener) throws Exception {
        try {
            String znode = this.ensureNodeExists(node);
            ((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher(watchedEvent -> {
                try {
                    this.watchNodeForUpdates(znode, listener);
                    listener.update(this.getUrisForServiceNode(watchedEvent.getPath()));
                }
                catch (Exception e) {
                    throw new ZookeeperRuntimeException(e);
                }
            })).forPath(znode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean removeServiceRegistry(String serviceId) throws Exception {
        String znode = this.ensureNodeForServiceExists(serviceId);
        try {
            this.curatorFramework.delete().guaranteed().deletingChildrenIfNeeded().forPath(znode);
            return true;
        }
        catch (Exception e) {
            throw new ZookeeperRuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.curatorFramework.close();
    }

    public static interface ServiceStateListener {
        public void update(List<HostAndZone> var1);
    }
}

