/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.msgcenter.rpc.server;

import com.baijia.msgcenter.rpc.annotation.GrpcService;
import com.baijia.msgcenter.rpc.server.ServerConfig;
import com.baijia.msgcenter.rpc.server.ServiceInfo;
import com.baijia.msgcenter.rpc.zookeeper.discovery.ZookeeperService;
import com.firefly.utils.StringUtils;
import com.firefly.utils.io.IO;
import com.firefly.utils.lang.Pair;
import com.google.common.collect.Lists;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyServerBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class SimpleServer
implements CommandLineRunner,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SimpleServer.class);
    private static final String DNS_FLAG = "dns://";
    @Autowired
    private ServerConfig serverConfig;
    private ZookeeperService zookeeperService;
    @Autowired
    private ApplicationContext applicationContext;
    private List<InetSocketAddress> addressList;
    private List<ServiceInfo> allService = Lists.newArrayList();
    private static List<Server> servers = Lists.newArrayList();
    private boolean destroy;

    public synchronized void destroy() {
        if (this.destroy) {
            return;
        }
        this.allService.forEach(serviceInfo -> this.addressList.forEach(address -> this.deregister(serviceInfo.getServiceId(), (InetSocketAddress)address)));
        servers.forEach(Server::shutdown);
        IO.close((Closeable)this.zookeeperService);
        this.destroy = true;
    }

    public void run(String ... strings) throws IOException, InterruptedException {
        this.init();
        this.addressList = this.parseServerConfig();
        logger.info("rpc server address -> {}", this.addressList);
        this.zookeeperService = new ZookeeperService(this.serverConfig.getZooAddress());
        ArrayList prepareRegisterServices = new ArrayList();
        for (InetSocketAddress address : this.addressList) {
            NettyServerBuilder serverBuilder = NettyServerBuilder.forAddress((SocketAddress)address);
            this.allService.stream().filter(serviceInfo -> serviceInfo.getAnnotationType() == GrpcService.class).forEach(arg_0 -> this.lambda$run$3((ServerBuilder)serverBuilder, address, prepareRegisterServices, arg_0));
            Server server = serverBuilder.build();
            server.start();
            servers.add(server);
            logger.info("success to start Server -> {}", (Object)address);
        }
        prepareRegisterServices.forEach(pair -> this.registerService((String)pair.first, (URI)pair.second));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            this.destroy();
            System.err.println("*** server shut down");
        }));
    }

    private void registerService(String serviceId, URI uri) {
        try {
            this.zookeeperService.registerService(serviceId, uri);
        }
        catch (Exception e) {
            logger.error("register service to zookeeper occurs error, {}", (Object)e.getMessage());
        }
    }

    private URI toURI(InetSocketAddress address) {
        return URI.create(DNS_FLAG + address.getAddress().getHostAddress() + ":" + address.getPort());
    }

    private void deregister(String serviceId, InetSocketAddress address) {
        try {
            this.zookeeperService.deregister(serviceId, this.toURI(address));
        }
        catch (Exception e) {
            logger.error("deregister service error, {}", (Object)e.getMessage());
        }
    }

    private List<InetSocketAddress> parseServerConfig() {
        String[] addresses = StringUtils.split((String)this.serverConfig.getServerAddress(), (char)',');
        return Arrays.stream(addresses).map(address -> {
            String[] hostAndPort = StringUtils.split((String)address, (char)':');
            if (hostAndPort[0].equals("localhost")) {
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    String host = inetAddress.getHostAddress();
                    return new InetSocketAddress(host, Integer.parseInt(hostAndPort[1]));
                }
                catch (UnknownHostException e) {
                    return new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                }
            }
            return new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
        }).collect(Collectors.toList());
    }

    private void init() {
        Collection serviceBeans = this.applicationContext.getBeansWithAnnotation(GrpcService.class).values();
        serviceBeans.forEach(springBean -> {
            Class targetClass = AopUtils.getTargetClass((Object)springBean);
            GrpcService annotation = (GrpcService)AnnotationUtils.findAnnotation((Class)targetClass, GrpcService.class);
            ServerServiceDefinition serverServiceDefinition = ((BindableService)springBean).bindService();
            this.allService.add(ServiceInfo.newBuilder().withAnnotationType(GrpcService.class).withSpringBean(springBean).withServerServiceDefinition(serverServiceDefinition).withServiceId(this.serverConfig.getEnv() + "." + annotation.value()).build());
        });
    }

    private /* synthetic */ void lambda$run$3(ServerBuilder serverBuilder, InetSocketAddress address, List prepareRegisterServices, ServiceInfo serviceInfo) {
        serverBuilder.addService(serviceInfo.getServerServiceDefinition());
        Pair pair = new Pair();
        pair.first = serviceInfo.getServiceId();
        pair.second = this.toURI(address);
        prepareRegisterServices.add(pair);
        this.deregister(serviceInfo.getServiceId(), address);
    }
}

