/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.msgcenter.rpc.client;

import com.baijia.msgcenter.rpc.zookeeper.discovery.ZookeeperZoneAwareNameResolverProvider;
import com.firefly.utils.StringUtils;
import io.grpc.Channel;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.util.RoundRobinLoadBalancerFactory;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcStubBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(GrpcStubBuilder.class);
    public static final String NEW_BLOCKING_STUB = "newBlockingStub";
    public static final String NEW_FUTURE_STUB = "newFutureStub";
    public static final String NEW_STUB = "newStub";
    private static final String ZK_PREFIX = "zk://";
    private static final String SERVICE_NAME = "SERVICE_NAME";
    private Class<?> grpcClass;
    private String zkHost;
    private String serviceId;

    public static <T> GrpcStubBuilder<T> newInstance() {
        return new GrpcStubBuilder<T>();
    }

    public GrpcStubBuilder<T> withGrpcClass(Class<?> grpcClass) {
        this.grpcClass = grpcClass;
        return this;
    }

    public GrpcStubBuilder<T> withZkHost(String zkHost) {
        this.zkHost = zkHost;
        return this;
    }

    public GrpcStubBuilder<T> withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public T build() {
        return this.build(NEW_BLOCKING_STUB);
    }

    public T build(String methodName) {
        String serviceId = this.getServiceId();
        Method newStubMethod = this.getNewStubMethod(methodName);
        logger.info("build stub, service id -> {}, method -> {}", (Object)serviceId, (Object)methodName);
        return this.createClientStub(newStubMethod, (Channel)ManagedChannelBuilder.forTarget((String)(ZK_PREFIX + serviceId)).nameResolverFactory((NameResolver.Factory)ZookeeperZoneAwareNameResolverProvider.newBuilder().setZookeeperAddress(this.zkHost).build()).usePlaintext(true).loadBalancerFactory((LoadBalancer.Factory)RoundRobinLoadBalancerFactory.getInstance()).build());
    }

    private String getServiceId() {
        if (StringUtils.hasText((String)this.serviceId)) {
            return this.serviceId;
        }
        try {
            return this.grpcClass.getDeclaredField(SERVICE_NAME).get(this.grpcClass).toString();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private Method getNewStubMethod(String methodName) {
        try {
            return this.grpcClass.getMethod(methodName, Channel.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("can't find newBlockingStub method");
        }
    }

    private T createClientStub(Method newStubMethod, Channel channel) {
        try {
            return (T)newStubMethod.invoke(this.grpcClass, channel);
        }
        catch (Exception e) {
            throw new IllegalStateException("fail to build", e);
        }
    }
}

