/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.curd.service;

import com.anji.plus.gaea.annotation.Query;
import com.anji.plus.gaea.annotation.UnionUnique;
import com.anji.plus.gaea.annotation.UnionUniqueCode;
import com.anji.plus.gaea.annotation.UnionUniques;
import com.anji.plus.gaea.annotation.Unique;
import com.anji.plus.gaea.cache.GaeaCacheService;
import com.anji.plus.gaea.constant.BaseOperationEnum;
import com.anji.plus.gaea.curd.entity.BaseEntity;
import com.anji.plus.gaea.curd.entity.GaeaBaseEntity;
import com.anji.plus.gaea.curd.mapper.GaeaBaseMapper;
import com.anji.plus.gaea.curd.params.PageParam;
import com.anji.plus.gaea.curd.service.FieldQueryDialect;
import com.anji.plus.gaea.exception.BusinessException;
import com.anji.plus.gaea.exception.BusinessExceptionBuilder;
import com.anji.plus.gaea.utils.ApplicationContextUtils;
import com.anji.plus.gaea.utils.GaeaAssert;
import com.anji.plus.gaea.utils.GaeaDateUtils;
import com.anji.plus.gaea.utils.GaeaUtils;
import com.anji.plus.gaea.utils.ReflectionUtils;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.springframework.transaction.annotation.Transactional;

public interface GaeaBaseService<P extends PageParam, T extends BaseEntity> {
    public GaeaBaseMapper<T> getMapper();

    default public GaeaCacheService getCacheService() {
        return ApplicationContextUtils.getBean(GaeaCacheService.class);
    }

    default public FieldQueryDialect getFieldQueryDialect() {
        return ApplicationContextUtils.getBean(FieldQueryDialect.class);
    }

    default public T wrapperEntity(T entity) {
        return entity;
    }

    default public T selectOne(Long id) {
        BaseEntity t = (BaseEntity)this.getMapper().selectById(id);
        return (T)this.wrapperEntity(t);
    }

    default public T selectOne(Long id, boolean checkExist) {
        BaseEntity t = (BaseEntity)this.getMapper().selectById(id);
        if (checkExist) {
            GaeaAssert.notNull(t, "500-0001", new Object[0]);
        }
        return (T)this.wrapperEntity(t);
    }

    default public T selectOne(Wrapper<T> wrapper) {
        return (T)this.wrapperEntity((BaseEntity)this.getMapper().selectOne(wrapper));
    }

    default public T selectOne(String column, Object value) {
        List<T> list = this.list(column, value);
        if (list.isEmpty()) {
            return null;
        }
        return (T)this.wrapperEntity((BaseEntity)list.get(0));
    }

    default public IPage<T> page(P pageParam) {
        return this.page(pageParam, null);
    }

    default public OrderItem build(String column, String order) {
        OrderItem item = new OrderItem();
        item.setColumn(column);
        if ("ASC".equalsIgnoreCase(order)) {
            item.setAsc(true);
        } else {
            item.setAsc(false);
        }
        return item;
    }

    default public IPage<T> page(P pageParam, Wrapper<T> wrapper) {
        Page page = new Page();
        page.setCurrent((long)((PageParam)pageParam).getPageNumber().intValue());
        page.setSize((long)((PageParam)pageParam).getPageSize().intValue());
        String sort = ((PageParam)pageParam).getSort();
        String order = ((PageParam)pageParam).getOrder();
        String[] sortSplit = new String[]{};
        String[] orderSplit = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)sort) && StringUtils.isNotBlank((CharSequence)order)) {
            if (sort.contains(",") && order.contains(",")) {
                sortSplit = sort.split(",");
                orderSplit = order.split(",");
                if (orderSplit.length == sortSplit.length) {
                    OrderItem[] orderItems = new OrderItem[orderSplit.length];
                    for (int i = 0; i < sortSplit.length; ++i) {
                        orderItems[i] = this.build(GaeaUtils.camelToUnderline(sortSplit[i]), orderSplit[i]);
                    }
                    page.addOrder(orderItems);
                } else {
                    String order0 = orderSplit[0];
                    OrderItem[] orderItems = new OrderItem[orderSplit.length];
                    for (int i = 0; i < sortSplit.length; ++i) {
                        orderItems[i] = this.build(GaeaUtils.camelToUnderline(sortSplit[i]), order0);
                    }
                    page.addOrder(orderItems);
                }
            }
            if (sort.contains(",") && !order.contains(",")) {
                List<String> orderList = Arrays.stream(sort.split(",")).map(GaeaUtils::camelToUnderline).collect(Collectors.toList());
                String[] orderColumns = orderList.toArray(new String[0]);
                if ("ASC".equalsIgnoreCase(order)) {
                    page.addOrder(OrderItem.ascs((String[])orderColumns));
                } else {
                    page.addOrder(OrderItem.descs((String[])orderColumns));
                }
            }
            if (!sort.contains(",") && !order.contains(",")) {
                page.addOrder(new OrderItem[]{this.build(GaeaUtils.camelToUnderline(sort), order)});
            }
        }
        if (wrapper != null) {
            IPage ret = this.getMapper().selectPage((IPage)page, wrapper);
            ((PageParam)pageParam).setTotal(ret.getTotal());
            return this.resultHandler(ret);
        }
        Wrapper<T> pageWrapper = this.extensionWrapper(pageParam, this.getWrapper(pageParam));
        this.handlerPageWrapper(pageWrapper);
        IPage ret = this.getMapper().selectPage((IPage)page, pageWrapper);
        ((PageParam)pageParam).setTotal(ret.getTotal());
        return this.resultHandler(ret);
    }

    default public Wrapper<T> handlerPageWrapper(Wrapper<T> pageWrapper) {
        return pageWrapper;
    }

    default public IPage<T> resultHandler(IPage<T> iPage) {
        return iPage;
    }

    default public IPage<T> resultHandler(IPage<T> iPage, P param) {
        return iPage;
    }

    default public Wrapper<T> extensionWrapper(P param, QueryWrapper<T> wrapper) {
        return wrapper;
    }

    default public void initWrapper(P param, QueryWrapper<T> queryWrapper) {
        Field[] fields = param.getClass().getDeclaredFields();
        Arrays.stream(fields).filter(field -> {
            if (field.isAnnotationPresent(Query.class)) {
                Query query = field.getAnnotation(Query.class);
                return query.where();
            }
            return true;
        }).forEach(field -> {
            block23: {
                try {
                    boolean flag;
                    field.setAccessible(true);
                    Object value = field.get(param);
                    String column = field.isAnnotationPresent(Query.class) && StringUtils.isNotBlank((CharSequence)field.getAnnotation(Query.class).column()) ? field.getAnnotation(Query.class).column() : GaeaUtils.camelToUnderline(field.getName());
                    if (value instanceof String) {
                        flag = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)value});
                    } else {
                        boolean bl = flag = value != null;
                    }
                    if (!flag) {
                        return;
                    }
                    if (field.isAnnotationPresent(Query.class)) {
                        switch (field.getAnnotation(Query.class).value()) {
                            case LIKE: {
                                String likeValue = String.valueOf(value);
                                if (likeValue.contains("%")) {
                                    likeValue = likeValue.replace("%", "\\%");
                                }
                                if (likeValue.contains("_")) {
                                    likeValue = likeValue.replace("_", "\\_");
                                }
                                queryWrapper.like((Object)column, (Object)likeValue);
                                break;
                            }
                            case MATCH: {
                                this.getFieldQueryDialect().match(queryWrapper, param, column, value);
                                break;
                            }
                            case IN: {
                                if (value instanceof List) {
                                    queryWrapper.in((Object)column, (Collection)((List)value));
                                    break;
                                }
                                if (value instanceof String) {
                                    String[] split = ((String)value).split(",");
                                    List<String> list = Arrays.asList(split);
                                    queryWrapper.in((Object)column, list);
                                    break;
                                }
                                break block23;
                            }
                            case GT: {
                                queryWrapper.gt((Object)column, value);
                                break;
                            }
                            case GE: {
                                queryWrapper.ge((Object)column, value);
                                break;
                            }
                            case LT: {
                                queryWrapper.lt((Object)column, value);
                                break;
                            }
                            case LE: {
                                queryWrapper.le((Object)column, value);
                                break;
                            }
                            case BWT: {
                                String[] split = value.toString().split(",");
                                if (split.length == 2) {
                                    if (GaeaDateUtils.checkTimeFormat(split[0])) {
                                        // empty if block
                                    }
                                    queryWrapper.between((Object)column, (Object)GaeaDateUtils.sourceTimeZoneToTargetTimeZone(split[0]), (Object)GaeaDateUtils.sourceTimeZoneToTargetTimeZone(split[1]));
                                    break;
                                }
                                if (split.length == 1) {
                                    queryWrapper.ge((Object)column, (Object)GaeaDateUtils.sourceTimeZoneToTargetTimeZone(split[0]));
                                    break;
                                }
                                break block23;
                            }
                            default: {
                                queryWrapper.eq((Object)column, value);
                                break;
                            }
                        }
                        break block23;
                    }
                    queryWrapper.eq((Object)column, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    default public QueryWrapper<T> getWrapper(P param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.initWrapper(param, queryWrapper);
        return queryWrapper;
    }

    default public void processBeforeOperation(T entity, BaseOperationEnum opr) throws BusinessException {
    }

    default public void processAfterOperation(T entity, BaseOperationEnum opr) throws BusinessException {
    }

    default public String getColumn(SFunction<T, ?> function) {
        LambdaMeta lambda = LambdaUtils.extract(function);
        String fieldName = PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
        Class implClass = lambda.getInstantiatedClass();
        try {
            Field field = implClass.getDeclaredField(fieldName);
            if (field.isAnnotationPresent(TableField.class)) {
                fieldName = field.getAnnotation(TableField.class).value();
                return fieldName;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return GaeaUtils.camelToUnderline(fieldName);
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer insert(T entity) throws BusinessException {
        this.processBeforeOperation(entity, BaseOperationEnum.INSERT);
        this.checkUniqueField(entity, false);
        Integer result = this.getMapper().insert(entity);
        if (result == null || result < 1) {
            throw BusinessExceptionBuilder.build("Insert.failure");
        }
        this.refreshCacheFields(entity, BaseOperationEnum.INSERT);
        this.processAfterOperation(entity, BaseOperationEnum.INSERT);
        return result;
    }

    default public void refreshCacheFields(T entity, BaseOperationEnum opr) {
        this.getCacheService().refreshCacheFields(entity, opr);
    }

    default public void refreshCacheFieldsBatch(List<T> entities, BaseOperationEnum opr) {
        this.getCacheService().refreshCacheFieldsBatch(entities, opr);
    }

    default public String formatKey(String key, String[] replaceArray, T entity) {
        return GaeaUtils.formatKey(key, replaceArray, entity);
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer insertBatch(List<T> entities) throws BusinessException {
        Integer result = this.getMapper().insertBatch(entities);
        if (result == null || result < 1) {
            throw BusinessExceptionBuilder.build("Insert.failure");
        }
        this.getCacheService().refreshCacheFieldsBatch(entities, BaseOperationEnum.INSERT);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer update(T entity) throws BusinessException {
        Integer result;
        this.processBeforeOperation(entity, BaseOperationEnum.UPDATE);
        this.checkUniqueField(entity, true);
        if (entity instanceof GaeaBaseEntity) {
            GaeaBaseEntity gaeaBaseEntity = (GaeaBaseEntity)entity;
            T dbEntity = this.getById(gaeaBaseEntity.getId());
            this.refreshCacheFields(dbEntity, BaseOperationEnum.DELETE);
        }
        if ((result = Integer.valueOf(this.getMapper().updateById(entity))) == null || result < 1) {
            throw BusinessExceptionBuilder.build("Update.failure");
        }
        this.refreshCacheFields(entity, BaseOperationEnum.UPDATE);
        this.processAfterOperation(entity, BaseOperationEnum.UPDATE);
        return result;
    }

    default public Integer updateFieldsById(Map<String, Object> map, Long id) {
        map.computeIfAbsent("update_time", key -> new Date());
        return this.getMapper().updateFieldsById(map, id);
    }

    default public Integer updateBatchFieldsById(Map<String, Object> map, List<Long> ids) {
        map.computeIfAbsent("update_time", key -> new Date());
        return this.getMapper().updateFieldsBatchById(map, ids);
    }

    default public Integer updateBatchFields(Map<String, Object> map, List<T> list) {
        map.computeIfAbsent("update_time", key -> new Date());
        return this.getMapper().updateFieldsBatch(map, list);
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer deleteById(Serializable id) {
        T t = this.getById(id);
        if (t == null) {
            throw BusinessExceptionBuilder.build("500-0001");
        }
        this.processBeforeOperation(t, BaseOperationEnum.DELETE);
        Integer result = this.getMapper().deleteById(id);
        if (result == null || result < 1) {
            throw BusinessExceptionBuilder.build("Delete.failure");
        }
        this.refreshCacheFields(t, BaseOperationEnum.DELETE);
        this.processAfterOperation(t, BaseOperationEnum.DELETE);
        return result;
    }

    default public void processBatchBeforeOperation(List<T> entities, BaseOperationEnum opr) throws BusinessException {
    }

    default public void processBatchAfterOperation(List<T> entities, BaseOperationEnum opr) throws BusinessException {
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean deleteByIds(Collection<? extends Serializable> idList) {
        List list = this.getMapper().selectBatchIds(idList);
        this.processBatchBeforeOperation(list, BaseOperationEnum.DELETE_BATCH);
        boolean result = SqlHelper.retBool((Integer)this.getMapper().deleteBatchIds(idList));
        if (result) {
            this.getCacheService().refreshCacheFieldsBatch(list, BaseOperationEnum.DELETE_BATCH);
            this.processBatchAfterOperation(list, BaseOperationEnum.DELETE_BATCH);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public void delete(LambdaQueryWrapper<T> lambdaQueryWrapper) {
        List list = this.getMapper().selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.deleteByIds(list.stream().map(d -> d instanceof GaeaBaseEntity ? ((GaeaBaseEntity)d).getId() : 0L).collect(Collectors.toList()));
    }

    /*
     * WARNING - void declaration
     */
    default public void checkUniqueField(T entity, boolean isUpdate) {
        Field[] allFields = ReflectionUtils.getAllFieldsArr(entity);
        Optional<Field> idFiledOptional = Arrays.stream(allFields).filter(field -> field.isAnnotationPresent(TableId.class)).findFirst();
        if (!idFiledOptional.isPresent()) {
            return;
        }
        Field idField = idFiledOptional.get();
        idField.setAccessible(true);
        for (Field field2 : allFields) {
            Long integer;
            if (!field2.isAnnotationPresent(Unique.class)) continue;
            Unique unique = field2.getDeclaredAnnotation(Unique.class);
            QueryWrapper wrapper = Wrappers.query();
            try {
                void var14_23;
                Object value = this.getFieldValue(entity, field2);
                if (StringUtils.isBlank((CharSequence)unique.column())) {
                    String string = GaeaUtils.camelToUnderline(field2.getName());
                } else {
                    String string = unique.column();
                }
                wrapper.eq((Object)var14_23, value);
                if (isUpdate) {
                    wrapper.ne((Object)idField.getAnnotation(TableId.class).value(), idField.get(entity));
                }
                integer = this.getMapper().selectCount((Wrapper)wrapper);
            }
            catch (Exception e) {
                continue;
            }
            if (integer <= 0L) continue;
            throw BusinessExceptionBuilder.build(unique.code(), field2.getName());
        }
        HashMap<String, QueryWrapper> unionUniqueMap = new HashMap<String, QueryWrapper>();
        for (Field field3 : allFields) {
            ArrayList unionUniques = null;
            Object value = null;
            if (field3.isAnnotationPresent(UnionUnique.class)) {
                if (unionUniques == null) {
                    unionUniques = new ArrayList();
                }
                try {
                    value = this.getFieldValue(entity, field3);
                    UnionUnique[] ret = (UnionUnique[])field3.getDeclaredAnnotationsByType(UnionUnique.class);
                    unionUniques.addAll(Arrays.stream(ret).collect(Collectors.toList()));
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (field3.isAnnotationPresent(UnionUniques.class)) {
                if (unionUniques == null) {
                    unionUniques = new ArrayList();
                }
                try {
                    UnionUniques[] ret1;
                    value = this.getFieldValue(entity, field3);
                    for (UnionUniques gs : ret1 = (UnionUniques[])field3.getDeclaredAnnotationsByType(UnionUniques.class)) {
                        unionUniques.addAll(Arrays.stream(gs.value()).collect(Collectors.toList()));
                    }
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (!CollectionUtils.isNotEmpty(unionUniques)) continue;
            for (UnionUnique unionUnique : unionUniques) {
                QueryWrapper unionWrapper;
                String group = unionUnique.group();
                String column = StringUtils.isBlank((CharSequence)unionUnique.column()) ? GaeaUtils.camelToUnderline(field3.getName()) : unionUnique.column();
                if (unionUniqueMap.containsKey(group)) {
                    unionWrapper = (QueryWrapper)unionUniqueMap.get(group);
                    unionWrapper.eq((Object)column, value);
                    continue;
                }
                unionWrapper = Wrappers.query();
                unionWrapper.eq((Object)column, value);
                unionUniqueMap.put(group, unionWrapper);
            }
        }
        Set entries = unionUniqueMap.entrySet();
        for (Map.Entry entry : entries) {
            UnionUniqueCode[] unionUniqueCodes;
            long result;
            QueryWrapper queryWrapper = (QueryWrapper)entry.getValue();
            if (isUpdate) {
                try {
                    queryWrapper.ne((Object)idField.getAnnotation(TableId.class).value(), idField.get(entity));
                }
                catch (Exception e) {
                    return;
                }
            }
            if ((result = this.getMapper().selectCount((Wrapper)queryWrapper).longValue()) <= 0L) continue;
            String group = (String)entry.getKey();
            Class<?> clazz = entity.getClass();
            for (UnionUniqueCode unionUniqueCode : unionUniqueCodes = (UnionUniqueCode[])clazz.getAnnotationsByType(UnionUniqueCode.class)) {
                if (!StringUtils.equals((CharSequence)unionUniqueCode.group(), (CharSequence)group)) continue;
                throw BusinessExceptionBuilder.build(unionUniqueCode.code());
            }
        }
    }

    default public Object getFieldValue(T entity, Field field) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), entity.getClass());
        Method readMethod = propertyDescriptor.getReadMethod();
        return readMethod.invoke(entity, new Object[0]);
    }

    default public List<T> list(String column, Object value) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)column, value);
        return this.getMapper().selectList((Wrapper)queryWrapper);
    }

    default public Long count(Wrapper<T> wrapper) {
        return this.getMapper().selectCount(wrapper);
    }

    default public List<T> list(Wrapper<T> wrapper) {
        return this.getMapper().selectList(wrapper);
    }

    default public T getById(Serializable id) {
        return (T)((BaseEntity)this.getMapper().selectById(id));
    }

    default public List<T> findAll() {
        return this.getMapper().selectList((Wrapper)Wrappers.emptyWrapper());
    }

    default public Integer updateColumn(Long id, String column, Object value) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put(column, value);
        params.put("update_time", new Date());
        return this.getMapper().updateFieldsById(params, id);
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer updateFieldsBatch(Map<String, Object> map, List<T> list) {
        map.computeIfAbsent("update_time", key -> new Date());
        return this.getMapper().updateFieldsBatch(map, list);
    }
}

