/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.cache;

import com.anji.plus.gaea.cache.CacheHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.CollectionUtils;

public class RedisCacheHelper
implements CacheHelper {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public String stringGet(String key) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return "";
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        return (String)operations.get();
    }

    @Override
    public Map<String, String> stringMultiGet(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        List ret = this.stringRedisTemplate.opsForValue().multiGet(keys);
        if (!CollectionUtils.isEmpty((Collection)ret)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < keys.size(); ++i) {
                if (Objects.isNull(ret.get(i))) continue;
                map.put(keys.get(i), (String)ret.get(i));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public Boolean setIfAbsent(String key, String value) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        return operations.setIfAbsent((Object)value);
    }

    @Override
    public Long increment(String key) {
        String regKey = this.regKey(key);
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        return operations.increment();
    }

    @Override
    public void expire(String key, TimeUnit timeUnit, Long timeout) {
        String regKey = this.regKey(key);
        this.stringRedisTemplate.expire((Object)regKey, timeout.longValue(), timeUnit);
    }

    @Override
    public Long increment(String key, Long step) {
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)this.regKey(key));
        return operations.increment(step.longValue());
    }

    @Override
    public boolean exist(String key) {
        return this.stringRedisTemplate.hasKey((Object)this.regKey(key));
    }

    @Override
    public Set<String> keys(String pattern) {
        ScanOptions options = ScanOptions.scanOptions().count(1000L).match(pattern).build();
        RedisSerializer redisSerializer = this.stringRedisTemplate.getKeySerializer();
        HashSet<String> result = new HashSet<String>();
        try (Cursor cursor = (Cursor)this.stringRedisTemplate.executeWithStickyConnection(redisConnection -> new ConvertingCursor(redisConnection.scan(options), arg_0 -> ((RedisSerializer)redisSerializer).deserialize(arg_0)));){
            while (cursor.hasNext()) {
                result.add(cursor.next().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void stringSet(String key, String value) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        operations.set((Object)value);
    }

    @Override
    public void stringSetExpire(String key, String value, long time, TimeUnit timeUnit) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        operations.set((Object)value, time, timeUnit);
    }

    @Override
    public void stringSetExpire(String key, String value, long seconds) {
        this.stringSetExpire(this.regKey(key), value, seconds, TimeUnit.SECONDS);
    }

    @Override
    public Map<String, String> hashGet(String key) {
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)this.regKey(key));
        return operations.entries();
    }

    @Override
    public List<String> hashMultiGet(String key, Collection<String> keys, boolean includeDisabled) {
        if (Objects.isNull(key) || CollectionUtils.isEmpty(keys)) {
            return Arrays.asList("");
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)this.regKey(key));
        List itemKeys = keys.stream().map(t -> this.regKey((String)t)).collect(Collectors.toList());
        List list = operations.multiGet(itemKeys);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, Optional.ofNullable(list.get(i)).orElse(""));
        }
        if (includeDisabled) {
            ArrayList nullItemKeys;
            HashMap nullKeys = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)list.get(i)))) continue;
                nullKeys.put(i, itemKeys.get(i));
            }
            if (nullKeys.isEmpty()) {
                return list;
            }
            BoundHashOperations d = this.stringRedisTemplate.boundHashOps((Object)this.regKey(key).concat(this.getDisabledKey()));
            List disabledVals = d.multiGet(nullItemKeys = new ArrayList(nullKeys.values()));
            if (!CollectionUtils.isEmpty((Collection)disabledVals)) {
                HashMap dis = new HashMap();
                for (int i = 0; i < disabledVals.size(); ++i) {
                    dis.put(nullItemKeys.get(i), Optional.ofNullable(disabledVals.get(i)).orElse(""));
                }
                for (Map.Entry src : nullKeys.entrySet()) {
                    list.set((Integer)src.getKey(), dis.get(src.getValue()));
                }
            }
        }
        return list;
    }

    @Override
    public String hashGetString(String key, String hashKey) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return "";
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey)) {
            return "";
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        if (hashKey.contains(",")) {
            String[] split = hashKey.split(",");
            String reduce = Arrays.stream(split).reduce("", (all, item) -> {
                all = StringUtils.isBlank((CharSequence)all) ? (String)operations.get(item) : all + "," + (String)operations.get(item);
                return all;
            });
            return reduce;
        }
        return (String)operations.entries().get(regHashKey);
    }

    @Override
    public void hashDel(String key, String hashKey) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        operations.delete(new Object[]{regHashKey});
    }

    @Override
    public void hashBatchDel(String key, Set<String> hashKeys, boolean toDisable) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey) || CollectionUtils.isEmpty(hashKeys)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        if (toDisable) {
            BoundHashOperations disableOpt = this.stringRedisTemplate.boundHashOps((Object)regKey.concat(this.getDisabledKey()));
            List keys = hashKeys.stream().collect(Collectors.toList());
            List dels = operations.multiGet(hashKeys);
            for (int i = 0; i < keys.size(); ++i) {
                disableOpt.put(keys.get(i), (Object)Optional.ofNullable(dels.get(i)).orElse(""));
            }
        }
        operations.delete((Object[])hashKeys.toArray(new String[0]));
    }

    @Override
    public boolean hashExist(String key, String hashKey) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey)) {
            return false;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        return operations.hasKey((Object)regHashKey);
    }

    @Override
    public boolean hashAnyExist(String key, String[] hashKeys) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        for (String hashKey : hashKeys) {
            if (!operations.hasKey((Object)this.regKey(hashKey)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void hashSet(String key, String hashKey, String hashValue) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey) || StringUtils.isBlank((CharSequence)hashKey)) {
            return;
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey) || StringUtils.isBlank((CharSequence)hashValue)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        operations.put((Object)regHashKey, (Object)hashValue);
    }

    @Override
    public void hashSet(String key, Map<String, String> hash) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        if (CollectionUtils.isEmpty(hash)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        operations.putAll(hash);
    }

    @Override
    public void hashMultiSet(Map<String, String> map) {
        if (Objects.isNull(map) || map.isEmpty()) {
            return;
        }
        this.stringRedisTemplate.opsForValue().multiSet(map);
    }

    @Override
    public boolean delete(String key) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        return this.stringRedisTemplate.delete((Object)regKey);
    }

    @Override
    public boolean delete(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return false;
        }
        Long count = this.stringRedisTemplate.delete((Collection)keys.stream().map(t -> this.regKey((String)t)).collect(Collectors.toList()));
        return count > 0L;
    }

    @Override
    public Long setAdd(String key, String[] values) {
        return this.setAdd(this.regKey(key), values, false);
    }

    @Override
    public Long setAdd(String key, String[] values, boolean clear) {
        String regKey = this.regKey(key);
        if (clear) {
            this.stringRedisTemplate.delete((Object)regKey);
        }
        if (values != null && values.length == 0) {
            return 0L;
        }
        BoundSetOperations setOperations = this.stringRedisTemplate.boundSetOps((Object)regKey);
        return setOperations.add((Object[])values);
    }

    @Override
    public Set<String> setMembers(String key) {
        BoundSetOperations setOperations = this.stringRedisTemplate.boundSetOps((Object)this.regKey(key));
        return setOperations.members();
    }

    @Override
    public Boolean setExist(String key, String value) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        BoundSetOperations setOperations = this.stringRedisTemplate.boundSetOps((Object)regKey);
        return setOperations.isMember((Object)value);
    }
}

