/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.Channel;
import com.android.repository.api.Dependency;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Repository;
import com.android.repository.api.RepositorySource;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RepoPackageImpl;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class RemotePackageImpl
extends RepoPackageImpl
implements RemotePackage {
    @XmlTransient
    private RepositorySource mSource;

    @Override
    public void setSource(RepositorySource source) {
        this.mSource = source;
    }

    @Override
    public Archive getArchive() {
        for (Archive archive : this.getArchives().getArchive()) {
            if (!archive.isCompatible()) continue;
            return archive;
        }
        return null;
    }

    @VisibleForTesting
    public List<Archive> getAllArchives() {
        return this.getArchives().getArchive();
    }

    protected abstract RepoPackageImpl.Archives getArchives();

    protected abstract void setArchives(RepoPackageImpl.Archives var1);

    @Override
    @XmlTransient
    public RepositorySource getSource() {
        assert (this.mSource != null) : "Tried to get source before it was initialized!";
        return this.mSource;
    }

    protected abstract ChannelRef getChannelRef();

    @Override
    public Channel getChannel() {
        return this.getChannelRef() == null ? Channel.DEFAULT : this.getChannelRef().getRef();
    }

    @Override
    public File getInstallDir(RepoManager manager, ProgressIndicator progress) {
        assert (manager.getLocalPath() != null);
        String path = this.getPath().replace(';', File.separatorChar);
        return new File(manager.getLocalPath(), path);
    }

    public void setChannel(Channel c) {
        ChannelRef cr = null;
        if (c != null) {
            cr = this.createFactory().createChannelRefType();
            cr.setRef(c);
        }
        this.setChannelRef(cr);
    }

    public abstract void setChannelRef(ChannelRef var1);

    public static RemotePackageImpl create(RemotePackage p) {
        CommonFactory f = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
        RemotePackageImpl result = f.createRemotePackage();
        result.setVersion(p.getVersion());
        result.setLicense(p.getLicense());
        result.setPath(p.getPath());
        for (Dependency d : p.getAllDependencies()) {
            result.addDependency(d);
        }
        result.setObsolete(p.obsolete());
        result.setTypeDetails(p.getTypeDetails());
        result.setDisplayName(p.getDisplayName());
        result.setSource(p.getSource());
        result.setChannel(p.getChannel());
        Archive archive = p.getArchive();
        if (archive != null) {
            result.addArchive(archive);
        }
        return result;
    }

    public void addArchive(Archive archive) {
        RepoPackageImpl.Archives archives = this.getArchives();
        if (archives == null) {
            archives = this.createFactory().createArchivesType();
            this.setArchives(archives);
        }
        archives.getArchive().add(archive);
    }

    @Override
    public RepoPackageImpl asMarshallable() {
        return this;
    }

    @Override
    public void addTo(Repository repo) {
        repo.getRemotePackage().add(this);
    }

    @XmlTransient
    public static abstract class ChannelRef {
        public abstract Channel getRef();

        public abstract void setRef(Channel var1);
    }
}

