/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.dm.simple;

import com.aliyuncs.dm.simple.Email;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailSender {
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int SHUTDOWN_WAIT_SECONDS = 5;
    private static final String EMAIL_ENCODING = "utf-8";
    private static final String X_SMTP_TRANS_PARAM = "X-SMTP-TRANS-PARAM";
    private Session session;

    public MailSender(String host, String port, final String userName, final String password) {
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.auth", "true");
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        };
        this.session = Session.getInstance((Properties)props, (Authenticator)authenticator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> batchSendMail(List<Email> emailList) {
        ArrayList<String> rtnList = new ArrayList<String>();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        CountDownLatch countDownLatch = new CountDownLatch(emailList.size());
        ArrayList<Future> resultList = new ArrayList<Future>();
        for (int i = 0; i < emailList.size(); ++i) {
            Future f = executor.submit(new SendTask(countDownLatch, emailList.get(i)));
            resultList.add(f);
        }
        try {
            countDownLatch.await();
            for (Future f : resultList) {
                rtnList.add((String)f.get());
            }
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            if (!executor.isTerminated()) {
                System.err.println("cancel non-finished tasks");
            }
            executor.shutdownNow();
            System.out.println("shutdown finished");
        }
        return rtnList;
    }

    public String sendMail(Email email) {
        try {
            MimeMessage mimeMessage = this.getMimeMessage(email);
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return "success";
    }

    private MimeMessage getMimeMessage(Email email) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = new MimeMessage(this.session);
        this.setFrom(email, message);
        this.setTo(email, message);
        this.setCc(email, message);
        this.setReplyto(email, message);
        this.setSubject(email, message);
        this.setContent(email, message);
        this.setHeader(email, (Message)message);
        return message;
    }

    private void setFrom(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        InternetAddress from = null;
        from = new InternetAddress(email.getFrom().getEmail(), email.getFrom().getName(), EMAIL_ENCODING);
        message.setFrom((Address)from);
    }

    private void setTo(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        InternetAddress[] toArr = new InternetAddress[email.getRecipients().size()];
        for (int i = 0; i < email.getRecipients().size(); ++i) {
            toArr[i] = new InternetAddress(email.getRecipients().get(i).getEmail(), email.getRecipients().get(i).getName(), EMAIL_ENCODING);
        }
        message.setRecipients(MimeMessage.RecipientType.TO, (Address[])toArr);
    }

    private void setCc(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        if (email.getCc() == null) {
            return;
        }
        InternetAddress[] ccArr = new InternetAddress[email.getCc().size()];
        for (int i = 0; i < email.getCc().size(); ++i) {
            ccArr[i] = new InternetAddress(email.getCc().get(i).getEmail(), email.getCc().get(i).getName(), EMAIL_ENCODING);
        }
        if (ccArr != null && ccArr.length > 0) {
            message.setRecipients(MimeMessage.RecipientType.CC, (Address[])ccArr);
        }
    }

    private void setSubject(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        message.setSubject(email.getSubject());
        if (email.getHeaders() != null && email.getHeaders().size() > 0) {
            for (Map.Entry<String, String> e : email.getHeaders().entrySet()) {
                message.setHeader(e.getKey(), e.getValue());
            }
        }
    }

    private void setReplyto(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        Address[] a = new Address[]{new InternetAddress(email.getReplyToAddress().getEmail(), email.getReplyToAddress().getName() == null ? "" : email.getReplyToAddress().getName())};
        message.setReplyTo(a);
    }

    private void setContent(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        if (email.getText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getText(), EMAIL_ENCODING);
            multipart.addBodyPart((BodyPart)messagePart);
        }
        if (email.getTextHTML() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getTextHTML(), "text/html; charset=\"utf-8\"");
            multipart.addBodyPart((BodyPart)messagePartHTML);
        }
        if (email.getAttachments() != null && email.getAttachments().size() > 0) {
            for (Email.Attachment ea : email.getAttachments()) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                DataSource source = ea.getDataSource();
                messageBodyPart.setDataHandler(new DataHandler(source));
                messageBodyPart.setFileName(ea.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
        message.setContent((Multipart)multipart);
    }

    private void setHeader(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        if (email.getTemplateContent() != null && email.getTemplateContent().length() > 0) {
            email.getHeaders().put(X_SMTP_TRANS_PARAM, email.getTemplateContent());
        }
        for (Map.Entry<String, String> header : email.getHeaders().entrySet()) {
            String name = header.getKey();
            String value = MimeUtility.encodeText((String)header.getValue(), (String)EMAIL_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(name.length() + 2), (String)value);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
    }

    class SendTask
    implements Callable<String> {
        CountDownLatch latch;
        Email email;

        SendTask(CountDownLatch countDownLatch, Email email) {
            this.latch = countDownLatch;
            this.email = email;
        }

        @Override
        public String call() throws Exception {
            String result = MailSender.this.sendMail(this.email);
            this.latch.countDown();
            return result;
        }
    }
}

