/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.dm.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;

public class Email {
    private final Address replyToAddress;
    private final Address from;
    private final String text;
    private final String textHTML;
    private final String subject;
    private final List<Address> recipients;
    private final List<Attachment> attachments;
    private final Map<String, String> headers;
    private final String templateId;
    private final String templateContent;
    private final List<Address> cc;

    public String getTemplateContent() {
        return this.templateContent;
    }

    public Address getReplyToAddress() {
        return this.replyToAddress;
    }

    public Address getFrom() {
        return this.from;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Address> getRecipients() {
        return this.recipients;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public List<Address> getCc() {
        return this.cc;
    }

    private Email(Address replyToAddress, Address from, String text, String textHTML, String subject, List<Address> recipients, List<Attachment> attachments, Map<String, String> headers, String templateId, String templateContent, List<Address> cc) {
        this.replyToAddress = replyToAddress;
        this.from = from;
        this.text = text;
        this.textHTML = textHTML;
        this.subject = subject;
        this.recipients = recipients;
        this.cc = cc;
        this.attachments = attachments;
        this.headers = headers;
        this.templateId = templateId;
        this.templateContent = templateContent;
    }

    public static From builder() {
        return new EmailBuilder();
    }

    public static interface From {
        public Recipients from(String ... var1);
    }

    public static interface Recipients {
        public EmailBuilder recipients(List<Address> var1);

        public EmailBuilder to(String var1);

        public EmailBuilder to(List<String> var1);
    }

    public static interface Build {
        public EmailBuilder replyToAddress(Address var1);

        public EmailBuilder subject(String var1);

        public EmailBuilder text(String var1);

        public EmailBuilder textHTML(String var1);

        public EmailBuilder attachments(List<Attachment> var1);

        public EmailBuilder headers(Map<String, String> var1);

        public EmailBuilder templateId(String var1);

        public EmailBuilder templateContent(String var1);

        public EmailBuilder cc(List<Address> var1);

        public Email build();
    }

    public static class EmailBuilder
    implements From,
    Recipients,
    Build {
        private Address replyToAddress;
        private Address from;
        private String text;
        private String textHTML;
        private String subject;
        private List<Address> recipients;
        private List<Attachment> attachments;
        private Map<String, String> headers = new HashMap<String, String>();
        private String templateId;
        private String templateContent;
        private List<Address> cc;

        private EmailBuilder() {
        }

        @Override
        public EmailBuilder replyToAddress(Address replyToAddress) {
            this.replyToAddress = replyToAddress;
            return this;
        }

        @Override
        public Recipients from(String ... str) {
            Address a = null;
            if (str.length == 1) {
                a = new Address(str[0], "");
            } else if (str.length == 2) {
                a = new Address(str[0], str[1]);
            }
            this.from = a;
            return this;
        }

        @Override
        public EmailBuilder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public EmailBuilder textHTML(String textHTML) {
            this.textHTML = textHTML;
            return this;
        }

        @Override
        public EmailBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public EmailBuilder recipients(List<Address> recipients) {
            this.recipients = recipients;
            return this;
        }

        @Override
        public EmailBuilder to(String to) {
            String[] strArr;
            ArrayList<Address> addressList = new ArrayList<Address>();
            for (String s : strArr = to.split(",")) {
                addressList.add(new Address(s));
            }
            this.recipients = addressList;
            return this;
        }

        @Override
        public EmailBuilder to(List<String> toList) {
            ArrayList<Address> addressList = new ArrayList<Address>();
            for (String s : toList) {
                addressList.add(new Address(s));
            }
            this.recipients = addressList;
            return this;
        }

        @Override
        public EmailBuilder attachments(List<Attachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        @Override
        public EmailBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public EmailBuilder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @Override
        public EmailBuilder templateContent(String templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        @Override
        public EmailBuilder cc(List<Address> cc) {
            this.cc = cc;
            return this;
        }

        @Override
        public Email build() {
            return new Email(this.replyToAddress, this.from, this.text, this.textHTML, this.subject, this.recipients, this.attachments, this.headers, this.templateId, this.templateContent, this.cc);
        }
    }

    public static class Attachment {
        private final String name;
        private final DataSource dataSource;

        public String getName() {
            return this.name;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public Attachment(String name, DataSource dataSource) {
            this.name = name;
            this.dataSource = dataSource;
        }
    }

    public static class Address {
        private String email;
        private String name;

        public Address(String email, String name) {
            this.email = email;
            this.name = name;
        }

        public Address(String email) {
            this.email = email;
            this.name = "";
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

