/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.reporter.digest;

import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.reporter.facade.AbstractReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import java.util.Map;

public abstract class AbstractDiskReporter
extends AbstractReporter {
    @Override
    public String getReporterType() {
        return this.getDigestReporterType();
    }

    @Override
    public void doReport(SofaTracerSpan span) {
        span.setLogType(this.getDigestReporterType());
        if (!this.isDisableDigestLog(span)) {
            this.digestReport(span);
        }
        this.statisticReport(span);
    }

    public abstract String getDigestReporterType();

    public abstract String getStatReporterType();

    public abstract void digestReport(SofaTracerSpan var1);

    public abstract void statisticReport(SofaTracerSpan var1);

    protected boolean isDisableDigestLog(SofaTracerSpan span) {
        if (span == null || span.context() == null) {
            return true;
        }
        SofaTracerSpanContext sofaTracerSpanContext = (SofaTracerSpanContext)span.context();
        if (sofaTracerSpanContext.isSampled()) {
            return false;
        }
        boolean allDisabled = Boolean.TRUE.toString().equalsIgnoreCase(SofaTracerConfiguration.getProperty("disable_middleware_digest_log"));
        if (allDisabled) {
            return true;
        }
        Map<String, String> disableConfiguration = SofaTracerConfiguration.getMapEmptyIfNull("disable_digest_log");
        String logType = "" + span.getLogType();
        if (StringUtils.isBlank(logType)) {
            return true;
        }
        if ("rpc-2-jvm-digest.log".equals(logType) && Boolean.FALSE.toString().equalsIgnoreCase(SofaTracerConfiguration.getProperty("enable_rpc_2_jvm_digest_log"))) {
            return true;
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(disableConfiguration.get(logType));
    }
}

