/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.registry;

import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.registry.RegistryExtractorInjector;
import com.alipay.common.tracer.core.utils.StringUtils;
import io.opentracing.propagation.TextMap;
import java.util.Map;

public abstract class AbstractTextFormatter
implements RegistryExtractorInjector<TextMap> {
    @Override
    public SofaTracerSpanContext extract(TextMap carrier) {
        if (carrier == null) {
            return SofaTracerSpanContext.rootStart();
        }
        SofaTracerSpanContext sofaTracerSpanContext = null;
        for (Map.Entry entry : carrier) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtils.isBlank(key) || !"sftc_head".equalsIgnoreCase(key) || StringUtils.isBlank(value)) continue;
            sofaTracerSpanContext = SofaTracerSpanContext.deserializeFromString(this.decodedValue(value));
        }
        if (sofaTracerSpanContext == null) {
            return SofaTracerSpanContext.rootStart();
        }
        return sofaTracerSpanContext;
    }

    @Override
    public void inject(SofaTracerSpanContext spanContext, TextMap carrier) {
        if (carrier == null || spanContext == null) {
            return;
        }
        carrier.put("sftc_head", this.encodedValue(spanContext.serializeSpanContext()));
    }

    protected abstract String encodedValue(String var1);

    protected abstract String decodedValue(String var1);
}

