/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.configuration;

import com.alipay.common.tracer.core.appender.info.StaticInfoLog;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerExternalConfiguration;
import com.alipay.common.tracer.core.utils.StringUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SofaTracerConfiguration {
    public static final String DISABLE_MIDDLEWARE_DIGEST_LOG_KEY = "disable_middleware_digest_log";
    public static final String DISABLE_DIGEST_LOG_KEY = "disable_digest_log";
    public static final String TRACER_GLOBAL_ROLLING_KEY = "tracer_global_rolling_policy";
    public static final String TRACER_GLOBAL_LOG_RESERVE_DAY = "tracer_global_log_reserve_day";
    public static final int DEFAULT_LOG_RESERVE_DAY = 7;
    public static final int PEN_ATTRS_LENGTH_TRESHOLD = 1024;
    public static final String TRACER_PENETRATE_ATTRIBUTE_MAX_LENGTH = "tracer_penetrate_attribute_max_length";
    public static final String TRACER_SYSTEM_PENETRATE_ATTRIBUTE_MAX_LENGTH = "tracer_system_penetrate_attribute_max_length";
    public static final String STAT_LOG_INTERVAL = "stat_log_interval";
    public static final String TRACER_ASYNC_APPENDER_ALLOW_DISCARD = "tracer_async_appender_allow_discard";
    public static final String TRACER_ASYNC_APPENDER_IS_OUT_DISCARD_NUMBER = "tracer_async_appender_is_out_discard_number";
    public static final String TRACER_ASYNC_APPENDER_IS_OUT_DISCARD_ID = "tracer_async_appender_is_out_discard_id";
    public static final String TRACER_ASYNC_APPENDER_DISCARD_OUT_THRESHOLD = "tracer_async_appender_discard_out_threshold";
    public static final String TRACER_APPNAME_KEY = "spring.application.name";
    private static Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private static Properties fileProperties = new Properties();
    private static SofaTracerExternalConfiguration sofaTracerExternalConfiguration = null;

    public static void setProperty(String key, String value) {
        properties.put(key, value);
    }

    public static void setProperty(String key, Integer value) {
        properties.put(key, value);
    }

    public static void setProperty(String key, Map<String, String> value) {
        properties.put(key, value);
    }

    public static String getProperty(String key) {
        return SofaTracerConfiguration.getProperty(key, "");
    }

    public static Integer getInteger(String key) {
        if (properties.containsKey(key)) {
            return (Integer)properties.get(key);
        }
        if (System.getProperties().containsKey(key)) {
            return Integer.valueOf(System.getProperty(key));
        }
        if (fileProperties.containsKey(key)) {
            return Integer.valueOf(fileProperties.getProperty(key));
        }
        return null;
    }

    public static Integer getIntegerDefaultIfNull(String key, Integer defaultValue) {
        Integer value = SofaTracerConfiguration.getInteger(key);
        return value == null ? defaultValue : value;
    }

    public static Map<String, String> getMapEmptyIfNull(String key) {
        if (properties.containsKey(key)) {
            Object result = properties.get(key);
            if (result instanceof Map) {
                return (HashMap)properties.get(key);
            }
            SelfLog.error("the value for " + key + " is not the type of map");
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    public static String getProperty(String key, String defaultValue) {
        if (properties.containsKey(key)) {
            return (String)properties.get(key);
        }
        if (System.getProperties().containsKey(key)) {
            return System.getProperty(key);
        }
        if (fileProperties.containsKey(key)) {
            return (String)fileProperties.get(key);
        }
        if (sofaTracerExternalConfiguration != null && sofaTracerExternalConfiguration.contains(key)) {
            return sofaTracerExternalConfiguration.getValue(key);
        }
        return defaultValue;
    }

    public static String getRollingPolicy(String rollingKey) {
        if (StringUtils.isBlank(rollingKey)) {
            return "";
        }
        String rollingPolicy = SofaTracerConfiguration.getProperty(rollingKey);
        if (StringUtils.isBlank(rollingPolicy)) {
            rollingPolicy = SofaTracerConfiguration.getProperty(TRACER_GLOBAL_ROLLING_KEY);
        }
        return StringUtils.isBlank(rollingPolicy) ? "'.'yyyy-MM-dd" : rollingPolicy;
    }

    public static String getLogReserveConfig(String logReserveKey) {
        if (StringUtils.isBlank(logReserveKey)) {
            return "";
        }
        String reserveDay = SofaTracerConfiguration.getProperty(logReserveKey);
        if (StringUtils.isNotBlank(reserveDay)) {
            return reserveDay;
        }
        return String.valueOf(SofaTracerConfiguration.getProperty(TRACER_GLOBAL_LOG_RESERVE_DAY, String.valueOf(7)));
    }

    public static void setSofaTracerExternalConfiguration(SofaTracerExternalConfiguration sofaTracerExternalConfiguration) {
        SofaTracerConfiguration.sofaTracerExternalConfiguration = sofaTracerExternalConfiguration;
    }

    static {
        InputStream inputStream = null;
        try {
            inputStream = SofaTracerConfiguration.class.getClassLoader().getResourceAsStream("sofa.tracer.properties");
            if (inputStream != null) {
                fileProperties.load(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            SelfLog.info("sofa.tracer.properties\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        StaticInfoLog.logStaticInfo();
    }
}

