/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.boot.constant.SofaBootConstants;
import com.alipay.sofa.boot.util.BeanDefinitionUtil;
import com.alipay.sofa.runtime.spring.share.SofaPostProcessorShareManager;
import com.alipay.sofa.runtime.spring.share.UnshareSofaPostProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Order
@UnshareSofaPostProcessor
public class SofaShareBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware,
ApplicationContextAware {
    private final String[] whiteNameList = new String[]{ConfigurationClassPostProcessor.class.getName() + ".importAwareProcessor", ConfigurationClassPostProcessor.class.getName() + ".importRegistry", ConfigurationClassPostProcessor.class.getName() + ".enhancedConfigurationProcessor"};
    private SofaPostProcessorShareManager sofaPostProcessorShareManager;
    private Boolean isShareParentContextPostProcessors;

    public SofaShareBeanFactoryPostProcessor() {
    }

    @Deprecated
    public SofaShareBeanFactoryPostProcessor(SofaPostProcessorShareManager shareManager) {
        this.sofaPostProcessorShareManager = shareManager;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashMap<String, BeanDefinition> postProcessorDefinitions = new HashMap<String, BeanDefinition>();
        beanFactory.registerSingleton(SofaBootConstants.PROCESSORS_OF_ROOT_APPLICATION_CONTEXT, postProcessorDefinitions);
        if (this.isShareParentContextPostProcessors.booleanValue()) {
            postProcessorDefinitions.putAll(this.getBeanDefinitionsForType(beanFactory, BeanPostProcessor.class));
            postProcessorDefinitions.putAll(this.getBeanDefinitionsForType(beanFactory, BeanFactoryPostProcessor.class));
        }
    }

    private Map<String, BeanDefinition> getBeanDefinitionsForType(ConfigurableListableBeanFactory beanFactory, Class type) {
        String[] beanNamesForType;
        HashMap<String, BeanDefinition> map = new HashMap<String, BeanDefinition>();
        HashSet<String> allBeanDefinitionNames = new HashSet<String>(Arrays.asList(beanFactory.getBeanDefinitionNames()));
        for (String beanName : beanNamesForType = beanFactory.getBeanNamesForType(type, true, false)) {
            BeanDefinition beanDefinition;
            Class cls;
            if (!this.notInWhiteNameList(beanName) || !allBeanDefinitionNames.contains(beanName) || this.sofaPostProcessorShareManager.unableToShare(cls = BeanDefinitionUtil.resolveBeanClassType((BeanDefinition)(beanDefinition = beanFactory.getBeanDefinition(beanName)))) || this.sofaPostProcessorShareManager.unableToShare(beanName)) continue;
            map.put(beanName, beanFactory.getBeanDefinition(beanName));
        }
        return map;
    }

    private boolean notInWhiteNameList(String beanName) {
        for (String whiteName : this.whiteNameList) {
            if (!whiteName.equals(beanName)) continue;
            return false;
        }
        return true;
    }

    public void setEnvironment(Environment environment) {
        this.isShareParentContextPostProcessors = (Boolean)environment.getProperty("com.alipay.sofa.boot.share.parent.context.post.processor.enabled", Boolean.class, (Object)true);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.sofaPostProcessorShareManager = (SofaPostProcessorShareManager)applicationContext.getBean("sofaModulePostProcessorShareManager", SofaPostProcessorShareManager.class);
    }
}

