/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.SofaRuntimeUtils;
import com.alipay.sofa.runtime.api.aware.ClientFactoryAware;
import com.alipay.sofa.runtime.api.aware.ExtensionClientAware;
import com.alipay.sofa.runtime.ext.client.ExtensionClientImpl;
import com.alipay.sofa.runtime.filter.JvmFilter;
import com.alipay.sofa.runtime.filter.JvmFilterHolder;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.spring.RuntimeShutdownAware;
import com.alipay.sofa.runtime.spi.spring.SofaRuntimeContextAware;
import com.alipay.sofa.runtime.spring.singleton.SingletonSofaPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;

@SingletonSofaPostProcessor
public class SofaRuntimeAwareProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private final SofaRuntimeManager sofaRuntimeManager;
    private final SofaRuntimeContext sofaRuntimeContext;
    private final ClientFactoryInternal clientFactory;
    private final ExtensionClientImpl extensionClient;

    public SofaRuntimeAwareProcessor(SofaRuntimeManager sofaRuntimeManager) {
        this.sofaRuntimeManager = sofaRuntimeManager;
        this.sofaRuntimeContext = sofaRuntimeManager.getSofaRuntimeContext();
        this.clientFactory = sofaRuntimeManager.getClientFactoryInternal();
        this.extensionClient = new ExtensionClientImpl(this.sofaRuntimeContext);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SofaRuntimeContextAware) {
            ((SofaRuntimeContextAware)bean).setSofaRuntimeContext(this.sofaRuntimeContext);
        }
        if (bean instanceof ClientFactoryAware) {
            ((ClientFactoryAware)bean).setClientFactory(this.clientFactory);
        }
        if (bean instanceof ExtensionClientAware) {
            ((ExtensionClientAware)bean).setExtensionClient(this.extensionClient);
        }
        if ((!SofaRuntimeUtils.isArkEnvironment() || SofaRuntimeUtils.onMasterBiz()) && bean instanceof JvmFilter) {
            JvmFilterHolder.addJvmFilter((JvmFilter)bean);
        }
        if (bean instanceof RuntimeShutdownAware) {
            this.sofaRuntimeManager.registerShutdownAware((RuntimeShutdownAware)bean);
        }
        return bean;
    }
}

