/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.component;

import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.AbstractComponent;
import com.alipay.sofa.runtime.spi.component.Implementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ServiceComponent
extends AbstractComponent {
    public static final String UNREGISTER_DELAY_MILLISECONDS = "UNREGISTER_DELAY_MILLISECONDS";
    public static final ComponentType SERVICE_COMPONENT_TYPE = new ComponentType("service");
    private Service service;
    private BindingAdapterFactory bindingAdapterFactory;

    public ServiceComponent(Implementation implementation, Service service, BindingAdapterFactory bindingAdapterFactory, SofaRuntimeContext sofaRuntimeContext) {
        this.componentName = ComponentNameFactory.createComponentName(SERVICE_COMPONENT_TYPE, service.getInterfaceType(), service.getUniqueId());
        this.implementation = implementation;
        this.service = service;
        this.bindingAdapterFactory = bindingAdapterFactory;
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    @Override
    public ComponentType getType() {
        return SERVICE_COMPONENT_TYPE;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean resolve() {
        this.resolveBinding();
        return super.resolve();
    }

    @Override
    public void register() {
        Class<?> interfaceType;
        Object target = this.service.getTarget();
        if (SofaRuntimeProperties.isServiceInterfaceTypeCheck() && !(interfaceType = this.service.getInterfaceType()).isAssignableFrom(target.getClass())) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00104", (Object[])new Object[]{this.service, target.getClass(), interfaceType}));
        }
        super.register();
    }

    private void resolveBinding() {
        Object target = this.service.getTarget();
        if (target == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00000"));
        }
        if (this.service.hasBinding()) {
            Set bindings = this.service.getBindings();
            boolean allPassed = true;
            for (Binding binding : bindings) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00001", (Object[])new Object[]{binding.getBindingType(), this.service}));
                }
                SofaLogger.info(" <<PreOut Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)this.service);
                try {
                    bindingAdapter.preOutBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    SofaLogger.error(ErrorCode.convert((String)"01-00002", (Object[])new Object[]{binding.getBindingType(), this.service}), t);
                    continue;
                }
                SofaLogger.info(" <<PreOut Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00003", (Object[])new Object[]{this.service}));
            }
        }
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        this.activateBinding();
        super.activate();
    }

    private void activateBinding() {
        Object target = this.service.getTarget();
        if (target == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00000"));
        }
        if (this.service.hasBinding()) {
            boolean allPassed = true;
            Set bindings = this.service.getBindings();
            for (Binding binding : bindings) {
                Object outBindingResult;
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00001", (Object[])new Object[]{binding.getBindingType(), this.service}));
                }
                SofaLogger.info(" <<Out Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)this.service);
                try {
                    outBindingResult = bindingAdapter.outBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    binding.setHealthy(false);
                    SofaLogger.error(ErrorCode.convert((String)"01-00004", (Object[])new Object[]{binding.getBindingType(), this.service}), t);
                    continue;
                }
                if (!Boolean.FALSE.equals(outBindingResult)) {
                    SofaLogger.info(" <<Out Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)this.service);
                    continue;
                }
                binding.setHealthy(false);
                SofaLogger.info(" <<Out Binding [{}] Fails, Don't publish service - {}.", (Object)binding.getBindingType(), (Object)this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00005", (Object[])new Object[]{this.service}));
            }
        }
        SofaLogger.info("Register Service - {}", (Object)this.service);
    }

    @Override
    public void deactivate() throws ServiceRuntimeException {
        Object target = this.service.getTarget();
        if (target == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00000"));
        }
        if (this.service.hasBinding()) {
            boolean allPassed = true;
            Set bindings = this.service.getBindings();
            for (Binding binding : bindings) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00001", (Object[])new Object[]{binding.getBindingType(), this.service}));
                }
                SofaLogger.info(" <<Pre un-out Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)this.service);
                try {
                    bindingAdapter.preUnoutBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    SofaLogger.error(ErrorCode.convert((String)"01-00006", (Object[])new Object[]{binding.getBindingType(), this.service}), t);
                    continue;
                }
                SofaLogger.info(" <<Pre un-out Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00007", (Object[])new Object[]{this.service}));
            }
        }
        super.deactivate();
    }

    @Override
    public void unregister() throws ServiceRuntimeException {
        Object target;
        super.unregister();
        Property unregisterDelayMillisecondsProperty = (Property)this.properties.get(UNREGISTER_DELAY_MILLISECONDS);
        if (unregisterDelayMillisecondsProperty != null) {
            int unregisterDelayMilliseconds = unregisterDelayMillisecondsProperty.getInteger();
            try {
                TimeUnit.MILLISECONDS.sleep(unregisterDelayMilliseconds);
            }
            catch (InterruptedException e) {
                throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00010", (Object[])new Object[]{this.service}), e);
            }
        }
        if ((target = this.service.getTarget()) == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00000"));
        }
        if (this.service.hasBinding()) {
            boolean allPassed = true;
            Set bindings = this.service.getBindings();
            for (Binding binding : bindings) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00001", (Object[])new Object[]{binding.getBindingType(), this.service}));
                }
                SofaLogger.info(" <<Post un-out Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)this.service);
                try {
                    bindingAdapter.postUnoutBinding(this.service, binding, target, this.getContext());
                }
                catch (Throwable t) {
                    allPassed = false;
                    SofaLogger.error(ErrorCode.convert((String)"01-00008", (Object[])new Object[]{binding.getBindingType(), this.service}), t);
                    continue;
                }
                SofaLogger.info(" <<Post un-out Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)this.service);
            }
            if (!allPassed) {
                throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00009", (Object[])new Object[]{this.service}));
            }
        }
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder(super.dump());
        Set bindings = this.service.getBindings();
        for (Binding binding : bindings) {
            sb.append("\n|------>[binding]-").append(binding.dump());
        }
        return sb.toString();
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public HealthResult isHealthy() {
        HealthResult healthResult = new HealthResult(this.componentName.getRawName());
        healthResult.setHealthy(this.e == null);
        String report = this.aggregateBindingHealth(this.service.getBindings());
        if (this.e != null) {
            report = report + " [" + this.e.getMessage() + "]";
        }
        healthResult.setHealthReport(report);
        return healthResult;
    }
}

