/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.component;

import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.invoke.DynamicJvmServiceProxyFinder;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.Reference;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.AbstractComponent;
import com.alipay.sofa.runtime.spi.component.ComponentDefinitionInfo;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.component.Implementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.springframework.util.StringUtils;

public class ReferenceComponent
extends AbstractComponent {
    public static final ComponentType REFERENCE_COMPONENT_TYPE = new ComponentType("reference");
    private BindingAdapterFactory bindingAdapterFactory;
    private Reference reference;
    private CountDownLatch latch = new CountDownLatch(1);

    public ReferenceComponent(Reference reference, Implementation implementation, BindingAdapterFactory bindingAdapterFactory, SofaRuntimeContext sofaRuntimeContext) {
        this.componentName = ComponentNameFactory.createComponentName(REFERENCE_COMPONENT_TYPE, reference.getInterfaceType(), reference.getUniqueId() + "#" + ReferenceRegisterHelper.generateBindingHashCode(reference));
        this.reference = reference;
        this.implementation = implementation;
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.bindingAdapterFactory = bindingAdapterFactory;
    }

    @Override
    public ComponentType getType() {
        return REFERENCE_COMPONENT_TYPE;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public HealthResult isHealthy() {
        Object serviceTarget;
        HealthResult result = new HealthResult(this.componentName.getRawName());
        ArrayList<HealthResult> bindingHealth = new ArrayList<HealthResult>();
        JvmBinding jvmBinding = null;
        HealthResult jvmBindingHealthResult = null;
        if (this.reference.hasBinding()) {
            for (Binding binding : this.reference.getBindings()) {
                bindingHealth.add(binding.healthCheck());
                if (!JvmBinding.JVM_BINDING_TYPE.equals(binding.getBindingType())) continue;
                jvmBinding = (JvmBinding)binding;
                jvmBindingHealthResult = (HealthResult)bindingHealth.get(bindingHealth.size() - 1);
            }
        }
        if (!SofaRuntimeProperties.isSkipJvmReferenceHealthCheck(this.sofaRuntimeContext) && jvmBinding != null && !this.isSkipReferenceHealthCheck() && this.reference.isRequired() && (serviceTarget = this.getServiceTarget()) == null && !jvmBinding.hasBackupProxy()) {
            Property sourceProperty;
            jvmBindingHealthResult.setHealthy(false);
            StringBuilder healthReport = new StringBuilder(64);
            healthReport.append("can not find corresponding jvm service");
            if (SofaRuntimeProperties.isReferenceHealthCheckMoreDetailEnable() && (sourceProperty = this.getProperties().get("source")) != null && sourceProperty.getValue() != null && sourceProperty.getValue() instanceof ComponentDefinitionInfo) {
                ComponentDefinitionInfo definitionInfo = (ComponentDefinitionInfo)sourceProperty.getValue();
                healthReport.append(".");
                healthReport.append(String.format("Which first declared through:%s beanId:%s,beanClassName:%s,location:%s", new Object[]{definitionInfo.getInterfaceMode(), definitionInfo.info("beanId"), definitionInfo.info("beanClassName"), definitionInfo.info("location")}));
            }
            jvmBindingHealthResult.setHealthReport(healthReport.toString());
        }
        ArrayList<HealthResult> failedBindingHealth = new ArrayList<HealthResult>();
        for (HealthResult healthResult : bindingHealth) {
            if (healthResult == null || healthResult.isHealthy()) continue;
            failedBindingHealth.add(healthResult);
        }
        result.setHealthy(failedBindingHealth.size() == 0);
        String report = this.aggregateBindingHealth(this.reference.getBindings());
        if (this.e != null) {
            report = report + " [" + this.e.getMessage() + "]";
            result.setHealthy(false);
        }
        result.setHealthReport(report);
        return result;
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        if (this.reference.hasBinding()) {
            Binding candidate = null;
            Set bindings = this.reference.getBindings();
            if (bindings.size() == 1) {
                candidate = (Binding)bindings.iterator().next();
            } else if (bindings.size() > 1) {
                Object backupProxy = null;
                for (Binding binding : bindings) {
                    if (JvmBinding.JVM_BINDING_TYPE.getType().equals(binding.getName())) {
                        candidate = binding;
                        continue;
                    }
                    backupProxy = this.createProxy(this.reference, binding);
                }
                if (candidate != null) {
                    ((JvmBinding)candidate).setBackupProxy(backupProxy);
                }
            }
            Object proxy = null;
            if (candidate != null) {
                proxy = this.createProxy(this.reference, candidate);
            }
            this.implementation = new DefaultImplementation();
            this.implementation.setTarget(proxy);
        }
        super.activate();
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() throws ServiceRuntimeException {
        super.unregister();
        if (this.reference.hasBinding()) {
            for (Binding binding : this.reference.getBindings()) {
                BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
                if (bindingAdapter == null) {
                    throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00100", (Object[])new Object[]{binding.getBindingType(), this.reference}));
                }
                SofaLogger.info(" >>Un-in Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)this.reference);
                try {
                    bindingAdapter.unInBinding(this.reference, binding, this.sofaRuntimeContext);
                }
                finally {
                    SofaLogger.info(" >>Un-in Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)this.reference);
                }
            }
        }
    }

    @Override
    public void exception(Exception e) throws ServiceRuntimeException {
        super.exception(e);
        this.latch.countDown();
    }

    @Override
    public Implementation getImplementation() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00101"), e);
        }
        if (this.e != null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00102"), this.e);
        }
        return super.getImplementation();
    }

    public Reference getReference() {
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createProxy(Reference reference, Binding binding) {
        Object proxy;
        BindingAdapter bindingAdapter = this.bindingAdapterFactory.getBindingAdapter(binding.getBindingType());
        if (bindingAdapter == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00100", (Object[])new Object[]{binding.getBindingType(), reference}));
        }
        SofaLogger.info(" >>In Binding [{}] Begins - {}.", (Object)binding.getBindingType(), (Object)reference);
        try {
            proxy = bindingAdapter.inBinding(reference, binding, this.sofaRuntimeContext);
        }
        finally {
            SofaLogger.info(" >>In Binding [{}] Ends - {}.", (Object)binding.getBindingType(), (Object)reference);
        }
        return proxy;
    }

    private Object getServiceTarget() {
        Object serviceTarget = null;
        ComponentName componentName = ComponentNameFactory.createComponentName(ServiceComponent.SERVICE_COMPONENT_TYPE, this.reference.getInterfaceType(), this.reference.getUniqueId());
        ComponentInfo componentInfo = this.sofaRuntimeContext.getComponentManager().getComponentInfo(componentName);
        if (componentInfo != null) {
            serviceTarget = componentInfo.getImplementation().getTarget();
        }
        if (serviceTarget == null) {
            serviceTarget = DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().findServiceProxy(this.sofaRuntimeContext.getAppClassLoader(), this.reference);
        }
        return serviceTarget;
    }

    private boolean isSkipReferenceHealthCheck() {
        List<String> skipCheckList = SofaRuntimeProperties.getSkipJvmReferenceHealthCheckList(Thread.currentThread().getContextClassLoader());
        boolean skip = false;
        if (skipCheckList != null && !skipCheckList.isEmpty()) {
            String currentReference = this.reference.getInterfaceType().getName() + (StringUtils.hasText((String)this.reference.getUniqueId()) ? ":" + this.reference.getUniqueId() : "");
            return skipCheckList.contains(currentReference);
        }
        return skip;
    }
}

