/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.spring.parser;

import com.alipay.sofa.runtime.ext.spring.ExtensionPointFactoryBean;
import com.alipay.sofa.runtime.ext.spring.parser.AbstractExtBeanDefinitionParser;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.spi.util.ParserUtils;
import java.util.LinkedHashSet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtensionPointBeanDefinitionParser
extends AbstractExtBeanDefinitionParser {
    public static final String CLASS = "class";
    public static final String OBJECT = "object";
    public static final String CONTRIBUTION = "contribution";
    private static final ExtensionPointBeanDefinitionParser instance = new ExtensionPointBeanDefinitionParser();

    public static ExtensionPointBeanDefinitionParser getInstance() {
        return instance;
    }

    @Override
    protected Class<?> getBeanClass(Element element) {
        return ExtensionPointFactoryBean.class;
    }

    @Override
    protected void parserSubElement(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Object target = null;
        if (element.hasAttribute("ref")) {
            target = new RuntimeBeanReference(element.getAttribute("ref"));
        }
        NodeList nl = element.getChildNodes();
        final LinkedHashSet contributions = new LinkedHashSet();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element subElement = (Element)node;
            if (OBJECT.equals(subElement.getLocalName())) {
                ParserUtils.parseCustomAttributes(subElement, parserContext, builder, new ParserUtils.AttributeCallback(){

                    @Override
                    public void process(Element parent, Attr attribute, BeanDefinitionBuilder builder, ParserContext parserContext) {
                        String name = attribute.getLocalName();
                        if (ExtensionPointBeanDefinitionParser.CLASS.equals(name)) {
                            contributions.add(attribute.getValue());
                        } else {
                            builder.addPropertyValue(Conventions.attributeNameToPropertyName((String)name), (Object)attribute.getValue());
                        }
                    }
                });
                continue;
            }
            if (element.hasAttribute("ref")) {
                SofaLogger.error("nested bean definition/reference cannot be used when attribute 'ref' is specified");
            }
            target = parserContext.getDelegate().parsePropertySubElement(subElement, (BeanDefinition)builder.getBeanDefinition());
        }
        builder.addPropertyValue(CONTRIBUTION, contributions);
        if (target instanceof RuntimeBeanReference) {
            builder.addPropertyValue("targetBeanName", (Object)target.getBeanName());
        } else {
            builder.addPropertyValue("target", target);
        }
    }

    public String supportTagName() {
        return "extension-point";
    }
}

