/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import com.alipay.sofa.common.xmap.Context;
import com.alipay.sofa.common.xmap.XAnnotatedContent;
import com.alipay.sofa.common.xmap.XAnnotatedList;
import com.alipay.sofa.common.xmap.XAnnotatedMap;
import com.alipay.sofa.common.xmap.XAnnotatedMember;
import com.alipay.sofa.common.xmap.XAnnotatedObject;
import com.alipay.sofa.common.xmap.XAnnotatedParent;
import com.alipay.sofa.common.xmap.XFieldGetter;
import com.alipay.sofa.common.xmap.XFieldSetter;
import com.alipay.sofa.common.xmap.XGetter;
import com.alipay.sofa.common.xmap.XMethodGetter;
import com.alipay.sofa.common.xmap.XMethodSetter;
import com.alipay.sofa.common.xmap.XSetter;
import com.alipay.sofa.common.xmap.XValueFactory;
import com.alipay.sofa.common.xmap.annotation.XContent;
import com.alipay.sofa.common.xmap.annotation.XMemberAnnotation;
import com.alipay.sofa.common.xmap.annotation.XNode;
import com.alipay.sofa.common.xmap.annotation.XNodeList;
import com.alipay.sofa.common.xmap.annotation.XNodeMap;
import com.alipay.sofa.common.xmap.annotation.XObject;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMap {
    protected final Map<String, XAnnotatedObject> roots;
    protected final Map<Class, XAnnotatedObject> objects = new Hashtable<Class, XAnnotatedObject>();
    protected final Map<Class, XValueFactory> factories;
    private static final String DDD = "http://apache.org/xml/features/disallow-doctype-decl";

    public XMap() {
        this.roots = new Hashtable<String, XAnnotatedObject>();
        this.factories = new Hashtable<Class, XValueFactory>(XValueFactory.defaultFactories);
    }

    public XValueFactory getValueFactory(Class type) {
        return this.factories.get(type);
    }

    public void setValueFactory(Class type, XValueFactory factory) {
        this.factories.put(type, factory);
    }

    public Collection<XAnnotatedObject> getScannedObjects() {
        return this.objects.values();
    }

    public Collection<XAnnotatedObject> getRootObjects() {
        return this.roots.values();
    }

    public XAnnotatedObject register(Class klass) {
        XObject xob;
        XAnnotatedObject xao = this.objects.get(klass);
        if (xao == null && (xob = XMap.checkObjectAnnotation(klass, klass.getClassLoader())) != null) {
            xao = new XAnnotatedObject(this, klass, xob);
            this.objects.put(xao.klass, xao);
            this.scan(xao);
            String key = xob.value();
            if (key.length() > 0) {
                this.roots.put(xao.path.path, xao);
            }
        }
        return xao;
    }

    public XAnnotatedObject register(Class klass, boolean isParent) {
        XObject xob;
        XAnnotatedObject xao = this.objects.get(klass);
        if (xao == null && (xob = XMap.checkObjectAnnotation(klass, klass.getClassLoader())) != null) {
            xao = new XAnnotatedObject(this, klass, xob);
            this.objects.put(xao.klass, xao);
            if (isParent) {
                this.scanParent(xao);
            } else {
                this.scan(xao);
            }
            String key = xob.value();
            if (key.length() > 0) {
                this.roots.put(xao.path.path, xao);
            }
        }
        return xao;
    }

    private void scan(XAnnotatedObject xob) {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = xob.klass.getDeclaredFields()) {
            Annotation anno = XMap.checkMemberAnnotation(field);
            if (anno == null) continue;
            XAnnotatedMember member = this.createFieldMember(field, anno);
            xob.addMember(member);
        }
        for (Method method : methods = xob.klass.getDeclaredMethods()) {
            Annotation anno;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1 || (anno = XMap.checkMemberAnnotation(method)) == null) continue;
            XAnnotatedMember member = this.createMethodMember(method, xob.klass, anno);
            xob.addMember(member);
        }
    }

    private void scanParent(XAnnotatedObject xob) {
        for (Class<?> scanClass = xob.klass; scanClass != Object.class; scanClass = scanClass.getSuperclass()) {
            for (Method method : scanClass.getDeclaredMethods()) {
                Annotation anno;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != 1 || (anno = XMap.checkMemberAnnotation(method)) == null) continue;
                XAnnotatedMember member = this.createMethodMember(method, xob.klass, anno);
                xob.addMember(member);
            }
            for (AccessibleObject accessibleObject : scanClass.getDeclaredFields()) {
                Annotation anno = XMap.checkMemberAnnotation(accessibleObject);
                if (anno == null) continue;
                XAnnotatedMember member = this.createFieldMember((Field)accessibleObject, anno);
                xob.addMember(member);
            }
        }
    }

    public Object load(URL url) throws Exception {
        return this.load(new Context(), url.openStream());
    }

    public Object load(Context ctx, URL url) throws Exception {
        return this.load(ctx, url.openStream());
    }

    public Object load(InputStream in) throws Exception {
        return this.load(new Context(), in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Context ctx, InputStream in) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature(DDD, true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Object object = this.load(ctx, document.getDocumentElement());
            return object;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object[] loadAll(URL url) throws Exception {
        return this.loadAll(new Context(), url.openStream());
    }

    public Object[] loadAll(Context ctx, URL url) throws Exception {
        return this.loadAll(ctx, url.openStream());
    }

    public Object[] loadAll(InputStream in) throws Exception {
        return this.loadAll(new Context(), in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] loadAll(Context ctx, InputStream in) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature(DDD, true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Object[] objectArray = this.loadAll(ctx, document.getDocumentElement());
            return objectArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object load(Element root) throws Exception {
        return this.load(new Context(), root);
    }

    public Object load(Context ctx, Element root) throws Exception {
        String name = root.getNodeName();
        XAnnotatedObject xob = this.roots.get(name);
        if (xob != null) {
            return xob.newInstance(new Context(), root);
        }
        for (Node p = root.getFirstChild(); p != null; p = p.getNextSibling()) {
            if (p.getNodeType() != 1) continue;
            return this.load((Element)p);
        }
        return null;
    }

    public <T> T load(Map<String, Object> map, String keyPrefix, Class<T> klass) throws Exception {
        XAnnotatedObject xob = this.objects.get(klass);
        if (xob == null) {
            xob = this.register(klass);
        }
        return (T)xob.newInstance(new Context(), map, keyPrefix);
    }

    public Object[] loadAll(Context ctx, Element root) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        this.loadAll(ctx, root, result);
        return result.toArray();
    }

    public Object[] loadAll(Element root) throws Exception {
        return this.loadAll(new Context(), root);
    }

    public void loadAll(Element root, Collection<Object> result) throws Exception {
        this.loadAll(new Context(), root, result);
    }

    public Document asXml(Object contribution, List<String> filters) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature(DDD, true);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        if (contribution == null) {
            return document;
        }
        XAnnotatedObject xao = this.objects.get(contribution.getClass());
        if (xao != null) {
            xao.decode(contribution, document, document, filters);
        }
        return document;
    }

    public String asXmlString(Object contribution, String encoding, List<String> filters) throws Exception {
        return this.asXmlString(contribution, encoding, filters, false);
    }

    public String asXmlString(Object contribution, String encoding, List<String> filters, boolean pretty) throws Exception {
        Document doc = this.asXml(contribution, filters);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(doc);
        if (encoding != null && encoding.length() > 0) {
            transformer.setOutputProperty("encoding", encoding);
        }
        if (pretty) {
            transformer.setOutputProperty("indent", "yes");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
    }

    public void loadAll(Context ctx, Element root, Collection<Object> result) throws Exception {
        String name = root.getNodeName();
        XAnnotatedObject xob = this.roots.get(name);
        if (xob != null) {
            Object ob = xob.newInstance(ctx, root);
            result.add(ob);
        } else {
            for (Node p = root.getFirstChild(); p != null; p = p.getNextSibling()) {
                if (p.getNodeType() != 1) continue;
                this.loadAll(ctx, (Element)p, result);
            }
        }
    }

    protected static Annotation checkMemberAnnotation(AnnotatedElement ae) {
        Annotation[] annos;
        for (Annotation anno : annos = ae.getAnnotations()) {
            if (!anno.annotationType().isAnnotationPresent(XMemberAnnotation.class)) continue;
            return anno;
        }
        return null;
    }

    protected static XObject checkObjectAnnotation(AnnotatedElement ae, ClassLoader classLoader) {
        return ae.getAnnotation(XObject.class);
    }

    private XAnnotatedMember createMember(Annotation annotation, XSetter setter, XGetter getter) {
        XAnnotatedMember member = null;
        int type = annotation.annotationType().getAnnotation(XMemberAnnotation.class).value();
        if (type == 1) {
            member = new XAnnotatedMember(this, setter, getter, (XNode)annotation);
        } else if (type == 2) {
            member = new XAnnotatedList(this, setter, getter, (XNodeList)annotation);
        } else if (type == 3) {
            member = new XAnnotatedMap(this, setter, getter, (XNodeMap)annotation);
        } else if (type == 4) {
            member = new XAnnotatedParent(this, setter, getter);
        } else if (type == 5) {
            member = new XAnnotatedContent(this, setter, getter, (XContent)annotation);
        }
        return member;
    }

    public final XAnnotatedMember createFieldMember(Field field, Annotation annotation) {
        XFieldSetter setter = new XFieldSetter(field);
        XFieldGetter getter = new XFieldGetter(field);
        return this.createMember(annotation, setter, getter);
    }

    public final XAnnotatedMember createMethodMember(Method method, Class<?> clazz, Annotation annotation) {
        XMethodSetter setter = new XMethodSetter(method);
        String methodName = method.getName();
        String name = Introspector.decapitalize(methodName.substring(3));
        XMethodGetter getter = new XMethodGetter(this.getGetterMethod(clazz, name), clazz, name);
        return this.createMember(annotation, setter, getter);
    }

    public Method getGetterMethod(Class<?> clazz, String name) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.matches("^(get|is).*") || method.getParameterTypes().length != 0 || !Introspector.decapitalize(methodName.substring(3)).equals(name)) continue;
            return method;
        }
        return null;
    }
}

