/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class ChangePeersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ChangePeersRequest> {
    public ChangePeersRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.ChangePeersRequest request) {
        return request.getLeaderId();
    }

    @Override
    protected String getGroupId(CliRequests.ChangePeersRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ChangePeersRequest request, RpcRequestClosure done) {
        List<PeerId> oldConf = ctx.node.listPeers();
        Configuration conf = new Configuration();
        Iterator iterator = request.getNewPeersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerIdStr = (String)iterator.next();
            if (peer.parse(peerIdStr)) {
                conf.addPeer(peer);
                continue;
            }
            return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
        }
        LOG.info("Receive ChangePeersRequest to {} from {}, new conf is {}", new Object[]{ctx.node.getNodeId(), done.getBizContext().getRemoteAddress(), conf});
        ctx.node.changePeers(conf, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.ChangePeersResponse.Builder rb = CliRequests.ChangePeersResponse.newBuilder();
                for (PeerId peer : oldConf) {
                    rb.addOldPeers(peer.toString());
                }
                for (PeerId peer : conf) {
                    rb.addNewPeers(peer.toString());
                }
                done.sendResponse((Message)rb.build());
            }
        });
        return null;
    }

    public String interest() {
        return CliRequests.ChangePeersRequest.class.getName();
    }
}

