/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.manager.TaskProcessor;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.ConfigService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;

class DumpAllTagProcessor
implements TaskProcessor {
    static final int PAGE_SIZE = 1000;
    final DumpService dumpService;
    final PersistService persistService;

    DumpAllTagProcessor(DumpService dumpService) {
        this.dumpService = dumpService;
        this.persistService = dumpService.persistService;
    }

    @Override
    public boolean process(String taskType, AbstractTask task) {
        int rowCount = this.persistService.configInfoTagCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 1000.0);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<PersistService.ConfigInfoTagWrapper> page = this.persistService.findAllConfigInfoTagForDumpAll(pageNo, 1000);
            if (page == null) continue;
            for (PersistService.ConfigInfoTagWrapper cf : page.getPageItems()) {
                boolean result = ConfigService.dumpTag(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getTag(), cf.getContent(), cf.getLastModified());
                LogUtil.dumpLog.info("[dump-all-Tag-ok] result={}, {}, {}, length={}, md5={}", new Object[]{result, GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), cf.getContent().length(), cf.getMd5()});
            }
            LogUtil.defaultLog.info("[all-dump-tag] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }
}

