/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.utils.LogUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SwitchService {
    public static final String SWITCH_META_DATAID = "com.alibaba.nacos.meta.switch";
    public static final String FIXED_POLLING = "isFixedPolling";
    public static final String FIXED_POLLING_INTERVAL = "fixedPollingInertval";
    public static final String FIXED_DELAY_TIME = "fixedDelayTime";
    public static final String DISABLE_APP_COLLECTOR = "disableAppCollector";
    private static volatile Map<String, String> switches = new HashMap<String, String>();

    public static boolean getSwitchBoolean(String key, boolean defaultValue) {
        boolean rtn = defaultValue;
        try {
            String value = switches.get(key);
            rtn = value != null ? Boolean.valueOf(value) : defaultValue;
        }
        catch (Exception e) {
            rtn = defaultValue;
            LogUtil.fatalLog.error("corrupt switch value {}={}", (Object)key, (Object)switches.get(key));
        }
        return rtn;
    }

    public static int getSwitchInteger(String key, int defaultValue) {
        int rtn = defaultValue;
        try {
            String status = switches.get(key);
            rtn = status != null ? Integer.parseInt(status) : defaultValue;
        }
        catch (Exception e) {
            rtn = defaultValue;
            LogUtil.fatalLog.error("corrupt switch value {}={}", (Object)key, (Object)switches.get(key));
        }
        return rtn;
    }

    public static String getSwitchString(String key, String defaultValue) {
        String value = switches.get(key);
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : value;
    }

    public static void load(String config) {
        if (StringUtils.isBlank((CharSequence)config)) {
            LogUtil.fatalLog.error("switch config is blank.");
            return;
        }
        LogUtil.fatalLog.warn("[switch-config] {}", (Object)config);
        HashMap<String, String> map = new HashMap<String, String>(30);
        try {
            for (String line : IOUtils.readLines((Reader)new StringReader(config))) {
                if (!StringUtils.isBlank((CharSequence)line) && !line.startsWith("#")) {
                    String[] array = line.split("=");
                    if (array == null || array.length != 2) {
                        LogUtil.fatalLog.error("corrupt switch record {}", (Object)line);
                        continue;
                    }
                    String key = array[0].trim();
                    String value = array[1].trim();
                    map.put(key, value);
                }
                switches = map;
                LogUtil.fatalLog.warn("[reload-switches] {}", (Object)SwitchService.getSwitches());
            }
        }
        catch (IOException e) {
            LogUtil.fatalLog.warn("[reload-switches] error! {}", (Object)config);
        }
    }

    public static String getSwitches() {
        StringBuilder sb = new StringBuilder();
        String split = "";
        for (Map.Entry<String, String> entry : switches.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(split);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            split = "; ";
        }
        return sb.toString();
    }
}

