/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.TimerTaskService;
import com.alibaba.nacos.config.server.service.notify.NotifyService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.RunningConfigUtils;
import com.alibaba.nacos.config.server.utils.event.EventDispatcher;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ServerListService
implements ApplicationListener<WebServerInitializedEvent> {
    @Autowired
    private Environment env;
    @Autowired
    private ServletContext servletContext;
    private int port;
    static final int TIMEOUT = 5000;
    private int maxFailCount = 12;
    private static volatile List<String> serverList = new ArrayList<String>();
    private static volatile List<String> serverListUnhealth = new ArrayList<String>();
    private static volatile boolean isAddressServerHealth = true;
    private static volatile int addressServerFailCcount = 0;
    private static volatile boolean isInIpList = true;
    private static volatile Map<String, Integer> serverIp2unhealthCount = new HashMap<String, Integer>();
    private RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(PropertyUtil.getNotifyConnectTimeout()).setSocketTimeout(PropertyUtil.getNotifySocketTimeout()).build();
    private CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().setDefaultRequestConfig(this.requestConfig).build();
    public String serverPort;
    public String domainName;
    public String addressPort;
    public String addressUrl;
    public String envIdUrl;
    public String addressServerUrl;
    private Boolean isUseAddressServer = true;
    private boolean isHealthCheck = true;
    private static final String FALSE_STR = "false";

    @PostConstruct
    public void init() {
        this.serverPort = System.getProperty("nacos.server.port", "8848");
        String envDomainName = System.getenv("address_server_domain");
        this.domainName = StringUtils.isBlank((CharSequence)envDomainName) ? System.getProperty("address.server.domain", "jmenv.tbsite.net") : envDomainName;
        String envAddressPort = System.getenv("address_server_port");
        this.addressPort = StringUtils.isBlank((CharSequence)envAddressPort) ? System.getProperty("address.server.port", "8080") : envAddressPort;
        this.addressUrl = System.getProperty("address.server.url", this.servletContext.getContextPath() + "/" + RunningConfigUtils.getClusterName());
        this.addressServerUrl = "http://" + this.domainName + ":" + this.addressPort + this.addressUrl;
        this.envIdUrl = "http://" + this.domainName + ":" + this.addressPort + "/env";
        LogUtil.defaultLog.info("ServerListService address-server port:" + this.serverPort);
        LogUtil.defaultLog.info("ADDRESS_SERVER_URL:" + this.addressServerUrl);
        this.isHealthCheck = PropertyUtil.isHealthCheck();
        this.maxFailCount = PropertyUtil.getMaxHealthCheckFailCount();
        try {
            String val = null;
            val = this.env.getProperty("useAddressServer");
            if (val != null && FALSE_STR.equals(val)) {
                this.isUseAddressServer = false;
            }
            LogUtil.fatalLog.warn("useAddressServer:{}", (Object)this.isUseAddressServer);
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("read application.properties wrong", (Throwable)e);
        }
        GetServerListTask task = new GetServerListTask();
        task.run();
        if (null == serverList || serverList.isEmpty()) {
            LogUtil.fatalLog.error("########## cannot get serverlist, so exit.");
            throw new RuntimeException("cannot get serverlist, so exit.");
        }
        TimerTaskService.scheduleWithFixedDelay(task, 0L, 5L, TimeUnit.SECONDS);
        this.httpclient.start();
        CheckServerHealthTask checkServerHealthTask = new CheckServerHealthTask();
        TimerTaskService.scheduleWithFixedDelay(checkServerHealthTask, 0L, 5L, TimeUnit.SECONDS);
    }

    public String getEnvId() {
        String envId = "";
        int i = 0;
        do {
            if (!StringUtils.isBlank((CharSequence)(envId = this.getEnvIdHttp()))) continue;
            ++i;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LogUtil.defaultLog.error("sleep interrupt");
            }
        } while (StringUtils.isBlank((CharSequence)envId) && i < 5);
        if (StringUtils.isBlank((CharSequence)envId)) {
            LogUtil.defaultLog.error("envId is blank");
        }
        return envId;
    }

    public List<String> getServerList() {
        return new ArrayList<String>(serverList);
    }

    public static void setServerList(List<String> serverList) {
        ServerListService.serverList = serverList;
    }

    public static List<String> getServerListUnhealth() {
        return new ArrayList<String>(serverListUnhealth);
    }

    public static Boolean isFirstIp() {
        return serverList.get(0).contains(SystemUtils.LOCAL_IP);
    }

    public boolean isHealthCheck() {
        return this.isHealthCheck;
    }

    private void updateIfChanged(List<String> newList) {
        if (newList.isEmpty()) {
            return;
        }
        boolean isContainSelfIp = false;
        for (String string : newList) {
            if (!string.contains(SystemUtils.LOCAL_IP)) continue;
            isContainSelfIp = true;
            break;
        }
        if (isContainSelfIp) {
            isInIpList = true;
        } else {
            isInIpList = false;
            String selfAddr = this.getFormatServerAddr(SystemUtils.LOCAL_IP);
            newList.add(selfAddr);
            LogUtil.fatalLog.error("########## [serverlist] self ip {} not in serverlist {}", (Object)selfAddr, newList);
        }
        if (newList.equals(serverList)) {
            return;
        }
        serverList = new ArrayList<String>(newList);
        ArrayList<String> unhealthRemoved = new ArrayList<String>();
        for (String unhealthIp : serverListUnhealth) {
            if (newList.contains(unhealthIp)) continue;
            unhealthRemoved.add(unhealthIp);
        }
        serverListUnhealth.removeAll(unhealthRemoved);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Integer> ip2UnhealthCountTmp : serverIp2unhealthCount.entrySet()) {
            if (newList.contains(ip2UnhealthCountTmp.getKey())) continue;
            arrayList.add(ip2UnhealthCountTmp.getKey());
        }
        for (String unhealthCountTmp : arrayList) {
            serverIp2unhealthCount.remove(unhealthCountTmp);
        }
        LogUtil.defaultLog.warn("[serverlist] updated to {}", serverList);
        EventDispatcher.fireEvent(new ServerlistChangeEvent());
    }

    private List<String> getApacheServerList() {
        ArrayList<String> serverIps;
        if (SystemUtils.STANDALONE_MODE) {
            ArrayList<String> serverIps2 = new ArrayList<String>();
            serverIps2.add(this.getFormatServerAddr(SystemUtils.LOCAL_IP));
            return serverIps2;
        }
        try {
            serverIps = new ArrayList<String>();
            List serverAddrLines = SystemUtils.readClusterConf();
            if (!CollectionUtils.isEmpty((Collection)serverAddrLines)) {
                for (String serverAddr : serverAddrLines) {
                    if (!StringUtils.isNotBlank((CharSequence)serverAddr.trim())) continue;
                    serverIps.add(this.getFormatServerAddr(serverAddr));
                }
            }
            if (serverIps.size() > 0) {
                return serverIps;
            }
        }
        catch (Exception e) {
            LogUtil.defaultLog.error("nacos-XXXX", (Object)"[serverlist] failed to get serverlist from disk!", (Object)e);
        }
        if (this.isUseAddressServer().booleanValue()) {
            try {
                NotifyService.HttpResult result = NotifyService.invokeURL(this.addressServerUrl, null, null);
                if (200 == result.code) {
                    isAddressServerHealth = true;
                    addressServerFailCcount = 0;
                    List lines = IOUtils.readLines((Reader)new StringReader(result.content));
                    ArrayList<String> ips = new ArrayList<String>(lines.size());
                    for (String serverAddr : lines) {
                        if (null == serverAddr || serverAddr.trim().isEmpty()) continue;
                        ips.add(this.getFormatServerAddr(serverAddr));
                    }
                    return ips;
                }
                if (++addressServerFailCcount >= this.maxFailCount) {
                    isAddressServerHealth = false;
                }
                LogUtil.defaultLog.error("[serverlist] failed to get serverlist, error code {}", (Object)result.code);
                return Collections.emptyList();
            }
            catch (IOException e) {
                if (++addressServerFailCcount >= this.maxFailCount) {
                    isAddressServerHealth = false;
                }
                LogUtil.defaultLog.error("[serverlist] exception, " + e.toString(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        serverIps = new ArrayList();
        serverIps.add(this.getFormatServerAddr(SystemUtils.LOCAL_IP));
        return serverIps;
    }

    private String getFormatServerAddr(String serverAddr) {
        if (StringUtils.isBlank((CharSequence)serverAddr)) {
            throw new IllegalArgumentException("invalid serverlist");
        }
        String[] ipPort = serverAddr.trim().split(":");
        String ip = ipPort[0].trim();
        if (ipPort.length == 1 && this.port != 0) {
            return ip + ":" + this.port;
        }
        return serverAddr;
    }

    private String getEnvIdHttp() {
        try {
            NotifyService.HttpResult result = NotifyService.invokeURL(this.envIdUrl, null, null);
            if (200 == result.code) {
                return result.content.trim();
            }
            LogUtil.defaultLog.error("[envId] failed to get envId, error code {}", (Object)result.code);
            return "";
        }
        catch (IOException e) {
            LogUtil.defaultLog.error("[envId] exception, " + e.toString(), (Throwable)e);
            return "";
        }
    }

    private void checkServerHealth() {
        long startCheckTime = System.currentTimeMillis();
        for (String serverIp : serverList) {
            String url = "http://" + serverIp + this.servletContext.getContextPath() + "/v1/cs/health";
            HttpGet request = new HttpGet(url);
            this.httpclient.execute((HttpUriRequest)request, (FutureCallback)new AyscCheckServerHealthCallBack(serverIp));
        }
        long endCheckTime = System.currentTimeMillis();
        long cost = endCheckTime - startCheckTime;
        LogUtil.defaultLog.debug("checkServerHealth cost: {}", (Object)cost);
    }

    private Boolean isUseAddressServer() {
        return this.isUseAddressServer;
    }

    public static boolean isAddressServerHealth() {
        return isAddressServerHealth;
    }

    public static boolean isInIpList() {
        return isInIpList;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        if (this.port == 0) {
            this.port = event.getWebServer().getPort();
            ArrayList<String> newList = new ArrayList<String>();
            for (String serverAddrTmp : serverList) {
                newList.add(this.getFormatServerAddr(serverAddrTmp));
            }
            ServerListService.setServerList(new ArrayList<String>(newList));
        }
    }

    static class CheckServerThreadFactory
    implements ThreadFactory {
        CheckServerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "com.alibaba.nacos.CheckServerThreadFactory");
            thread.setDaemon(true);
            return thread;
        }
    }

    class CheckServerHealthTask
    implements Runnable {
        CheckServerHealthTask() {
        }

        @Override
        public void run() {
            ServerListService.this.checkServerHealth();
        }
    }

    class AyscCheckServerHealthCallBack
    implements FutureCallback<HttpResponse> {
        private String serverIp;

        public AyscCheckServerHealthCallBack(String serverIp) {
            this.serverIp = serverIp;
        }

        public void completed(HttpResponse response) {
            if (response.getStatusLine().getStatusCode() == 200) {
                serverIp2unhealthCount.put(this.serverIp, 0);
                if (serverListUnhealth.contains(this.serverIp)) {
                    serverListUnhealth.remove(this.serverIp);
                }
                HttpClientUtils.closeQuietly((HttpResponse)response);
            }
        }

        public void failed(Exception ex) {
            Integer failCount = (Integer)serverIp2unhealthCount.get(this.serverIp);
            Integer n = failCount = failCount == null ? Integer.valueOf(0) : failCount;
            Integer n2 = failCount = Integer.valueOf(failCount + 1);
            serverIp2unhealthCount.put(this.serverIp, failCount);
            if (failCount > ServerListService.this.maxFailCount) {
                if (!serverListUnhealth.contains(this.serverIp)) {
                    serverListUnhealth.add(this.serverIp);
                }
                LogUtil.defaultLog.error("unhealthIp:{}, unhealthCount:{}", (Object)this.serverIp, (Object)failCount);
                MetricsMonitor.getUnhealthException().increment();
            }
        }

        public void cancelled() {
            Integer failCount = (Integer)serverIp2unhealthCount.get(this.serverIp);
            Integer n = failCount = failCount == null ? Integer.valueOf(0) : failCount;
            Integer n2 = failCount = Integer.valueOf(failCount + 1);
            serverIp2unhealthCount.put(this.serverIp, failCount);
            if (failCount > ServerListService.this.maxFailCount) {
                if (!serverListUnhealth.contains(this.serverIp)) {
                    serverListUnhealth.add(this.serverIp);
                }
                LogUtil.defaultLog.error("unhealthIp:{}, unhealthCount:{}", (Object)this.serverIp, (Object)failCount);
                MetricsMonitor.getUnhealthException().increment();
            }
        }
    }

    class GetServerListTask
    implements Runnable {
        GetServerListTask() {
        }

        @Override
        public void run() {
            try {
                ServerListService.this.updateIfChanged(ServerListService.this.getApacheServerList());
            }
            catch (Exception e) {
                LogUtil.defaultLog.error("[serverlist] failed to get serverlist, " + e.toString(), (Throwable)e);
            }
        }
    }

    public static class ServerlistChangeEvent
    implements EventDispatcher.Event {
    }
}

