/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.controller.ConfigServletInner;
import com.alibaba.nacos.config.server.exception.NacosException;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo4Beta;
import com.alibaba.nacos.config.server.model.GroupkeyListenserStatus;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.RestResult;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.ConfigSubService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.config.server.utils.event.EventDispatcher;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/v1/cs/configs"})
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    private final transient ConfigServletInner inner;
    private final transient PersistService persistService;
    private final transient ConfigSubService configSubService;

    @Autowired
    public ConfigController(ConfigServletInner configServletInner, PersistService persistService, ConfigSubService configSubService) {
        this.inner = configServletInner;
        this.persistService = persistService;
        this.configSubService = configSubService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Boolean publishConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="content") String content, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="desc", required=false) String desc, @RequestParam(value="use", required=false) String use, @RequestParam(value="effect", required=false) String effect, @RequestParam(value="type", required=false) String type, @RequestParam(value="schema", required=false) String schema) throws NacosException {
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        ParamUtils.checkParam(dataId, group, "datumId", content);
        ParamUtils.checkParam(tag);
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
        if (configTags != null) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        if (desc != null) {
            configAdvanceInfo.put("desc", desc);
        }
        if (use != null) {
            configAdvanceInfo.put("use", use);
        }
        if (effect != null) {
            configAdvanceInfo.put("effect", effect);
        }
        if (type != null) {
            configAdvanceInfo.put("type", type);
        }
        if (schema != null) {
            configAdvanceInfo.put("schema", schema);
        }
        ParamUtils.checkParam(configAdvanceInfo);
        if (AggrWhitelist.isAggrDataId(dataId)) {
            log.warn("[aggr-conflict] {} attemp to publish single data, {}, {}", new Object[]{RequestUtil.getRemoteIp(request), dataId, group});
            throw new NacosException(403, "dataId:" + dataId + " is aggr");
        }
        Timestamp time = TimeUtils.getCurrentTime();
        String betaIps = request.getHeader("betaIps");
        ConfigInfo configInfo = new ConfigInfo(dataId, group, tenant, appName, content);
        if (StringUtils.isBlank((CharSequence)betaIps)) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                this.persistService.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, false);
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, dataId, group, tenant, time.getTime()));
            } else {
                this.persistService.insertOrUpdateTag(configInfo, tag, srcIp, srcUser, time, false);
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
            }
        } else {
            this.persistService.insertOrUpdateBeta(configInfo, betaIps, srcIp, srcUser, time, false);
            EventDispatcher.fireEvent(new ConfigDataChangeEvent(true, dataId, group, tenant, time.getTime()));
        }
        ConfigTraceService.logPersistenceEvent(dataId, group, tenant, requestIpApp, time.getTime(), SystemUtils.LOCAL_IP, "pub", content);
        return true;
    }

    @RequestMapping(method={RequestMethod.GET})
    public void getConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws IOException, ServletException, NacosException {
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        this.inner.doGetConfig(request, response, dataId, group, tenant, tag, clientIp);
    }

    @RequestMapping(params={"show=all"}, method={RequestMethod.GET})
    @ResponseBody
    public ConfigAllInfo detailConfigInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) throws NacosException {
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        return this.persistService.findConfigAllInfo(dataId, group, tenant);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public Boolean deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws NacosException {
        ParamUtils.checkParam(dataId, group, "datumId", "rm");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        if (StringUtils.isBlank((CharSequence)tag)) {
            this.persistService.removeConfigInfo(dataId, group, tenant, clientIp, null);
        } else {
            this.persistService.removeConfigInfoTag(dataId, group, tenant, tag, clientIp, null);
        }
        Timestamp time = TimeUtils.getCurrentTime();
        ConfigTraceService.logPersistenceEvent(dataId, group, tenant, null, time.getTime(), clientIp, "remove", null);
        EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
        return true;
    }

    @RequestMapping(value={"/catalog"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult<ConfigAdvanceInfo> getConfigAdvanceInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult<ConfigAdvanceInfo> rr = new RestResult<ConfigAdvanceInfo>();
        ConfigAdvanceInfo configInfo = this.persistService.findConfigAdvanceInfo(dataId, group, tenant);
        rr.setCode(200);
        rr.setData(configInfo);
        return rr;
    }

    @RequestMapping(value={"/listener"}, method={RequestMethod.POST})
    public void listener(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, String> clientMd5Map;
        request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        String probeModify = request.getParameter("Listening-Configs");
        if (StringUtils.isBlank((CharSequence)probeModify)) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        probeModify = URLDecoder.decode(probeModify, "UTF-8");
        try {
            clientMd5Map = MD5Util.getClientMd5Map(probeModify);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        this.inner.doPollingConfig(request, response, clientMd5Map, probeModify.length());
    }

    @RequestMapping(value={"/listener"}, method={RequestMethod.GET})
    @ResponseBody
    public GroupkeyListenserStatus getListeners(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, @RequestParam(value="sampleTime", required=false, defaultValue="1") int sampleTime) throws Exception {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        SampleResult collectSampleResult = this.configSubService.getCollectSampleResult(dataId, group, tenant, sampleTime);
        GroupkeyListenserStatus gls = new GroupkeyListenserStatus();
        gls.setCollectStatus(200);
        if (collectSampleResult.getLisentersGroupkeyStatus() != null) {
            gls.setLisentersGroupkeyStatus(collectSampleResult.getLisentersGroupkeyStatus());
        }
        return gls;
    }

    @RequestMapping(params={"search=accurate"}, method={RequestMethod.GET})
    @ResponseBody
    public Page<ConfigInfo> searchConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        try {
            return this.persistService.findConfigInfo4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @RequestMapping(params={"search=blur"}, method={RequestMethod.GET})
    @ResponseBody
    public Page<ConfigInfo> fuzzySearchConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(50);
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        try {
            return this.persistService.findConfigInfoLike4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @RequestMapping(params={"beta=true"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult<Boolean> stopBeta(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult<Boolean> rr = new RestResult<Boolean>();
        try {
            this.persistService.removeConfigInfo4Beta(dataId, group, tenant);
        }
        catch (Throwable e) {
            log.error("remove beta data error", e);
            rr.setCode(500);
            rr.setData(false);
            rr.setMessage("remove beta data error");
            return rr;
        }
        EventDispatcher.fireEvent(new ConfigDataChangeEvent(true, dataId, group, tenant, System.currentTimeMillis()));
        rr.setCode(200);
        rr.setData(true);
        rr.setMessage("stop beta ok");
        return rr;
    }

    @RequestMapping(params={"beta=true"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult<ConfigInfo4Beta> queryBeta(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult<ConfigInfo4Beta> rr = new RestResult<ConfigInfo4Beta>();
        try {
            ConfigInfo4Beta ci = this.persistService.findConfigInfo4Beta(dataId, group, tenant);
            rr.setCode(200);
            rr.setData(ci);
            rr.setMessage("stop beta ok");
            return rr;
        }
        catch (Throwable e) {
            log.error("remove beta data error", e);
            rr.setCode(500);
            rr.setMessage("remove beta data error");
            return rr;
        }
    }
}

