/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v07.handlers.sax;

import com.alibaba.excel.cache.ReadCache;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SharedStringsTableHandler
extends DefaultHandler {
    private StringBuilder currentData;
    private StringBuilder currentElementData;
    private final ReadCache readCache;
    private boolean ignoreTagt = false;
    private boolean isTagt = false;

    public SharedStringsTableHandler(ReadCache readCache) {
        this.readCache = readCache;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if (name == null) {
            return;
        }
        switch (name) {
            case "t": 
            case "x:t": {
                this.currentElementData = null;
                this.isTagt = true;
                break;
            }
            case "si": 
            case "x:si": {
                this.currentData = null;
                break;
            }
            case "rPh": 
            case "x:rPh": {
                this.ignoreTagt = true;
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if (name == null) {
            return;
        }
        switch (name) {
            case "t": 
            case "x:t": {
                if (this.currentElementData != null) {
                    if (this.currentData == null) {
                        this.currentData = new StringBuilder();
                    }
                    this.currentData.append((CharSequence)this.currentElementData);
                }
                this.isTagt = false;
                break;
            }
            case "si": 
            case "x:si": {
                if (this.currentData == null) {
                    this.readCache.put(null);
                    break;
                }
                this.readCache.put(this.currentData.toString());
                break;
            }
            case "rPh": 
            case "x:rPh": {
                this.ignoreTagt = false;
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.isTagt || this.ignoreTagt) {
            return;
        }
        if (this.currentElementData == null) {
            this.currentElementData = new StringBuilder();
        }
        this.currentElementData.append(ch, start, length);
    }
}

