/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.netty;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.transport.AbstractClient;
import com.alibaba.dubbo.remoting.transport.netty.NettyChannel;
import com.alibaba.dubbo.remoting.transport.netty.NettyCodecAdapter;
import com.alibaba.dubbo.remoting.transport.netty.NettyHandler;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

public class NettyClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(NettyClient.class);
    private static final ChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(new NamedThreadFactory("NettyClientBoss", true)), (Executor)Executors.newCachedThreadPool(new NamedThreadFactory("NettyClientWorker", true)), Constants.DEFAULT_IO_THREADS);
    private ClientBootstrap bootstrap;
    private volatile org.jboss.netty.channel.Channel channel;

    public NettyClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, NettyClient.wrapChannelHandler(url, handler));
    }

    protected void doOpen() throws Throwable {
        this.bootstrap = new ClientBootstrap(channelFactory);
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
        this.bootstrap.setOption("connectTimeoutMillis", (Object)this.getTimeout());
        final NettyHandler nettyHandler = new NettyHandler(this.getUrl(), this);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyClient.this.getCodec(), NettyClient.this.getUrl(), NettyClient.this);
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", adapter.getDecoder());
                pipeline.addLast("encoder", adapter.getEncoder());
                pipeline.addLast("handler", (org.jboss.netty.channel.ChannelHandler)nettyHandler);
                return pipeline;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doConnect() throws Throwable {
        start = System.currentTimeMillis();
        future = this.bootstrap.connect((SocketAddress)this.getConnectAddress());
        try {
            block14: {
                block15: {
                    ret = future.awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
                    if (!ret || !future.isSuccess()) break block15;
                    newChannel = future.getChannel();
                    newChannel.setInterestOps(5);
                    try {
                        oldChannel = this.channel;
                        if (oldChannel != null) {
                            try {
                                if (NettyClient.logger.isInfoEnabled()) {
                                    NettyClient.logger.info("Close old netty channel " + oldChannel + " on create new netty channel " + newChannel);
                                }
                                oldChannel.close();
                                var8_6 = null;
                            }
                            catch (Throwable var7_8) {
                                var8_7 = null;
                                NettyChannel.removeChannelIfDisconnected(oldChannel);
                                throw var7_8;
                            }
                            NettyChannel.removeChannelIfDisconnected(oldChannel);
                        }
                        var10_9 = null;
                        ** GOTO lbl49
                    }
                    catch (Throwable var9_17) {
                        block16: {
                            var10_10 = null;
                            if (!this.isClosed()) {
                                this.channel = newChannel;
                                throw var9_17;
                            }
                            try {
                                if (NettyClient.logger.isInfoEnabled()) {
                                    NettyClient.logger.info("Close new netty channel " + newChannel + ", because the client closed.");
                                }
                                newChannel.close();
                                var12_13 = null;
                                this.channel = null;
                            }
                            catch (Throwable var11_16) {
                                var12_14 = null;
                                this.channel = null;
                                NettyChannel.removeChannelIfDisconnected(newChannel);
                                throw var11_16;
                            }
lbl49:
                            // 1 sources

                            if (!this.isClosed()) break block16;
                            try {}
                            catch (Throwable var11_15) {
                                var12_12 = null;
                                this.channel = null;
                                NettyChannel.removeChannelIfDisconnected(newChannel);
                                throw var11_15;
                            }
                            if (NettyClient.logger.isInfoEnabled()) {
                                NettyClient.logger.info("Close new netty channel " + newChannel + ", because the client closed.");
                            }
                            newChannel.close();
                            var12_11 = null;
                            this.channel = null;
                            NettyChannel.removeChannelIfDisconnected(newChannel);
                            break block14;
                        }
                        this.channel = newChannel;
                        break block14;
                        NettyChannel.removeChannelIfDisconnected(newChannel);
                        throw var9_17;
                    }
                }
                if (future.getCause() == null) throw new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
                throw new RemotingException(this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + ", error message is:" + future.getCause().getMessage(), future.getCause());
            }
            var14_18 = null;
        }
        catch (Throwable var13_20) {
            var14_19 = null;
            if (this.isConnected() != false) throw var13_20;
            future.cancel();
            throw var13_20;
        }
        if (this.isConnected() != false) return;
        future.cancel();
    }

    protected void doDisConnect() throws Throwable {
        try {
            NettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    protected void doClose() throws Throwable {
    }

    protected Channel getChannel() {
        org.jboss.netty.channel.Channel c = this.channel;
        if (c == null || !c.isConnected()) {
            return null;
        }
        return NettyChannel.getOrAddChannel(c, this.getUrl(), this);
    }
}

