/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String read(Reader reader, int length) {
        try {
            int len;
            char[] buffer = new char[length];
            int offset = 0;
            int rest = length;
            while ((len = reader.read(buffer, offset, rest)) != -1) {
                offset += len;
                if ((rest -= len) != 0) continue;
            }
            return new String(buffer, 0, length - rest);
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }

    public static String toString(StackTraceElement[] stackTrace) {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement item : stackTrace) {
            buf.append(item.toString());
            buf.append("\n");
        }
        return buf.toString();
    }
}

