/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableStat {
    int selectCount = 0;
    int updateCount = 0;
    int deleteCount = 0;
    int insertCount = 0;
    int dropCount = 0;
    int mergeCount = 0;
    int createCount = 0;
    int alterCount = 0;
    int createIndexCount = 0;

    public int getCreateIndexCount() {
        return this.createIndexCount;
    }

    public void incrementCreateIndexCount() {
        ++this.createIndexCount;
    }

    public int getAlterCount() {
        return this.alterCount;
    }

    public void incrementAlterCount() {
        ++this.alterCount;
    }

    public int getCreateCount() {
        return this.createCount;
    }

    public void incrementCreateCount() {
        ++this.createCount;
    }

    public int getMergeCount() {
        return this.mergeCount;
    }

    public void incrementMergeCount() {
        ++this.mergeCount;
    }

    public int getDropCount() {
        return this.dropCount;
    }

    public void incrementDropCount() {
        ++this.dropCount;
    }

    public void setDropCount(int dropCount) {
        this.dropCount = dropCount;
    }

    public int getSelectCount() {
        return this.selectCount;
    }

    public void incrementSelectCount() {
        ++this.selectCount;
    }

    public void setSelectCount(int selectCount) {
        this.selectCount = selectCount;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void incrementUpdateCount() {
        ++this.updateCount;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    public int getDeleteCount() {
        return this.deleteCount;
    }

    public void incrementDeleteCount() {
        ++this.deleteCount;
    }

    public void setDeleteCount(int deleteCount) {
        this.deleteCount = deleteCount;
    }

    public void incrementInsertCount() {
        ++this.insertCount;
    }

    public int getInsertCount() {
        return this.insertCount;
    }

    public void setInsertCount(int insertCount) {
        this.insertCount = insertCount;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(4);
        if (this.mergeCount > 0) {
            buf.append("Merge");
        }
        if (this.insertCount > 0) {
            buf.append("Insert");
        }
        if (this.updateCount > 0) {
            buf.append("Update");
        }
        if (this.selectCount > 0) {
            buf.append("Select");
        }
        if (this.deleteCount > 0) {
            buf.append("Delete");
        }
        if (this.dropCount > 0) {
            buf.append("Drop");
        }
        if (this.createCount > 0) {
            buf.append("Create");
        }
        if (this.alterCount > 0) {
            buf.append("Alter");
        }
        if (this.createIndexCount > 0) {
            buf.append("CreateIndex");
        }
        return buf.toString();
    }

    public static enum Mode {
        Insert(1),
        Update(2),
        Delete(4),
        Select(8),
        Merge(16),
        Truncate(32);

        public final int mark;

        private Mode(int mark) {
            this.mark = mark;
        }
    }

    public static class Column {
        private String table;
        private String name;
        private Map<String, Object> attributes = new HashMap<String, Object>();

        public Column() {
        }

        public Column(String table, String name) {
            this.table = table;
            this.name = name;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public int hashCode() {
            int tableHashCode = this.table != null ? this.table.toLowerCase().hashCode() : 0;
            int nameHashCode = this.name != null ? this.name.toLowerCase().hashCode() : 0;
            return tableHashCode + nameHashCode;
        }

        public String toString() {
            if (this.table != null) {
                return this.table + "." + this.name;
            }
            return this.name;
        }

        public boolean equals(Object obj) {
            Column column = (Column)obj;
            if (this.table == null ? column.getTable() != null : !this.table.equalsIgnoreCase(column.getTable())) {
                return false;
            }
            return !(this.name == null ? column.getName() != null : !this.name.equalsIgnoreCase(column.getName()));
        }
    }

    public static class Condition {
        private Column column;
        private String operator;
        private List<Object> values = new ArrayList<Object>();

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Condition other = (Condition)obj;
            if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
                return false;
            }
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            return this.column.toString() + " " + this.operator;
        }
    }

    public static class Relationship {
        private Column left;
        private Column right;
        private String operator;

        public Column getLeft() {
            return this.left;
        }

        public void setLeft(Column left) {
            this.left = left;
        }

        public Column getRight() {
            return this.right;
        }

        public void setRight(Column right) {
            this.right = right;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Relationship other = (Relationship)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.operator == null ? other.operator != null : !this.operator.equals(other.operator)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        public String toString() {
            return this.left + " " + this.operator + " " + this.right;
        }
    }

    public static class Name {
        private String name;

        public Name(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.toLowerCase().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Name)) {
                return false;
            }
            Name other = (Name)o;
            return this.name.equalsIgnoreCase(other.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

