/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.stat.JdbcConnectionStat;
import com.alibaba.druid.stat.JdbcDataSourceStatMBean;
import com.alibaba.druid.stat.JdbcResultSetStat;
import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.stat.JdbcStatementStat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.JMException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class JdbcDataSourceStat
implements JdbcDataSourceStatMBean {
    private final String name;
    private final String url;
    private final JdbcConnectionStat connectionStat = new JdbcConnectionStat();
    private final JdbcResultSetStat resultSetStat = new JdbcResultSetStat();
    private final JdbcStatementStat statementStat = new JdbcStatementStat();
    private int maxSize = 1000;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final LinkedHashMap<String, JdbcSqlStat> sqlStatMap = new LinkedHashMap(this.maxSize, 0.75f, false);
    private final ConcurrentMap<Long, JdbcConnectionStat.Entry> connections = new ConcurrentHashMap<Long, JdbcConnectionStat.Entry>();

    public JdbcDataSourceStat(String name, String url) {
        this.name = name;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.connectionStat.reset();
        this.statementStat.reset();
        this.resultSetStat.reset();
        this.lock.writeLock().lock();
        try {
            Iterator<Map.Entry<String, JdbcSqlStat>> iter = this.sqlStatMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, JdbcSqlStat> entry = iter.next();
                JdbcSqlStat stat = entry.getValue();
                if (stat.getExecuteCount() == 0L) {
                    iter.remove();
                    continue;
                }
                stat.reset();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (JdbcConnectionStat.Entry connectionStat : this.connections.values()) {
            connectionStat.reset();
        }
    }

    public JdbcConnectionStat getConnectionStat() {
        return this.connectionStat;
    }

    public JdbcResultSetStat getResultSetStat() {
        return this.resultSetStat;
    }

    public JdbcStatementStat getStatementStat() {
        return this.statementStat;
    }

    @Override
    public String getConnectionUrl() {
        return this.url;
    }

    @Override
    public TabularData getSqlList() throws JMException {
        Map<String, JdbcSqlStat> sqlStatMap = this.getSqlStatMap();
        CompositeType rowType = JdbcSqlStat.getCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("SqlListStatistic", "SqlListStatistic", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        for (Map.Entry<String, JdbcSqlStat> entry : sqlStatMap.entrySet()) {
            data.put(entry.getValue().getCompositeData());
        }
        return data;
    }

    public static StatFilter getStatFilter(DataSourceProxy dataSource) {
        for (Filter filter : dataSource.getProxyFilters()) {
            if (!(filter instanceof StatFilter)) continue;
            return (StatFilter)filter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSqlStat getSqlStat(long id) {
        this.lock.readLock().lock();
        try {
            for (Map.Entry<String, JdbcSqlStat> entry : this.sqlStatMap.entrySet()) {
                if (entry.getValue().getId() != id) continue;
                JdbcSqlStat jdbcSqlStat = entry.getValue();
                return jdbcSqlStat;
            }
            JdbcSqlStat jdbcSqlStat = null;
            return jdbcSqlStat;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public final ConcurrentMap<Long, JdbcConnectionStat.Entry> getConnections() {
        return this.connections;
    }

    @Override
    public TabularData getConnectionList() throws JMException {
        CompositeType rowType = JdbcConnectionStat.Entry.getCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("ConnectionListStatistic", "ConnectionListStatistic", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        for (Map.Entry entry : this.getConnections().entrySet()) {
            data.put(((JdbcConnectionStat.Entry)entry.getValue()).getCompositeData());
        }
        return data;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JdbcSqlStat> getSqlStatMap() {
        HashMap<String, JdbcSqlStat> map = new HashMap<String, JdbcSqlStat>();
        this.lock.readLock().lock();
        try {
            map.putAll(this.sqlStatMap);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSqlStat getSqlStat(String sql) {
        this.lock.readLock().lock();
        try {
            JdbcSqlStat jdbcSqlStat = this.sqlStatMap.get(sql);
            return jdbcSqlStat;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSqlStat createSqlStat(String sql) {
        this.lock.writeLock().lock();
        try {
            JdbcSqlStat sqlStat = this.sqlStatMap.get(sql);
            if (sqlStat == null) {
                sqlStat = new JdbcSqlStat(sql);
                this.sqlStatMap.put(sql, sqlStat);
            }
            JdbcSqlStat jdbcSqlStat = sqlStat;
            return jdbcSqlStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public long getConnectionActiveCount() {
        return this.connections.size();
    }

    @Override
    public long getConnectionConnectAliveMillis() {
        long nowNano = System.nanoTime();
        long aliveNanoSpan = this.getConnectionStat().getAliveTotal();
        for (JdbcConnectionStat.Entry connection : this.connections.values()) {
            aliveNanoSpan += nowNano - connection.getEstablishNano();
        }
        return aliveNanoSpan / 1000000L;
    }

    public long getConnectionConnectAliveMillisMax() {
        long max = this.getConnectionStat().getAliveNanoMax();
        long nowNano = System.nanoTime();
        for (JdbcConnectionStat.Entry connection : this.connections.values()) {
            long connectionAliveNano = nowNano - connection.getEstablishNano();
            if (connectionAliveNano <= max) continue;
            max = connectionAliveNano;
        }
        return max / 1000000L;
    }

    public long getConnectionConnectAliveMillisMin() {
        long min = this.getConnectionStat().getAliveNanoMin();
        long nowNano = System.nanoTime();
        for (JdbcConnectionStat.Entry connection : this.connections.values()) {
            long connectionAliveNano = nowNano - connection.getEstablishNano();
            if (connectionAliveNano >= min && min != 0L) continue;
            min = connectionAliveNano;
        }
        return min / 1000000L;
    }

    @Override
    public long[] getConnectionHistogramRanges() {
        return this.connectionStat.getHistogramRanges();
    }

    @Override
    public long[] getConnectionHistogramValues() {
        return this.connectionStat.getHistorgramValues();
    }
}

