/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.parser;

import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelect;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.Top;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class SQLServerSelectParser
extends SQLSelectParser {
    public SQLServerSelectParser(String sql) {
        super(new SQLServerExprParser(sql));
    }

    public SQLServerSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLSelect select() throws ParserException {
        SQLServerSelect select = new SQLServerSelect();
        select.setQuery(this.query());
        select.setOrderBy(this.parseOrderBy());
        if (select.getOrderBy() == null) {
            select.setOrderBy(this.parseOrderBy());
        }
        return select;
    }

    @Override
    public SQLSelectQuery query() throws ParserException {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        SQLServerSelectQueryBlock queryBlock = new SQLServerSelectQueryBlock();
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.TOP) {
                Top top = new Top();
                this.lexer.nextToken();
                top.setExpr(this.createExprParser().primary());
                queryBlock.setTop(top);
            }
            this.parseSelectList(queryBlock);
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        return this.queryRest(queryBlock);
    }

    protected SQLExprParser createExprParser() {
        return new SQLServerExprParser(this.lexer);
    }
}

