/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGAggregateExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGOrderBy;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGAnalytic;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class PGExprParser
extends SQLExprParser {
    public PGExprParser(String sql) throws ParserException {
        super(new PGLexer(sql));
        this.lexer.nextToken();
    }

    public PGExprParser(Lexer lexer) {
        super(lexer);
    }

    @Override
    protected SQLAggregateExpr parseAggregateExpr(String method_name) throws ParserException {
        PGAggregateExpr aggregateExpr;
        if (this.lexer.token() == Token.ALL) {
            aggregateExpr = new PGAggregateExpr(method_name, 1);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DISTINCT) {
            aggregateExpr = new PGAggregateExpr(method_name, 0);
            this.lexer.nextToken();
        } else {
            aggregateExpr = new PGAggregateExpr(method_name, 1);
        }
        this.exprList(aggregateExpr.getArguments());
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.OVER) {
            this.lexer.nextToken();
            PGAnalytic over = new PGAnalytic();
            this.accept(Token.LPAREN);
            if (this.identifierEquals("PARTITION")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprList(over.getPartitionBy());
                    this.accept(Token.RPAREN);
                } else {
                    this.exprList(over.getPartitionBy());
                }
            }
            over.setOrderBy(this.parseOrderBy());
            if (over.getOrderBy() != null) {
                // empty if block
            }
            this.accept(Token.RPAREN);
            aggregateExpr.setOver(over);
        }
        return aggregateExpr;
    }

    @Override
    public PGOrderBy parseOrderBy() {
        if (this.lexer.token() == Token.ORDER) {
            PGOrderBy orderBy = new PGOrderBy();
            this.lexer.nextToken();
            if (this.identifierEquals("SIBLINGS")) {
                this.lexer.nextToken();
                orderBy.setSibings(true);
            }
            this.accept(Token.BY);
            orderBy.getItems().add(this.parseSelectOrderByItem());
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                orderBy.getItems().add(this.parseSelectOrderByItem());
            }
            return orderBy;
        }
        return null;
    }
}

