/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;

public class OracleUpdateParser
extends SQLStatementParser {
    public OracleUpdateParser(String sql) throws ParserException {
        super(new OracleExprParser(sql));
    }

    public OracleUpdateParser(Lexer lexer) {
        super(new OracleExprParser(lexer));
    }

    @Override
    public OracleUpdateStatement parseUpdateStatement() throws ParserException {
        OracleUpdateStatement update = new OracleUpdateStatement();
        if (this.lexer.token() == Token.UPDATE) {
            this.lexer.nextToken();
            this.parseHints(update);
            if (this.identifierEquals("ONLY")) {
                update.setOnly(true);
            }
            SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
            update.setTableSource(tableSource);
            if (update.getAlias() == null || update.getAlias().length() == 0) {
                update.setAlias(this.as());
            }
        }
        this.parseSet(update);
        this.parseWhere(update);
        this.parseReturn(update);
        this.parseErrorLoging(update);
        return update;
    }

    private void parseErrorLoging(OracleUpdateStatement update) throws ParserException {
        if (this.identifierEquals("LOG")) {
            throw new ParserException("TODO");
        }
    }

    private void parseReturn(OracleUpdateStatement update) throws ParserException {
        if (this.identifierEquals("RETURN") || this.lexer.token() == Token.RETURNING) {
            SQLExpr item;
            this.lexer.nextToken();
            while (true) {
                item = this.exprParser.expr();
                update.getReturning().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.INTO);
            while (true) {
                item = this.exprParser.expr();
                update.getReturningInto().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
    }

    private void parseHints(OracleUpdateStatement update) throws ParserException {
        if (this.lexer.token() == Token.HINT) {
            throw new ParserException("TODO");
        }
    }

    private void parseWhere(OracleUpdateStatement update) throws ParserException {
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            update.setWhere(this.exprParser.expr());
        }
    }

    private void parseSet(OracleUpdateStatement update) throws ParserException {
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = new SQLUpdateSetItem();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLListExpr list = new SQLListExpr();
                this.exprParser.exprList(list.getItems());
                this.accept(Token.RPAREN);
                item.setColumn(list);
            } else {
                item.setColumn(this.exprParser.primary());
            }
            this.accept(Token.EQ);
            item.setValue(this.exprParser.expr());
            update.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }
}

