/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.config;

import com.alibaba.druid.proxy.DruidDriver;
import com.alibaba.druid.proxy.config.AbstractDruidFilterConfig;
import com.alibaba.druid.proxy.config.DruidFilterConfig;
import com.alibaba.druid.util.DruidLoaderUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DruidFilterConfigLoader {
    private static final String NAME_TAG = "name";
    private static final String VALUE_TAG = "value";
    private static final String CLAZZ_TAG = "class";
    private static final String CONFIG_CLAZZ_TAG = "configClass";

    public static void loadConfig(String config, List<AbstractDruidFilterConfig> druidFilterConfigList) throws SQLException {
        URL url = DruidFilterConfigLoader.findResource(config);
        if (url != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new File(url.getPath()));
                if (doc == null) {
                    return;
                }
                Node filtersNode = doc.getFirstChild();
                if (filtersNode == null) {
                    return;
                }
                NodeList filterNodeList = filtersNode.getChildNodes();
                for (int i = 0; i < filterNodeList.getLength(); ++i) {
                    Node filterNode = filterNodeList.item(i);
                    if (filterNode == null || filterNode.getNodeType() != 1 || filterNode.getAttributes().getNamedItem(NAME_TAG) == null) continue;
                    Node configClassNode = filterNode.getAttributes().getNamedItem(CONFIG_CLAZZ_TAG);
                    if (configClassNode != null && !"".equalsIgnoreCase(configClassNode.getNodeValue())) {
                        Class<?> configClass = DruidLoaderUtils.loadClass(configClassNode.getNodeValue());
                        if (configClass == null) continue;
                        try {
                            AbstractDruidFilterConfig druidFilterConfig = (AbstractDruidFilterConfig)configClass.newInstance();
                            if (filterNode.getAttributes().getNamedItem(NAME_TAG) != null) {
                                druidFilterConfig.setName(filterNode.getAttributes().getNamedItem(NAME_TAG).getNodeValue());
                            }
                            if (filterNode.getAttributes().getNamedItem(CLAZZ_TAG) != null) {
                                druidFilterConfig.setClazz(filterNode.getAttributes().getNamedItem(CLAZZ_TAG).getNodeValue());
                            }
                            NodeList propNodeList = filterNode.getChildNodes();
                            for (int j = 0; j < propNodeList.getLength(); ++j) {
                                Node propNode = propNodeList.item(j);
                                if (propNode == null || propNode.getNodeType() != 1) continue;
                                Node nameNode = propNode.getAttributes().getNamedItem(NAME_TAG);
                                Node valueNode = propNode.getAttributes().getNamedItem(VALUE_TAG);
                                if (nameNode == null || valueNode == null) continue;
                                Class[] partypes = new Class[]{String.class};
                                Method meth = null;
                                try {
                                    String name1 = "set" + nameNode.getNodeValue();
                                    meth = configClass.getMethod(name1, partypes);
                                    Object[] arglist = new Object[]{valueNode.getNodeValue()};
                                    meth.invoke((Object)druidFilterConfig, arglist);
                                    continue;
                                }
                                catch (SecurityException e) {
                                    continue;
                                }
                                catch (NoSuchMethodException e) {
                                    continue;
                                }
                                catch (IllegalArgumentException e) {
                                    continue;
                                }
                                catch (InvocationTargetException e) {
                                    // empty catch block
                                }
                            }
                            druidFilterConfigList.add(druidFilterConfig);
                        }
                        catch (InstantiationException e) {
                        }
                        catch (IllegalAccessException e) {
                        }
                        catch (SecurityException e) {}
                        continue;
                    }
                    DruidFilterConfig druidFilterConfig = new DruidFilterConfig();
                    if (filterNode.getAttributes().getNamedItem(NAME_TAG) != null) {
                        druidFilterConfig.setName(filterNode.getAttributes().getNamedItem(NAME_TAG).getNodeValue());
                    }
                    if (filterNode.getAttributes().getNamedItem(CLAZZ_TAG) != null) {
                        druidFilterConfig.setClazz(filterNode.getAttributes().getNamedItem(CLAZZ_TAG).getNodeValue());
                    }
                    druidFilterConfigList.add(druidFilterConfig);
                }
            }
            catch (ParserConfigurationException e) {
            }
            catch (SAXException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static URL findResource(String resource) throws SQLException {
        try {
            return new URL(resource);
        }
        catch (MalformedURLException e) {
            return DruidFilterConfigLoader.findClassLoaderResource(resource);
        }
    }

    private static URL findClassLoaderResource(String resource) throws SQLException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (url == null) {
            url = DruidDriver.class.getClassLoader().getResource(resource);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resource);
        }
        if (url == null) {
            throw new SQLException("config not found:" + resource);
        }
        return url;
    }
}

